;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.6/Rgc/optimize.scm ...      */
;*                                                                     */
;*    Auteur      :  Manuel SERRANO                                    */
;*    Creation    :  Fri Jun 28 09:29:43 1991                          */
;*    Last change :  Thu Nov 25 17:21:25 1993 (serrano)                */
;*                                                                     */
;*    Le module ou on detecte les optimisations possibles.             */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*     Le module                                                       */
;*---------------------------------------------------------------------*/
(module __rgc_optimize
   (import (__rgc_trap   "Rgc/trap.scm")
	   (__rgc_param  "Rgc/param.scm"))
   (export (prepare-optimisation nb-states states)
	   (compute-looping      s v a n)
	   (end-of-optimisation)
	   (looping?             state-num accept?)))

;*---------------------------------------------------------------------*/
;*     Les variables statics                                           */
;*---------------------------------------------------------------------*/
(define *t-looping* 'dummy)
(define *t-states-for-looping* 'dummy)

;*---------------------------------------------------------------------*/
;*     prepare-optimisation ...                                        */
;*---------------------------------------------------------------------*/
(define (prepare-optimisation nb-states states)
   (if *rgc-optim*
       (begin
	  (set! *t-looping* (make-vector nb-states 'not-yet))
	  (set! *t-states-for-looping* states) ) ) )
       
;*---------------------------------------------------------------------*/
;*     end-of-optimisation ... (juste pour que le gc puisse faire son  */
;*                              office)                                */
;*---------------------------------------------------------------------*/
(define (end-of-optimisation)
   (set! *t-looping* '())
   (set! *t-states-for-looping* '()) )

;*---------------------------------------------------------------------*/
;*     compute-looping ...                                             */
;*     ------------------------------------------------------------    */
;*     Un etat est un looping si:                                      */
;*        1. il est acceptant.                                         */
;*        2. Il n'existe que des transitions vers lui-meme.            */
;*        3. Aucune regle n'est trappee.                               */
;*---------------------------------------------------------------------*/
(define (compute-looping state-num vector accept? nb-states)
   (cond
      ((or (not *rgc-optim*) (not (vector-ref *t-looping* state-num)))
       #f)
      ((eq? (vector-ref *t-looping* state-num) 'not-yet)
       (vector-set! *t-looping* state-num
		    (and *rgc-optim*
			 (accept? state-num)
			 (not (trapped? (car (accept? state-num))))
			 (let loop ( (i 0) )
			    (if (=fx i nb-states)
				#t
				(if (=fx i state-num)
				    (loop (+fx 1 i))
				    (if (vector-ref vector i)
					#f
					(loop (+fx 1 i))))))))
       (vector-ref *t-looping* state-num))
      (else
       #t)))

;*---------------------------------------------------------------------*/
;*     compute-slow-looping ...                                        */
;*---------------------------------------------------------------------*/
(define (compute-slow-looping state-num accept?)
   (vector-set! *t-looping* state-num
		(and *rgc-optim*
		     (accept? state-num)
		     (not (trapped? (car (accept? state-num))))
		     (let loop ( (l (vector-ref *t-states-for-looping*
						state-num)) )
			(if (null? l)
			    #t
			    (if (or (not (char? (car (car l))))
				    (=fx (cdr (car l)) state-num))
				(loop (cdr l))
				#f))))))

;*---------------------------------------------------------------------*/
;*     looping? ...                                                    */
;*---------------------------------------------------------------------*/
(define (looping? state-num accept?)
   (if (not *rgc-optim*)
       #f
       (if (eq? (vector-ref *t-looping* state-num) 'not-yet)
	   (compute-slow-looping state-num accept?)
	   (vector-ref *t-looping* state-num) ) ) )





