;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/bigloo1.7/runtime1.7/Llib/unix-file.scm ...              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec  8 09:08:05 1993                          */
;*    Last change :  Sat Aug  6 15:08:12 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Tools to manipulate file name under Unix                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __unix_file
   (export (basename string)
	   (dirname  string)
	   (prefix  string)
	   (suffix   string)))

;*---------------------------------------------------------------------*/
;*    basename ...                                                     */
;*---------------------------------------------------------------------*/
(define (basename string)
   (let loop ((index (-fx (string-length string) 1)))
      (cond
	 ((=fx index -1)
	  string)
	 ((char=? (string-ref string index) #\/)
	  (substring string (+fx index 1) (string-length string)))
	 (else
	  (loop (-fx index 1))))))

;*---------------------------------------------------------------------*/
;*    prefix ...                                                       */
;*---------------------------------------------------------------------*/
(define (prefix string)
   (let ((len (-fx (string-length string) 1)))
      (let loop ((e len)
                 (s len))
         (cond
            ((<=fx s 0)
             (substring string 0 (+fx 1 e)))
            (else
             (if (and (eq? (string-ref string s) #\.)
                      (=fx e len))
                 (loop (-fx s 1) (- s 1))
                 (loop e (-fx s 1))))))))

;*---------------------------------------------------------------------*/
;*    dirname ...                                                      */
;*---------------------------------------------------------------------*/
(define (dirname string)
   (let ((len (-fx (string-length string) 1)))
      (let loop ((read len))
	 (cond
	    ((<=fx read 0)
	     ".")
	    ((char=? (string-ref string read) #\/)
	     (substring string 0 read))
	    (else
	     (loop (-fx read 1)))))))

;*---------------------------------------------------------------------*/
;*    suffix ...                                                       */
;*---------------------------------------------------------------------*/
(define (suffix string)
   (let ((len (string-length string)))
      (let loop ((read (-fx len 1)))
	 (cond
	    ((<fx read 0)
	     "")
	    ((char=? (string-ref string read) #\.)
	     (substring string (+fx read 1) len))
	    (else
	     (loop (-fx read 1)))))))
