;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.7/Ieee/symbols.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jul  4 15:05:26 1992                          */
;*    Last change :  Thu Jun 16 08:54:22 1994 (serrano)                */
;*                                                                     */
;*    6.4. Symbols (page 18, r4)                                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_symbols_6_4
   (foreign (define bool    c-symbol?        (obj)     "SYMBOLP")
	    (define obj     c-string->symbol (string)  "c_string_to_symbol")
	    (define bstring c-symbol->string (bsymbol) "SYMBOL_TO_STRING")
	    (define obj     c-symbol-plist   (bsymbol) "GET_SYMBOL_PLIST")
	    (define obj     set-symbol-plist (bsymbol obj) "SET_SYMBOL_PLIST")
	    (define bool    symbol-exists?   (string)  "symbol_exists_p"))
   (export  (inline symbol? obj)
	    (inline symbol->string symbol)
	    (inline string->symbol string)
	    (symbol-append . symbols)
	    (symbol-plist symbol)
	    (getprop symbol key)
	    (putprop! symbol key val)
	    (remprop! symbol key)
	    gensym)
   (pragma  (c-string->symbol _imbricable_)
	    (c-symbol? _no_side_effect_ _imutable_
		       _no_mutation_ _imbricable_)))

;*---------------------------------------------------------------------*/
;*    symbol? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (symbol? obj)
   (c-symbol? obj))

;*---------------------------------------------------------------------*/
;*    symbol->string ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (symbol->string symbol)
   (c-symbol->string symbol))

;*---------------------------------------------------------------------*/
;*    string->symbol ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (string->symbol string)
   (c-string->symbol string))

;*---------------------------------------------------------------------*/
;*    symbol-append ...                                                */
;*---------------------------------------------------------------------*/
(define (symbol-append . list)
   (string->symbol (if (null? list)
		       ""
		       (let loop ((list list))
			  (if (null? (cdr list))
			      (symbol->string (car list))
			      (c-string-append (symbol->string (car list))
					       (loop (cdr list))))))))

;*---------------------------------------------------------------------*/
;*    gensym ...                                                       */
;*---------------------------------------------------------------------*/
(define gensym
   (let ((counter 999))
      (lambda string
	 (let ((string (cond
			  ((null? string)
			   ":-D.")
			  ((symbol? (car string))
			   (symbol->string (car string)))
			  ((string? (car string))
			   (car string))
			  (else
			   (error "gensym"
				  "Illegal argument"
				  (car string))))))
	    (let loop ()
	       (set! counter (+fx counter 1))
	       (let ((name (string-append string (integer->string counter))))
		  (if (not (symbol-exists? name))
		      (string->symbol name)
		      (loop))))))))

;*---------------------------------------------------------------------*/
;*    symbol-plist ...                                                  */
;*---------------------------------------------------------------------*/
(define (symbol-plist symbol)
   (c-symbol-plist symbol))

;*---------------------------------------------------------------------*/
;*    getprop ...                                                      */
;*---------------------------------------------------------------------*/
(define (getprop symbol key)
   (let loop ((pl (symbol-plist symbol)))
      (cond
	 ((null? pl)
	  #f)
	 ((eq? (car pl) key)
	  (cadr pl))
	 (else
	  (loop (cddr pl))))))

;*---------------------------------------------------------------------*/
;*    putprop ...                                                      */
;*---------------------------------------------------------------------*/
(define (putprop! symbol key val)
   (let loop ((pl (symbol-plist symbol)))
      (cond
	 ((null? pl)
	  (let ((new (cons* key val (symbol-plist symbol))))
	     (set-symbol-plist symbol new)
	     new))
	 ((eq? (car pl) key)
	  (set-car! (cdr pl) val))
	 (else
	  (loop (cddr pl))))))

;*---------------------------------------------------------------------*/
;*    remprop! ...                                                     */
;*---------------------------------------------------------------------*/
(define (remprop! symbol key)
   (let loop ((old '())
	      (l   (symbol-plist symbol)))
      (cond
	 ((null? l)
	  #f)
	 ((eq? (car l) key)
	  (cond
	     ((pair? old)
	      (set-cdr! old (cddr l)))
	     (else
	      (set-symbol-plist symbol (cddr l)))))
	 (else
	  (loop l (cddr l))))))

