;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.7/Eval/expd-try.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Sep  1 16:21:59 1992                          */
;*    Last change :  Thu Nov 24 08:30:07 1994 (serrano)                */
;*                                                                     */
;*    L'expansion de la forme try                                      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander_try
   (export (expand-try <expression> <expander>)))

;*---------------------------------------------------------------------*/
;*    expand-try ...                                                   */
;*---------------------------------------------------------------------*/
(define (expand-try x e)
   (match-case x
      ((?- (and ?body (not ())) ?handler)
       (e `(let* ((handler      ,handler)
		  (body         (lambda () ,body))
		  (lambda-stack (get-lambda-stack))
		  (res          (bind-exit (escape)
					   (add-error-handler! handler escape)
					   (let ((res (body)))
                                              (remove-error-handler!)
                                              res))))
	      ;; maintenant que le handler a ete invoque, il faut penser
	      ;; a nettoyer la pile des lambda
	      (set-lambda-stack! lambda-stack)
	      res)
	  e))
      (else
       (error "try" "Illegal form" x))))
