/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.7/Clib/vector.c ...         */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec 10 14:55:28 1991                          */
/*    Last change :  Fri Nov  4 14:13:24 1994 (serrano)                */
/*                                                                     */
/*    La gestion des vecteurs                                          */
/*---------------------------------------------------------------------*/
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    fill_vector ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
fill_vector( bvector, blen, init )
obj_t  bvector;
obj_t  blen;
obj_t  init;
{
	obj_t *walker;
	long   len = CINT( blen );

	/* on fait la `strength reduction' a la main car ce code est  */
	/* critique donc on veut etre sur qu'il bombarde.             */
	for( walker = (obj_t *)(&VECTOR_REF( bvector, BINT( 0 ))); len; len-- )
	   *walker++ = init;

	return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    create_vector ...                                                */
/*---------------------------------------------------------------------*/
obj_t
create_vector( klen )
obj_t  klen;
{
   obj_t vector;
 
   long  len = CINT( klen );
   obj_t aux;

	if( len & ~(VECTOR_LENGTH_MASK) )
	   the_failure( CSTRING_TO_BSTRING( "make_vector" ),
						 CSTRING_TO_BSTRING( "vector too large" ),
						 klen );
	else
	{
		vector = ALLOCATE( VECTOR_SIZE + ( len * OBJ_SIZE ) );
#if( !defined( TAG_VECTOR ) )		
		vector->vector_t.header = HEADER_VECTOR;
#endif		
		vector->vector_t.length = klen;

		return BVECTOR( vector );
	}
}

/*---------------------------------------------------------------------*/
/*    make_vector ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
make_vector( klen, init )
obj_t  klen;
obj_t  init;
{
   obj_t vector;

	vector = create_vector( klen );
	fill_vector( vector, klen, init );
	
	return BVECTOR( vector );
}



