/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*    .../inline-alloc.c ...                                           */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Sep 21 15:33:10 1994                          */
/*    Last change :  Tue Dec 27 16:52:36 1994 (serrano)                */
/*    -------------------------------------------------------------    */
/*    On fait des fonctions d'allocations specialisees pour les cons   */
/*    et les flottants.                                                */
/*=====================================================================*/

#if( GC == BOEHM_GC )

#ifndef GC_PRIVATE_H
#  include <gc_private.h>
#endif
#undef abs

#if defined( NULL )
#   undef NULL
#endif

#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    make_pair ...                                                    */
/*---------------------------------------------------------------------*/
obj_t 
make_pair( car, cdr )
obj_t car, cdr;
{
#define NUMBER_OF_CONS_WORDS (long)BYTES_TO_WORDS( PAIR_SIZE )
   ptr_t op;
   ptr_t *opp;
   DCL_LOCK_STATE;
	
   opp = &(GC_objfreelist[ NUMBER_OF_CONS_WORDS ]);
	
   FASTLOCK();

   if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 )
   {
      FASTUNLOCK();
      op = GC_generic_malloc_words_small( NUMBER_OF_CONS_WORDS, NORMAL );
   }
   else
   {
      *opp = obj_link(op);
      GC_words_allocd += NUMBER_OF_CONS_WORDS;
      FASTUNLOCK();
   }

#if( !defined( TAG_PAIR ) )
   (((obj_t)op)->pair_t).header = HEADER_PAIR;
#endif
   (((obj_t)op)->pair_t).car    = car;
   (((obj_t)op)->pair_t).cdr    = cdr;
	
   return BPAIR( (obj_t)op );
#undef NUMBER_OF_CONS_WORDS
}
    
/*---------------------------------------------------------------------*/
/*    make_cell ...                                                    */
/*---------------------------------------------------------------------*/
obj_t 
make_cell( value )
obj_t value;
{
#define NUMBER_OF_CELL_WORDS (long)BYTES_TO_WORDS( CELL_SIZE )
   ptr_t op;
   ptr_t *opp;
   DCL_LOCK_STATE;
	
   opp = &(GC_objfreelist[ NUMBER_OF_CELL_WORDS ]);
	
   FASTLOCK();

   if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 )
   {
      FASTUNLOCK();
      op = GC_generic_malloc_words_small( NUMBER_OF_CELL_WORDS, NORMAL );
   }
   else
   {
      *opp = obj_link(op);
      GC_words_allocd += NUMBER_OF_CELL_WORDS;
      FASTUNLOCK();
   }

#if( !defined( TAG_CELL ) )
   (((obj_t)op)->cell_t).header = HEADER_CELL;
#endif
   (((obj_t)op)->cell_t).obj    = value;
	
   return BCELL( (obj_t)op );
#undef NUMBER_OF_CELL_WORDS
}
    
/*---------------------------------------------------------------------*/
/*    make_real ...                                                    */
/*---------------------------------------------------------------------*/
obj_t 
make_real( d )
double d;
{
   ptr_t op;
   ptr_t *opp;
   DCL_LOCK_STATE;

#define NUMBER_OF_FLOAT_WORDS BYTES_TO_WORDS( REAL_SIZE )

   opp =  &(GC_aobjfreelist[ NUMBER_OF_FLOAT_WORDS ]);
   FASTLOCK();
   
   if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 )
   {
      FASTUNLOCK();
      op = GC_generic_malloc_words_small( NUMBER_OF_FLOAT_WORDS, PTRFREE );
   }
   else
   {
      *opp = obj_link(op);
      GC_words_allocd += NUMBER_OF_FLOAT_WORDS;
      FASTUNLOCK();
   }

#if( !defined( TAG_REAL ) )
   (((obj_t)op)->real_t).header = HEADER_REAL;
#endif
   (((obj_t)op)->real_t).real   = d;  

   return BREAL( (obj_t)op );
}

#else

/*---------------------------------------------------------------------*/
/*    make_real ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
make_real( real )
double real;
{
   obj_t a_real, aux;

   a_real = MAKE_ATOMIC_OBJECT( REAL_SIZE, HEADER_REAL, aux );
	
#if( !defined( TAG_REAL ) )
   a_real->real_t.header = HEADER_REAL;
#endif
	a_real->real_t.real = real;
	
	return BREAL( a_real );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    make_cell ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
make_cell( value )
obj_t value;
{
	obj_t aux, a_cell;

	a_cell = ALLOCATE( CELL_SIZE );
	
#if( !defined( TAG_CELL ) )
   a_cell->cell_t.header = HEADER_CELL;
#endif
   a_cell->cell_t.obj    = value;
	
   return BCELL( (obj_t)a_cell );
}
	
#endif

