/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.7/Clib/foreign.c ...        */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Oct 19 08:45:22 1993                          */
/*    Last change :  Thu Sep 29 08:28:46 1994 (serrano)                */
/*    -------------------------------------------------------------    */
/*    La gestion de l'interface etrangere                              */
/*=====================================================================*/
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Les recuperations externes                                       */
/*---------------------------------------------------------------------*/
extern obj_t the_failure();
extern obj_t make_vector();
extern long get_hash_number_from_int();

/*---------------------------------------------------------------------*/
/*    Quelques variables statics                                       */
/*---------------------------------------------------------------------*/
static obj_t addtab;
static obj_t c_addtab;

/*---------------------------------------------------------------------*/
/*    init_address_table ...                                           */
/*---------------------------------------------------------------------*/
void
init_address_table( )
{
	addtab   = make_vector( BINT( HASH_TABLE_SIZE ), BNIL );
	c_addtab = CREF( addtab );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    make_foreign ...                                                 */
/*---------------------------------------------------------------------*/
obj_t
make_foreign( id, value )
obj_t id;
void *value;
{
   obj_t foreign, dummy;
   
   foreign = MAKE_OBJECT( FOREIGN_SIZE, HEADER_FOREIGN, dummy );
   
   foreign->foreign_t.id    = id;
   foreign->foreign_t.value = value;
   
   return BREF( foreign );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    make_foreign ...                                                 */
/*---------------------------------------------------------------------*/
obj_t
allocate_foreign( id, size )
obj_t id;
long  size;
{
   void *value;
	
   value = (void *)ALLOCATE( size );

	/* pour ne pas etre dependant du GC, */
	/* on remplie la zone allouee de 0.  */
	memset( value, 0, size );
	
   return make_foreign( id, value );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    cforeign_to_bforeign ...                                         */
/*---------------------------------------------------------------------*/
obj_t
cforeign_to_bforeign( id, value )
obj_t id;
void *value;
{
	long hash_number;
	obj_t bucket;

	hash_number = get_hash_power_number_from_int( (unsigned long)value,
																 HASH_TABLE_SIZE_SHIFT );
	bucket = *(obj_t *)(((long)&c_addtab->vector_t) +
                        VECTOR_SIZE + (OBJ_SIZE * hash_number));
   
   if( NULLP( bucket ) )
   {
      obj_t foreign = make_foreign( id, value );
      obj_t cell;

		cell = MAKE_PAIR( value, foreign );
		
      *(obj_t *)(((long)&c_addtab->vector_t) +
                  VECTOR_SIZE +
                  (OBJ_SIZE * hash_number)) = MAKE_PAIR( cell, BNIL );
      
      return foreign;
   }
   else
   {
      obj_t run = bucket, back = bucket;
      
      while( !NULLP( run ) && ((void *)(CAR( CAR( run ) )) != value ) )
         back = run, run = CDR( run );
      
      if( !NULLP( run ) )
         return CDR( CAR( run ) );
      else
      {
         obj_t foreign = make_foreign( id, value );
			obj_t cell;

			cell = MAKE_PAIR( value, foreign );
         SET_CDR( back, MAKE_PAIR( cell, BNIL ) );

         return foreign;
      }
   }
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bobj_to_cforeign ...                                             */
/*---------------------------------------------------------------------*/
obj_t
bobj_to_cforeign( exp )
obj_t exp;
{
   if( INTEGERP( exp ) )
      return (obj_t)CINT( exp );
   if( BOOLEANP( exp ) )
      return (obj_t)BBOOL_TO_CBOOL( exp );
   if( STRINGP( exp ) )
      return (obj_t)BSTRING_TO_CSTRING( exp );
   if( CHARP( exp ) )
      return (obj_t)((long)CCHAR( exp ));
   if( FOREIGNP( exp ) )
      return (obj_t)FOREIGN_VALUE( exp );
   if( REALP( exp ) )
      return the_failure( CSTRING_TO_BSTRING( "bobj->foreign" ),
			  CSTRING_TO_BSTRING( "Can't cast a real to foreign" ),
			  exp);
   else
      return the_failure( CSTRING_TO_BSTRING( "bobj->foreign" ),
			  CSTRING_TO_BSTRING( "Illegal object type" ),
			  exp);
}
