;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/vital.scm ...                */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Nov  2 17:35:36 1992                          */
;*    Last change :  Fri Nov 25 08:02:45 1994 (serrano)                */
;*                                                                     */
;*    On tests les choses qui sont vraiment vital et sans lesquelles   */
;*    on ne peut rien faire du tout.                                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module vital
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-vital))
   (static  var))

;*---------------------------------------------------------------------*/
;*    var ...                                                          */
;*---------------------------------------------------------------------*/
(define var var)

;*---------------------------------------------------------------------*/
;*    bar ...                                                          */
;*---------------------------------------------------------------------*/
(define (bar . l)
   l)

(set! bar 'toto)

;*---------------------------------------------------------------------*/
;*    foo ...                                                          */
;*---------------------------------------------------------------------*/
(define (foo x)
   (if (integer? x)
       (begin
	  (set! x #f)
	  (integer? x))
       #t))

;*---------------------------------------------------------------------*/
;*    vital:write ...                                                  */
;*---------------------------------------------------------------------*/
(define (vital:write s)
   (let ((p (open-output-string)))
      (write s p)
      (let* ((s (close-output-port p))
	     (p (open-input-string s)))
	 (let ((res (read p)))
	    (close-input-port p)
	    res))))

;*---------------------------------------------------------------------*/
;*    vital:hoist ...                                                  */
;*---------------------------------------------------------------------*/
(define cur_ref (make-cell 0))

(define (vital:hoist)
   (let ((x1 (let ((x2 (cell-ref cur_ref)))
		(begin
		   (cell-set! cur_ref (+fx x2 1))
		   x2)))
	 (x2 (let ((x2 (cell-ref cur_ref)))
		(begin
		   (cell-set! cur_ref (+fx x2 1))
		   x2))))
      (eq? x1 x2)))

;*---------------------------------------------------------------------*/
;*    Un bug dans le soft-typing (un truc qui ne se compilait pas).    */
;*---------------------------------------------------------------------*/
(let ((revtype2
       (labels ((revtype (parent t flag)
                         (let ((rev (lambda (q)
                                       (revtype t q #f))))
                            (if flag (rev 1)))))
          revtype)))
   (revtype2 1 2 #f))

;*---------------------------------------------------------------------*/
;*    point                                                            */
;*---------------------------------------------------------------------*/
(define-struct point x y)

;*---------------------------------------------------------------------*/
;*    test-vital ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-vital)
   (test-module "vital" "vital.scm" #f)
   (test "true" #t (not #f))
   (test "true" #t (not (not 4)))
   (test "true" (not (eq? #t #f)) (not #f))
   (test "false" #f (not #t))
   (test "begin" (begin 4 5) 5)
   (test "eq?" 1 1)
   (test "< 0" -1 -1)
   (test "-" (- 2) -2)
   (test "*" (* 2 -1) -2)
   (test "eq? char" (eq? #\a #\a) #t)
   (test "eq? char" (eq? #\a #\A) #F)
   (test "eq? char" (char->integer #\') 39)
   (test "eq? symbol" (eq? 'a 'a) #t)
   (test "eq? symbol" (eq? 'a 'A) #t)
   (test "eq? symbol" (eq? 'a 'b) #f)
   (test "define" bar 'toto)
   (test "application" ((lambda args 2)) 2)
   (test "application" ((lambda args 2) 1 2 3 4) 2)
   (test "set!" (foo 5) #f)
   (test "set!" (let ((v (integer? var))) (set! var 4) v) #f)
   (test "symbol" 't (string->symbol "T"))
   (let ((s "toto\"\\\ntiti"))
      (test "write" (vital:write s) s))
   (let* ((s    "toto n'est pas content")
	  (sp   "titi non plus")
	  (l    (list s s s sp sp s sp sp 'toto 'toto '#(1 2 3) #\a #\a #t #f))
	  (v    `#123(,l ,l ,l () ,(unspecified) 1.13 1.13 #a123
			 (point 1 2) (point 2 1) #<0010> #<0011>))
	  (vec  (make-vector 3 v))
	  (rep  (obj->string v)))
      (test "intext" (string->obj rep) v))
   (let* ((append! (lambda (x y)
		      (if (null? x)
			  y
			  (do ((a x b)
			       (b (cdr x) (cdr b)))
				((null? b)
				 (set-cdr! a y)
				 x)))))
	  (l1      '(1 2 3))
	  (l2      '(4 5 6)))
      (test "do" (append! l1 l2) '(1 2 3 4 5 6)))
   (test "hoist" (vital:hoist) #f))


	 



 
