;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/apply.scm ...                */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  3 10:58:26 1992                          */
;*    Last change :  Thu Jul 15 13:40:54 1993  (serrano)               */
;*                                                                     */
;*    On test differentes sortes d'apply                               */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module apply
   (import  (main "main.scm")
	    (alias-aux "alias-aux.scm"))
   (include "test.sch")
   (export  (test-apply)))
 
;*---------------------------------------------------------------------*/
;*    gtest1 ...                                                       */
;*---------------------------------------------------------------------*/
(define gtest1
   (lambda (x y)
      (+ x y)))

;*---------------------------------------------------------------------*/
;*    gtest2 ...                                                       */
;*---------------------------------------------------------------------*/
(define (gtest2 . x)
   (+ (car x) (cadr x)))

;*---------------------------------------------------------------------*/
;*    gtest3 ...                                                       */
;*---------------------------------------------------------------------*/
(define (gtest3 x . y)
   (+ x (car y)))

;*---------------------------------------------------------------------*/
;*    gtest4 ...                                                       */
;*---------------------------------------------------------------------*/
(define (gtest4)
   'foo)

;*---------------------------------------------------------------------*/
;*    gtest4b ...                                                      */
;*---------------------------------------------------------------------*/
(define (gtest4b . x)
   'foo)

;*---------------------------------------------------------------------*/
;*    gtest5 ...                                                       */
;*---------------------------------------------------------------------*/
(define (gtest5)
   (lambda ()
      'foo))

;*---------------------------------------------------------------------*/
;*    gtest6 ...                                                       */
;*---------------------------------------------------------------------*/
(define (gtest6)
   (lambda x
      'foo))

;*---------------------------------------------------------------------*/
;*    ltest1 ...                                                       */
;*---------------------------------------------------------------------*/
(define (ltest1 a b)
   (labels ((foo (x y)
		 (+ x y)))
      (apply foo (list (+ 1 a) (+ 1 b)))))

;*---------------------------------------------------------------------*/
;*    ltest2 ...                                                       */
;*---------------------------------------------------------------------*/
(define (ltest2 a b)
   (labels ((foo (x y)
		 (+ x (+ y (+ a b)))))
      foo))

;*---------------------------------------------------------------------*/
;*    ltest3 ...                                                       */
;*---------------------------------------------------------------------*/
(define (ltest3 a)
   (labels ((foo (z . x)
		(let loop ((x x))
		   (if (null? x)
		       a
		       (+ (car x) (loop (cdr x)))))))
      foo))

;*---------------------------------------------------------------------*/
;*    extern-apply ...                                                 */
;*---------------------------------------------------------------------*/
(define (extern-apply x)
   (apply foo1 x))

;*---------------------------------------------------------------------*/
;*    test-apply ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-apply)
   (test-module "apply" "apply.scm" #f)
   (test "extern apply" (extern-apply '(1)) 1)
   (test "gapply" (apply gtest1 '(1 3)) 4)
   (test "gapply" ((begin gtest1) 1 3) 4)
   (test "gapply" (apply gtest2 '(1 3)) 4)
   (test "gapply" ((begin gtest2) 1 3) 4)
   (test "gapply" (apply gtest3 '(1 3)) 4)
   (test "gapply" ((begin gtest3) 1 3) 4)
   (test "gapply" (apply (begin gtest1) '(1 3)) 4)
   (test "gapply" (apply (begin gtest2) '(1 3)) 4)
   (test "gapply" (apply (begin gtest3) '(1 3)) 4)
   (test "gapply" (apply gtest4 '()) 'foo)
   (test "gapply" (apply gtest4b '()) 'foo)
   (test "gapply" (apply (gtest5) '()) 'foo)
   (test "gapply" (apply (gtest6) '()) 'foo)
   (test "lapply" (ltest1 1 2) 5)
   (test "lapply" ((ltest2 2 3) 1 2) 8)
   (test "lapply" (apply (ltest2 2 3) (list 1 2)) 8)
   (test "lapply" ((ltest3 1) 0 2 3 4) 10)
   (test "lapply" (apply (ltest3 1) (list 0 2 3 4)) 10)
   (test "lapply" (apply (lambda (x y) (list x y)) '(1 2)) '(1 2))
   (test "napply" (apply cons 1 '(2)) '(1 . 2))
   (test "napply" (apply cons 1 2 '()) '(1 . 2))
   (test "aapply" (apply apply cons (list 1 2 '())) '(1 . 2))
   (test "mapply" (apply (lambda (z) z) 1 '()) 1)
   (test "mapply" (apply (lambda (z) z) '(1)) 1)
   (test "mapply" (apply (lambda (a z) z) '(1 2)) 2)
   (test "mapply" (apply (lambda (a z) z) 1 '(2)) 2)
   (test "mapply" (apply (lambda (a z) z) 1 2 '()) 2)
   (test "mapply" (apply (lambda (a b c z) z) '(1 2 3 4)) 4)
   (test "mapply" (apply (lambda (a b c z) z) 1 '(2 3 4)) 4)
   (test "mapply" (apply (lambda (a b c z) z) 1 2 '(3 4)) 4)
   (test "mapply" (apply (lambda (a b c z) z) 1 2 3 '(4)) 4)
   (test "mapply" (apply (lambda (a b c z) z) 1 2 3 4 '()) 4)
   (test "mapply" (apply (lambda (a b c d z) z) 1 2 3 4 '(5))5)
   (test "mapply" (apply (lambda (a b c d z) z) 1 2 3 4 5 '()) 5)
   (test "mapply" (apply (lambda (a b c d e z) z) 1 2 3 4 '(5 6)) 6)
   (test "mapply" (apply (lambda (a b c d e f z) z) 1 2 3 4 '(5 6 7)) 7)
   (test "mapply" (apply (lambda (a b . z) (car z)) 1 2 3 4 5 '(6 7)) 3)
   (test "mapply" (apply (lambda (a . z) (car z)) 1 2 3 4 '(5 6 7)) 2)
   (test "mapply" (apply (lambda (a b c d . z) (car z)) 1 2 3 4 '(5 6 7)) 5)
   (test "mapply" (apply (lambda (a b c d e . z) (car z)) 1 '(2 3 4 5 6 7)) 6)
   (test "mapply" (apply (lambda (a b c d e f . z) (car z)) 1 2 3 4 '(5 6 7)) 7))

	 



