;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/examples/Roman/roman.scm ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 22 08:44:51 1992                          */
;*    Last change :  Mon May 10 08:06:57 1993  (serrano)               */
;*                                                                     */
;*    On lit et on effectue des additions sur les nombres romains      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module roman (main main))

;*---------------------------------------------------------------------*/
;*    romain->arabe ...                                                */
;*---------------------------------------------------------------------*/
(define (romain->arabe r)
   (define (chiffre.romain->arabe chiffre)
      (case chiffre
	 ((#\m #\M) 1000)
	 ((#\d #\D) 500)
	 ((#\c #\C) 100)
	 ((#\l #\L) 50)
	 ((#\x #\X) 10)
	 ((#\v #\V) 5)
	 ((#\i #\I) 1)
	 (else
	  (error "chiffre" "Illegal char" chiffre))))
   (let ((len (string-length r)))
      (let loop ((indice 0))
      (cond
	 ((= indice len)
	  0)
	 ((= indice (- len 1))
	  (chiffre.romain->arabe (string-ref r indice)))
	 (else
	  (let ((x (chiffre.romain->arabe (string-ref r indice)))
		(y (chiffre.romain->arabe (string-ref r (+ 1 indice)))))
	     (if (< x y)
		 (+ (- x) (loop (+ 1 indice)))
		 (+ x (loop (+ 1 indice))))))))))

;*---------------------------------------------------------------------*/
;*    grammaire-romaine ...                                            */
;*---------------------------------------------------------------------*/
(define grammaire-romaine
   (let ((par-open 0))
      (regular-grammar ((arabe  (>-< #\0 #\9))
			(romain (in #\i #\I #\v #\V #\x #\X #\l #\L
				    #\c #\C #\d #\D #\m #\M)))
	 ((+ (in #\space #\newline #\tab))
	  (ignore))
	 ((+ arabe)
	  (string->integer (the-string)))
	 ((+ romain)
	  (romain->arabe (the-string)))
	 ((#\()
	  (let ((open-key par-open))
	     (set! par-open (+ 1 par-open))
	     (context 'pair)
	     (let loop-pair ((walk (ignore))) 
		(cond
		   ((= open-key par-open)
		    '())
		   (else
		    (cons walk (loop-pair (ignore))))))))
	 ((#\))
	  (set! par-open (- par-open 1))
	  (if (< par-open 0)
	      (begin
		 (set! par-open 0)
		 (ignore))
	      #f))
	 ((in #\+ #\- #\* #\\)
	  (string->symbol (the-string)))
	 (else
	  (let ((char (the-failing-char)))
	     (if (eof-object? char)
		 char
		 (error "grammaire-romaine" "Illegal char" char)))))))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (let ((prompt ":-) "))
      (display prompt)
      (let loop ((exp (read/rp grammaire-romaine (current-input-port))))
	 (if (eof-object? exp)
	     'done
	     (begin
		(display* (eval exp) #\Newline prompt)
		(loop (read/rp grammaire-romaine (current-input-port))))))))
