;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../expression.scm ...                                           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr 27 08:30:49 1994                          */
;*    Last change :  Sat Jul  2 12:53:10 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On `superlift' une expression                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module superlift_expression
   (include "Var/variable.sch"
	    "Lift/lift.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    tools_args
	    engine_param
	    scan_lexical)
   (export  (superlift-expression! exp)))

;*---------------------------------------------------------------------*/
;*    superlift-expression! ...                                        */
;*---------------------------------------------------------------------*/
(define (superlift-expression! exp)
   (let loop ((exp exp))
      (trace (lift loop) "superlift: " (shape exp)
	     #\Newline)
      (match-case exp
;*--- nil -------------------------------------------------------------*/
	 (()
	  exp)
;*--- atom ------------------------------------------------------------*/
	 ((atom ?-)
	  exp)
;*--- set! ------------------------------------------------------------*/
	 ((set! . ?-)
	  (set-car! (cddr exp) (loop (caddr exp)))
	  exp)
;*--- function --------------------------------------------------------*/
	 (((or function function-extra-light function-light) ?var)
	  exp)
;*--- quote -----------------------------------------------------------*/
	 ((quote ?-)
	  exp)
;*--- pragma ----------------------------------------------------------*/
	 ((pragma ?-)
	  exp)
;*--- cast ------------------------------------------------------------*/
	 ((cast ?- ?rest)
	  (set-car! (cddr exp) (loop rest))
	  exp)
;*--- failure ---------------------------------------------------------*/
	 ((failure . ?-)
	  (set-car! (cdr exp) (loop (cadr exp)))
	  (set-car! (cddr exp) (loop (caddr exp)))
	  (set-car! (cdddr exp) (loop (cadddr exp)))
	  exp)
;*--- cif -------------------------------------------------------------*/
	 ((cif . ?-)
	  (set-car! (cdr exp) (loop (cadr exp)))
	  (set-car! (cddr exp) (loop (caddr exp)))
	  (set-car! (cdddr exp) (loop (cadddr exp)))
	  exp)
;*--- typed-case ------------------------------------------------------*/
	 ((typed-case ?- ?test . ?clauses)
	  (set-car! (cddr exp) (loop test))
	  (let liip ((hook clauses))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! (cdar hook) (loop (cadr (car hook))))
		    (liip (cdr hook))))))
;*--- begin -----------------------------------------------------------*/
	 ((begin . ?body)
	  (let liip ((hook body))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! hook (loop (car hook)))
		    (liip (cdr hook))))))
;*--- let -------------------------------------------------------------*/
	 ((let . ?-)
	  ;; on superlift le body
	  (set-car! (cddr exp) (loop (caddr exp)))
	  ;; on superlift les bindings
	  (let liip ((bindings (cadr exp)))
	     (if (null? bindings)
		 exp
		 (let ((binding (car bindings)))
		    (set-car! (cdr binding) (loop (cadr binding)))
		    (liip (cdr bindings))))))
;*--- labels ----------------------------------------------------------*/
	 ((labels . ?-)
	  (superlift-labels exp))
;*--- block -----------------------------------------------------------*/
	 ((block . ?-)
	  (set-car! (cddr exp) (loop (caddr exp)))
	  exp)
;*--- return-from -----------------------------------------------------*/
	 ((return-from . ?-)
	  (set-car! (cddr exp) (loop (caddr exp)))
	  exp)
;*--- apply -----------------------------------------------------------*/
	 (((or apply
	    funcall
	    funcall-light
	    funcall-medium
	    (funcall-extra-light . ?-)) . ?-)
	  (let liip ((hook (cdr exp)))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! hook (loop (car hook)))
		    (liip (cdr hook))))))
;*--- application -----------------------------------------------------*/
	 (else
	  (superlift-application exp)))))

;*---------------------------------------------------------------------*/
;*    superlift-labels ...                                             */
;*---------------------------------------------------------------------*/
(define (superlift-labels exp)
   (trace lift "superlift-labels: " (shape exp) #\Newline)
   ;; on traite les liaisons puis le corps
   (let ((bindings (cadr exp))
	 (body     (caddr exp)))
      ;; c'est toujours la meme chose dans les labels, a cause
      ;; de recursions croisees il faut faire deux parcours des
      ;; liaisons
      (let liip ((bindings  bindings)
		 (nbindings bindings))
	 (if (null? bindings)
	     (set-car! (cdr exp) nbindings)
	     (let* ((binding (car bindings))
		    (fun     (car binding)))
		(trace lift "superlift-labels: " (shape fun) #\Newline
		            "         escape?: " (function-escape?
						  (local-value fun))
			    #\Newline
			    "     invocations: " (function-invocations (local-value fun))
			    #\Newline)
		(if (or (not (function-escape? (local-value fun)))
			(=fx (function-invocations (local-value fun)) 0))
		    ;; la fonction ne s'echappe pas on ne subit pas
		    ;; d'appel recursif.
		    (liip (cdr bindings) nbindings)
		    ;; il faut creer une nouvelle fonction
		    (let* ((new-var (create-superlift-local-function! fun))
			   (new-fun (local-value new-var)))
		       (set-car! (cdr binding)
				 (function-args (local-value fun)))
		       (set-car! (cddr binding)
				 (function-body (local-value fun)))
		       (liip (cdr bindings)
			     (cons `(,new-var ,(function-args new-fun)
					      ,(function-body new-fun))
				   nbindings)))))))
      (trace lift "superlift-labels: apres les laisons 1" #\Newline)
      ;; on a fini le premier parcours qui a cree des nouvelles liaisons,
      ;; on fait le deuxieme qui scanne les body
      (for-each (lambda (binding)
		   (set-car! (cddr binding)
			     (superlift-expression! (caddr binding))))
		(cadr exp))
      (trace lift "superlift-labels: apres les laisons 2" #\Newline)
      ;; il ne reste plus qu'a faire le corps principle
      (set-car! (cddr exp) (superlift-expression! body))
      exp))

;*---------------------------------------------------------------------*/
;*    create-superlift-local-function! ...                             */
;*    -------------------------------------------------------------    */
;*    On creer une fonction locale qui ressemble beaucoup a            */
;*    celle passe en argument puisqu'elles ont les memes arguments     */
;*    et que la nouvelle recupere le corps de la premiere ! En plus    */
;*    on trippote un peu la premiere en changeant son corps et son     */
;*    champs info.                                                     */
;*---------------------------------------------------------------------*/
(define (create-superlift-local-function! var)
   (let* ((old-fun  (local-value var))
	  (old-body (function-body old-fun))
	  (old-args (function-args old-fun))
	  (new-name (symbol-append (local-name var)
				   (gensym "super")))
	  (new-var  (cdar (allocate-local-functions (list new-name))))
	  (new-fun  (local-value new-var))
	  (new-args (map (lambda (v) (allocate-local-variable (local-name v)))
			 old-args)))
      ;; on ajuste la nouvelle fonction
      (function-args-set!    new-fun old-args)
      (function-body-set!    new-fun old-body)
      (function-arity-set!   new-fun (function-arity old-fun))
      (function-escape?-set! new-fun #f)
      ;; on ajuste l'ancienne
      (function-body-set! old-fun `(,new-var ,@new-args))
      (function-args-set! old-fun new-args)
      (local-info-set! var new-var)
      new-var))
      
;*---------------------------------------------------------------------*/
;*    superlift-application ...                                        */
;*---------------------------------------------------------------------*/
(define (superlift-application exp)
   ;; on lift les arguments
   (let liip ((hook exp))
      (if (null? hook)
	  exp
	  (begin
	     (set-car! hook (superlift-expression! (car hook)))
	     (liip (cdr hook)))))
   (let ((fun (car exp)))
      (cond
	 ((not (local? fun))
	  ;; ce n'est pas une fonction locale
	  exp)
	 ((not (function-escape? (local-value fun)))
	  ;; il n'y a rien a faire car soit ce n'est pas une
	  ;; variable globale soit c'est une locale qui ne s'echappe pas
	  exp)
	 ((=fx (function-invocations (local-value fun)) 0)
	  exp)
	 (else
	  ;; c'est une variable locale qui s'echappe
	  (set-car! exp (local-info fun))
	  exp))))




   
