;*=====================================================================*/
;*    .../property.sch ...                                             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jun 19 08:38:46 1994                          */
;*    Last change :  Mon Jul  4 16:48:17 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La structure de donnees pour memoriser et calculer les proprietes*/
;*    des variables locales en vue du deplacement d'allocation du tas  */
;*    vers la pile                                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    La structure `s-property'                                        */
;*---------------------------------------------------------------------*/
(define-struct s-property
   depth          ;; integer : la position dans la pile
                  ;;         : de la variable locale
   returned?      ;; boolean : la variable est-elle retournee
                  ;;         : (voir `property.scm')
   captured       ;; integer : l'indice eventuel des variables capturant
                  ;;         : `self'
   related        ;; local*  : les locales dependant de `self'
   stack-alloc?   ;; boolean : cette locale est-elle allouee en pile ?
   reference      ;; function: la fonction creant la ref sur la var
   let-binding    ;; exp     : le `let' liant la variable
   tail-binding?) ;; exp     : le `let' liant est-il en position tail ?
