;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../capture.scm ...                                              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jun 19 10:06:07 1994                          */
;*    Last change :  Tue Jun 21 08:18:45 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Le module qui contient l'implementation de la propriete          */
;*    `capture'.                                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module stack_capture
   (include "Var/variable.sch"
	    "Stack/property.sch"
	    "Tools/trace.sch")
   (import  stack_result
	    tools_shape)
   (export  (captured-by-an-older-variable local depth body stack)))

;*---------------------------------------------------------------------*/
;*    captured-by-an-older-variable ...                                */
;*---------------------------------------------------------------------*/
(define (captured-by-an-older-variable local depth let-exp stack)
   (trace (stack loop)
	  "captured-by-an-older-variable: " (shape local) " [" depth "]"
	  #\Newline)
   (let ((info (local-info local)))
      (cond
	 ((and (integer? (s-property-captured info))
	       (<=fx (s-property-captured info) depth))
	  (trace (stack loop)
		 "captured-by-an-older!: " (shape local) " already: "
		 (s-property-captured info)
		 #\Newline)
	  (s-property-captured info))
	 ((memq local stack)
	  (trace (stack loop)
		 "captured-by-an-older!: " (shape local)  " stack"
		 #\Newline)
	  #f)
	 (else
	  (let ((res (captured-by-an-older local depth let-exp (list local))))
	     (trace (stack loop)
		    "captured-by-an-older!: " (shape local) " " res
		    #\Newline)
	     (if (and (integer? res)
		      (<=fx res (s-property-captured info)))
		 (s-property-captured-set! info res))
	     res)))))

;*---------------------------------------------------------------------*/
;*    captured-by-an-older ...                                         */
;*---------------------------------------------------------------------*/
(define (captured-by-an-older local depth body stack)
   (if (not (pair? body))
       #f
       (case (car body)
	  ((quote function)
	   #f)
	  ((begin cif pragma failure)
	   (captured-by-an-older* local depth (cdr body) stack))
	  ((cif)
	   (captured-by-an-older* local depth (cdr body) stack))
	  ((set!)
	   (let ((val (captured-by-an-older local depth (caddr body) stack)))
	      (cond
		 ((integer? val)
		  val)
		 ((result? local (caddr body))
		  (let ((var-depth (variable-depth (cadr body))))
		     (if (<=fx var-depth depth)
			 var-depth
			 ;; On scan le let definissant la locale
			 ;; pour voir si elle est capturee.
			 ;; On sait que la locale n'est pas un parametre
			 ;; formel
			 (captured-by-an-older-variable
			  (car body)
			  depth
			  (s-property-let-binding (local-info (car body)))
			  (cons local stack)))))
		 (else
		  #f))))
	  ((typed-case)
	   (let ((test-K (captured-by-an-older local
					       depth
					       (caddr body)
					       stack)))
	      (if (integer? test-K)
		  test-K
		  (let loop ((clauses (cdddr body)))
		     (if (null? clauses)
			 #f
			 (let ((clause-K (captured-by-an-older
					  local
					  depth
					  (cadr (car clauses))
					  stack)))
			    (if (integer? clause-K)
				clause-K
				(loop (cdr clauses)))))))))
	  ((let)
	   #f)
	  ((labels)
	   #f)
	  ((block return-from)
	   #f)
	  ((apply funcall funcall-light)
	   #f)
	  (else
	   #f))))

;*---------------------------------------------------------------------*/
;*    captured-by-an-older* ...                                        */
;*---------------------------------------------------------------------*/
(define (captured-by-an-older* local depth bodies stack)
   (let loop ((bodies bodies))
      (if (null? bodies)
	  #f
	  (let ((body-K (captured-by-an-older local depth bodies stack)))
	     (if (integer? body-K)
		 body-K
		 (loop (cdr bodies)))))))

;*---------------------------------------------------------------------*/
;*    variable-depth ...                                               */
;*---------------------------------------------------------------------*/
(define (variable-depth var)
   (if (global? var)
       -1
       (s-property-depth (local-info var))))
