;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.7/Scan/let.scm ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Mar 21 12:04:45 1993                          */
;*    Last change :  Sat Nov 26 10:08:43 1994 (serrano)                */
;*                                                                     */
;*    La construction des formes `let' et `letrec'.                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module scan_let
   (include "Var/variable.sch"
	    "Tools/trace.sch")
   (import  engine_param
	    scan_lexical
	    scan_tree
	    scan_labels
	    heap_abstract
	    tools_args
	    tools_shape)
   (export  (make-let-tree exp site env)))

;*---------------------------------------------------------------------*/
;*    make-let-tree ...                                                */
;*---------------------------------------------------------------------*/
(define (make-let-tree exp site env)
   (make-smart-generic-let (make-generic-let exp site env)))

;*---------------------------------------------------------------------*/
;*    make-generic-let ...                                             */
;*---------------------------------------------------------------------*/
(define (make-generic-let exp site env)
   (trace init "make-generic-let: " #\Newline
	        "   exp   : " exp #\Newline
		"   site  : " site #\Newline
		"   env   : " (shape env) #\Newline #\Newline)
   (let* ((bindings   (cadr exp))
	  (body       (caddr exp))
	  (body-frame (allocate-local-variables (map car bindings)))
	  (new-env    (append body-frame env))
	  (local-env  (if (eq? (car exp) 'letrec)
			  new-env
			  env)))
      ;; on calcule le body
      (set-car! (cddr exp) (make-expression-tree body site new-env '()))
      (let loop ((bindings bindings))
	 (if (null? bindings)
	     exp
	     (let* ((local-def (car bindings))
		    (local-var (cdr (assq (car local-def) new-env))))
		(set-car! local-def local-var)
		(set-car! (cdr local-def)
			  (make-expression-tree (cadr local-def)
						site
						local-env
						'()))
		(loop (cdr bindings)))))))

;*---------------------------------------------------------------------*/
;*    make-smart-generic-let ...                                       */
;*---------------------------------------------------------------------*/
(define (make-smart-generic-let let-form)
   (trace init "make-smart-generic-let: " (shape let-form) #\Newline)
   (let loop ((bindings         (cadr let-form))
	      (lambda-bindings '())
	      (value-bindings  '()))
      (if (null? bindings)
	  (cond
	     ((null? lambda-bindings)
	      (letrec/let let-form #f))
	     ((null? value-bindings)
	      (let-form->labels-form lambda-bindings
				     (caddr let-form)))
	     (else
	      (letrec/let `(,(car let-form)
			    ,value-bindings
			    ,(let-form->labels-form lambda-bindings
						    (caddr let-form)))
			  #t)))
	  (match-case (car bindings)
	     ((?var (labels ((?aux ?args ?body)) ?aux))
	      ;; ceci est le cas d'une liaison sur une lambda
	      (if (eq? (local-access var) 'write)
		  ;; ah oui mais on c'est amuse a ecrire dans la variable
		  (loop (cdr bindings)
			lambda-bindings
			(cons (car bindings) value-bindings))
		  (loop (cdr bindings)
			(cons (car bindings) lambda-bindings)
			value-bindings)))
	     (else
	      (loop (cdr bindings)
		    lambda-bindings
		    (cons (car bindings) value-bindings)))))))

;*---------------------------------------------------------------------*/
;*    letrec/let ...                                                   */
;*---------------------------------------------------------------------*/
(define (letrec/let form with-labels?)
   (trace init "letrec/let: " (shape form) #\Newline)
   (if (eq? (car form) 'let)
       form
       (let loop ((old-bindings (cadr form))
		  (new-init     '()))
	  (if (null? old-bindings)
	      (let ((body (if with-labels?
			      (caddr form)
			      form)))
		 (set-car! form 'let)
		 (set-car! (cddr body) `(begin ,@new-init ,(caddr body)))
		 form)
	      (let ((init (cadr (car old-bindings))))
		 (set-car! (cdr (car old-bindings)) (abstract-unspecified))
		 (use-local! (car (car old-bindings)) 'write)
		 (loop (cdr old-bindings)
		       (cons `(set! ,(car (car old-bindings)) ,init)
			     new-init)))))))

;*---------------------------------------------------------------------*/
;*    let-form->labels-form ...                                        */
;*---------------------------------------------------------------------*/
(define (let-form->labels-form bindings body)
   (trace init "let-form->labels-form: " (shape bindings) #\Newline)
   (let loop ((obindings bindings)
	      (nbindings '()))
      (if (null? obindings)
	  `(labels ,nbindings ,body)
	  (match-case (car obindings)
	     ((?var (labels ((?aux ?args ?body)) ?aux))
	      ;; il faut :
	      ;;   - changer le type de `var'
	      ;;   - mettre la value de `var'
	      ;;   - remplacer les occurences de `aux' dans body
	      (let ((new-body (replace-in-body! body aux var)))
		 (local-class-set! var 'function)
		 (local-value-set! var (local-value aux))
		 (function-body-set! (local-value var) new-body)
		 (function-invocations-set! (local-value var)
					    (if (integer? (local-info var))
						(local-info var)
						0))
		 ;; de plus, si on est en mode *extra-debug*, il faut
		 ;; ajuster le corps de la fonction
		 (if *extra-debug*
		     (set-car! (cdr (cadr (cadr new-body)))
			       (local-debug-name var)))
		 (loop (cdr obindings)
		       (cons `(,var ,args ,new-body)
			     nbindings))))))))
	  
	     
;*---------------------------------------------------------------------*/
;*    replace-in-body! ...                                             */
;*---------------------------------------------------------------------*/
(define (replace-in-body! body quoi par)
   (if (not (pair? body))
       (if (eq? body quoi)
	   par
	   body)
       (let loop ((l body))
	  (cond
	     ((null? l)
	      body)
	     (else
	      (set-car! l (replace-in-body! (car l) quoi par))
	      (if (not (pair? (cdr l)))
		  (begin
		     (set-cdr! l (replace-in-body! (cdr l) quoi par))
		     body)
		  (loop (cdr l))))))))
  
 

