;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.7/Read/include.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 15:41:14 1993                          */
;*    Last change :  Wed Dec 28 17:32:07 1994 (serrano)                */
;*                                                                     */
;*    On lit des fichiers `include'                                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module read_include
   (import expand_eps
	   tools_speek
	   (*order-init-modules* engine_param))
   (export (read-include file)))

;*---------------------------------------------------------------------*/
;*    find-file ...                                                    */
;*---------------------------------------------------------------------*/
(define (find-file name)
   (if (file-exists? name)
       name
       (let loop ((path *load-path*))
	  (if (null? path)
	      name
	      (let ((try (string-append (car *load-path*) "/" name)))
		 (if (file-exists? try)
		     try
		     (loop (cdr path))))))))

;*---------------------------------------------------------------------*/
;*    read-include ...                                                 */
;*    name --> < import x include x sexp >                             */
;*---------------------------------------------------------------------*/
(define (read-include file)
   (verbose "      [reading include file " file "]" #\Newline)
   (let ((port (open-input-file (find-file file))))
      (if (not (input-port? port))
	  (error "read-include" "Can't open such file" file)
	  (let ((handler (lambda (escape proc mes obj)
			    (notify-error proc mes obj)
			    (input-port-display-error port
						      (current-error-port))
			    (fprint (current-error-port) "(file " file ")")
			    (close-input-port port)
			    (exit -3))))
	     (try (let* ((first      (read port))
			 (directives (if (and (pair? first)
					      (eq? (car first) 'directives))
					 first
					 '())))
		     (let loop ((r    (if (pair? directives)
					  (read port)
					  first))
				(sexp '()))
			(if (eof-object? r)
			    (begin
			       (close-input-port port)
			       (parse-include-directives directives
							 (reverse! sexp)))
			    (match-case r
			       ((define-macro . ?-)
				(add-macro! r)
				(loop (read port)
				      sexp))
			       ((define-expander . ?-)
				(add-macro! r)
				(loop (read port)
				      sexp))
			       (else
				(loop (read port)
				      (cons r sexp)))))))
		  handler)))))

;*---------------------------------------------------------------------*/
;*    parse-include-directives ...                                     */
;*---------------------------------------------------------------------*/
(define (parse-include-directives directives sexp)
   (let loop ((dir      (if (null? directives)
			    '()
			    (cdr directives)))
	      (import  '())
	      (include '())
	      (foreign '()))
      (if (null? dir)
	  (list import include sexp foreign)
	  (let ((r (car dir)))
	     (match-case r
		(((or use import) . ?rest)
		 (loop (cdr dir)
		       (append rest import)
		       include
		       foreign))
		((force . ?rest)
		 (set! *order-init-modules* (append *order-init-modules* rest))
		 (loop (cdr dir)
		       import
		       include
		       foreign))
		((include . ?file)
		 (loop (cdr dir)
		       import
		       (append file include)
		       foreign))
		((foreign . ?rest)
		 (loop (cdr dir)
		       import
		       include
		       (append rest foreign))))))))
	  
