;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Read/access.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 11:33:41 1993                          */
;*    Last change :  Mon May  3 12:50:34 1993  (serrano)               */
;*                                                                     */
;*    Le module qui fait toute la gestion des access `module/nom'      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module read_access
   (import engine_param
	   engine_engine)
   (export (add-access! module file)
	   (read-access-file)))

;*---------------------------------------------------------------------*/
;*    add-access! ...                                                  */
;*---------------------------------------------------------------------*/
(define (add-access! module file)
   (let ((b (assq module *access-table*)))
      (if (not b)
	  (set! *access-table* (cons (cons module file)
				     *access-table*))
	  (if (not (string=? (cdr b) file))
	      (error "add-access!" "access redefinition" module)
	      'done))))
	   
;*---------------------------------------------------------------------*/
;*    read-access-file ...                                             */
;*    -------------------------------------------------------------    */
;*    Cette fonction fait des effets de bords sur `*access-table*'     */
;*---------------------------------------------------------------------*/
(define (read-access-file)
   (cond
      ((not (string? *access-file*))
       'done)
      ((not (file-exists? *access-file*))
       (hello-world)
       (error "read-access-file"
	      "Can't find access file"
	      *access-file*))
      (else
       (let ((port (open-input-file *access-file*)))
	  (if (not (input-port? port))
	      (begin
		 (hello-world)
		 (error "read-access-file"
			"Can't open access file"
			*access-file*))
	      (begin
		 (do-read-access-file port)
		 (close-input-port port)))))))

;*---------------------------------------------------------------------*/
;*    do-read-access-file ...                                          */
;*---------------------------------------------------------------------*/
(define (do-read-access-file port)
   (labels ((handler (escape proc mes obj)
		     (hello-world)
		     (notify-error proc mes obj)
		     (input-port-display-error port (current-error-port))
		     (close-output-port port)
		     (exit -2)))
      (let* ((obj (read port))
	     (eof (read port)))
	 (if (not (eof-object? eof))
	     (error "read-access-file" "Illegal access file format" eof)
	     (let loop ((obj obj))
		(if (null? obj)
		    'done
		    (match-case (car obj)
		       ((?module ?file)
			(add-access! module file)
			(loop (cdr obj)))
		       (else
			(error "read-access-file"
			       "Illegal access file format" (car obj))))))))))
			 
