;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Parse/with.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jul 24 14:13:22 1992                          */
;*    Last change :  Sat Jan 15 11:22:47 1994 (serrano)                */
;*                                                                     */
;*    On parse les `with's clause                                      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module parse_with
   (import engine_param
	   read_access
	   tools_file)
   (export (parse-with with)))

;*---------------------------------------------------------------------*/
;*    parse-with ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-with with)
   (let loop ((with with))
      (if (null? with)
	  'done
	  (match-case (car with)
	     ((?name ?file)
	      (add-access! (car (car with)) (cadr (car with)))
	      (set! *with-files* (cons file *with-files*))
	      (set! *init-functions* (cons name *init-functions*))
	      (loop (cdr with)))
	     (else
	      (let ((b (assq (car with) *access-table*)))
		 (if (not b)
		     (error "parse-with"
			    "can't access module" (car with))
		     (begin
			(set! *with-files* (cons
					    (string-append
					     (remove-extansion (cdr b))
					     ".o")
					    *with-files*))
			(if (not (memq (car with) *init-functions*))
			    (set! *init-functions* (cons (car with)
							 *init-functions*)))
			(loop (cdr with))))))))))
   
	     
	
