;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Parse/load.scm ...       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Oct 15 17:10:13 1993                          */
;*    Last change :  Sat Oct 29 10:30:15 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Le module ou on `load' les fichiers des clauses `load'           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module parse_load
   (import tools_speek
	   engine_param)
   (export (parse-load clause))
   (pragma (parse-load _no_eval_value_)))
 
;*---------------------------------------------------------------------*/
;*    parse-load ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-load clause)
   (let loop ((l (cdr clause)))
      (if (null? l)
	  'done
	  (begin
	     (match-case (car l)
		((?module ?file)
		 (if (not (string? file))
		     (error "parse-load" "Illegal clause" (car l))
		     (do-load-load module file)))
		(?module
		 (let ((b (assq module *access-table*)))
		    (if (not b)
			(error "parse-load" "Can't load module" module)
			(do-load-load module (cdr b))))))
	     (loop (cdr l))))))

;*---------------------------------------------------------------------*/
;*    do-load-load ...                                                 */
;*---------------------------------------------------------------------*/
(define (do-load-load module file)
   (verbose "      [reading loaded module " module "]" #\Newline)
   (let ((port (open-input-file file)))
      (if (not (input-port? port))
	  (error "do-load-load"
		 "Can't open such file"
		 file)
	  (let ((handler (lambda (escape proc mes obj)
			    (notify-error proc mes obj)
			    (input-port-display-error port
						      (current-error-port))
			    (fprint (current-error-port)
				    "(file " file ")")
			    (close-input-port port)
			    (exit -5))))
	     (try (let ((decl (read port)))
		     (if (not (and (pair? decl)
				   (eq? (car decl) 'module)))
			 (error "do-load-load"
				"Illegal module declaration"
				decl)
			 ;; on verifie le nome
			 (if (not (eq? (cadr decl) module))
			     (warning "module-declaration"
				      "conflict in module's name -- "
				      (string-append
				       (symbol->string module) " vs ")
				      (cadr decl))))
		     (loadq file))
		  handler)
	     (close-input-port port)))))
			 
		       
