;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Integ/agraph.scm ...     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr 15 10:06:28 1993                          */
;*    Last change :  Sat Jul  2 12:57:49 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Le calcul des deux ensembles Phi et A.                           */
;*    -------------------------------------------------------------    */
;*    On profite de la descente dans l'arbre pour calculer les         */
;*    ensembles des variables libres et liees.                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module integ_agraph
   (include "Var/variable.sch"
	    "Tools/trace.sch"
	    "Integ/integ.sch")
   (import  tools_shape
	    heap_abstract
	    lift_interface)
   (export  (a-graph       f body)
	    (trace-a-graph A)
	    *phi*
	    (globalized? f)
	    (local-celled? v)))

;*---------------------------------------------------------------------*/
;*    globalized? ...                                                  */
;*---------------------------------------------------------------------*/
(define (globalized? f)
   (or (global? f)
       (and (local? f)
	    (or (not (integ? (local-info f)))
		(eq? (integ-old-G? (local-info f)) #t)))))

;*---------------------------------------------------------------------*/
;*    *phi*                                                            */
;*---------------------------------------------------------------------*/
(define *phi* '())

;*---------------------------------------------------------------------*/
;*    a-graph ...                                                      */
;*---------------------------------------------------------------------*/
(define (a-graph _f exp)
   (let loop ((exp  exp)   ;; exp : la s-expression a scanner
	      (f    _f)    ;; f   : la fonction hote
	      (k    'tail) ;; k   : la continuation courante
	      (A    '()))
      (trace (integ loop) "A: " (shape exp) #\Newline)
      (match-case exp
;*--- nil -------------------------------------------------------------*/
	 (()
	  A)
;*--- atom ------------------------------------------------------------*/
	 ((atom ?-)
	  (if (and (local? exp)
		   (not (globalized? exp)))
	      (mark-local! exp f)
	      (trace (integ loop) "atom(globalized?): " (shape exp) #\Newline))
	  A)
;*--- function --------------------------------------------------------*/
	 ((function ?-)
	  A)
;*--- quote -----------------------------------------------------------*/
	 ((quote ?-)
	  A)
;*--- pragma ----------------------------------------------------------*/
	 ((pragma ?-)
	  A)
;*--- cast ------------------------------------------------------------*/
	 ((cast ?- ?rest)
	  (loop rest f k a))
;*--- failure ---------------------------------------------------------*/
	 ((failure . ?-)
	  (let liip ((exp (cdr exp))
		     (A   A))
	     (if (null? exp)
		 A
		 (liip (cdr exp)
		       (loop (car exp) f (get-new-kont) A)))))
;*--- set! ------------------------------------------------------------*/
	 ((set! ?var ?val)
	  (if (and (local? var)
		   (not (globalized? var)))
	      (mark-local! var f))
	  (loop val f (get-new-kont) A))
;*--- cif -------------------------------------------------------------*/
	 ((cif . ?-)
	  (let liip ((exp (cddr exp))
		     (A   (loop (cadr exp) f (get-new-kont) A)))
	     (if (null? exp)
		 A
		 (liip (cdr exp)
		       (loop (car exp) f k A)))))
;*--- typed-case ------------------------------------------------------*/
	 ((typed-case ?- ?test . ?clauses)
	  (let liip ((clauses clauses)
		     (A       (loop test f (get-new-kont) A)))
	     (if (null? clauses)
		 A
		 (liip (cdr clauses)
		       (loop (cadr (car clauses)) f k A)))))
;*--- begin -----------------------------------------------------------*/
	 ((begin . ?-)
	  (let liip ((body (cdr exp))
		     (A    A))
	     (if (null? (cdr body))
		 (loop (car body) f k A)
		 (liip (cdr body)
		       (loop (car body) f (get-new-kont) A)))))
;*--- let -------------------------------------------------------------*/
	 ((let . ?-)
	  (let ((integ (if (local? f)
			   (local-info f)
			   (global-info f))))
	     (let liip ((bindings (cadr exp))
			(A        A))
		(if (null? bindings)
		    (loop (caddr exp) f k A)
		    (let ((new-integ (make-integ)))
		       (integ-bind-set! integ (cons (car (car bindings))
						    (integ-bind integ)))
		       (integ-owner-set! new-integ f)
		       (integ-kaptured?-set! new-integ #f)
		       (integ-celled-set! new-integ #f)
		       (if (local-celled? (car (car bindings)))
			   (integ-celled-set! new-integ #t))
		       (local-info-set! (car (car bindings)) new-integ)
		       (liip (cdr bindings)
			     (loop (cadr (car bindings))
				   f
				   (get-new-kont)
				   A))))))) 
;*--- labels ----------------------------------------------------------*/
	 ((labels . ?-)
	  (let ((finteg (if (local? f)
			    (local-info f)
			    (global-info f))))
	     ;; on creer les structures integ pour les nouvelles fonctions.
	     (for-each (lambda (b)
			  (set! *phi* (cons (car b) *phi*))
			  (let ((integ (make-integ)))
			     (integ-G?-set!        integ #f)
			     (integ-kaptured?-set! integ #f)
			     (integ-kaptured-set!  integ #f)
			     (integ-owner-set!     integ f)
			     (integ-celled-set!    integ #f)
			     (integ-bind-set!      integ (cadr b))
			     (for-each (lambda (a)
					  (let ((integ (make-integ)))
					     (integ-owner-set! integ (car b))
					     (integ-kaptured?-set! integ #f)
					     (integ-celled-set! integ #f)
					     (if (local-celled? a)
						 (integ-celled-set! integ #t))
					     (local-info-set! a integ)))
				       (cadr b))
			     (local-info-set! (car b) integ)))
		       (cadr exp))
	     ;; on scan le body et les definitions.
	     (let liip ((bindings (cadr exp))
			(A        A))
		(if (null? bindings)
		    (loop (caddr exp) f k A)
		    (begin
		       (integ-bind-set! finteg (cons (car (car bindings))
						     (integ-bind finteg)))
		       (liip (cdr bindings)
			     (loop (caddr (car bindings))
				   (car (car bindings))
				   'tail
				   A)))))))
;*--- block -----------------------------------------------------------*/
	 ((block ?escape ?body)
	  (let ((integ  (make-integ))
		(finteg (if (local? f)
			    (local-info f)
			    (global-info f))))
	     (integ-bind-set! finteg (cons escape (integ-bind finteg)))
	     (integ-kaptured?-set! integ #f)
	     (integ-kaptured-set!  integ #f)
	     (integ-G?-set!        integ #f)
	     (integ-celled-set!    integ #f)
	     (integ-owner-set!     integ f)
	     (local-info-set!      escape integ))
	  (loop body escape (get-new-kont) (cons `(,f ,escape ,k) A)))
;*--- return-from -----------------------------------------------------*/
	 ((return-from ?escape ?value)
	  (save-call! f escape)
	  (mark-local! escape f)
	  (loop value f (get-new-kont) (cons `(,f ,escape escape) A)))
;*--- continue --------------------------------------------------------*/
	 ((continue ?escape ?value)
;*---------------------------------------------------------------------*/
;*    Manuel le 06-01-94                                               */
;*---------------------------------------------------------------------*/
	  (loop escape f k A)
	  (loop value f (get-new-kont) A))
;* 	  (if (not (integ? (local-info escape)))  */
;* 	      (let ((integ (make-integ)))  */
;* 		 (integ-kaptured?-set! integ #f)  */
;* 		 (integ-kaptured-set!  integ #f)  */
;* 		 (integ-celled-set!    integ #f)  */
;* 		 (local-info-set! escape integ)  */
;* 		 (integ-old-G?-set! integ #t)))  */
;* 	  (loop value f (get-new-kont) (cons `(,f ,escape escape) A)))  */
;*--- the-continuation ------------------------------------------------*/
	 ((the-continuation)
	  A)
;*--- apply -----------------------------------------------------------*/
	 ((apply ?g ?arg)
	  (loop arg f (get-new-kont) (loop g f (get-new-kont) A)))
;*--- application -----------------------------------------------------*/
	 ((or ((or funcall funcall-light) (and (not (?- .  ?-)) ?g) . ?args)
	      ((and (not (?- .  ?-)) ?g) . ?args))
	  (cond
	     ((and (local? f)
		   (not (integ? (local-info f))))
	      ;; f est une locale globalisee
	      (local-info-set! f (make-integ))
	      (integ-kaptured?-set! (local-info f) #f)
	      (integ-kaptured-set!  (local-info f) #f)
	      (integ-celled-set!    (local-info f) #f)
	      (integ-old-G?-set! (local-info f) #t))
	     ((and (global? f)
		   (not (integ? (global-info f))))
	      (global-info-set! f (make-integ))
	      (integ-celled-set!    (global-info f) #f)
	      (integ-kaptured-set!  (global-info f) #f)
	      (integ-kaptured?-set! (global-info f) #f)))
	  (save-call! f g)
	  (if (and (local? g)
		   (not (globalized? g)))
	      (mark-local! g f))
	  (let liip ((args args)
		     (A    A))
	     (if (null? args)
		 (cond
		    ((and (global? g)
			  (eq? (global-class g) 'function)
			  (not (eq? (global-import g) 'import)))
		     (if (not (integ? (global-info g)))
			 (begin
			    (global-info-set! g (make-integ))
			    (integ-celled-set!    (global-info g) #f)
			    (integ-kaptured-set!  (global-info g) #f)
			    (integ-kaptured?-set! (global-info g) #f)))
;*---------------------------------------------------------------------*/
;*   !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!   */
;*    -------------------------------------------------------------    */
;*    Suite au bug du `Tue Nov  9 10:19:30 MET 1993', je dis           */
;*    systematiquement qu'un appel a une fonction globale, peut        */
;*    revenir de facon tail-rec sur la fonction globale initiale.      */
;*    -------------------------------------------------------------    */
;*    Ce que je fais ici est une approximation grossiere mais je       */
;*    pense qu'elle doit suffire a corriger le bug. Ce n'est pas       */
;*    la solution optimale.                                            */
;*---------------------------------------------------------------------*/
		     (cons `(,g ,_f tail) (cons `(,f ,g ,k) A)))
		    ((and (local? g)
			  (or (eq? (local-class g) 'function)
			      (eq? (local-class g) 'return)))
		     (if (integ? (local-info g))
			 ;; vu l'ordre dans lequel on evalue les choses
			 ;; dans labels, si on tombe sur une locale qui
			 ;; n'a pas d'integ c'est qu'elle est globalisee
			 ;; on ne tient alors pas compte de son appel
			 (cons `(,f ,g ,k) A)
			 A))
		    (else
		     A))
		 (liip (cdr args)
		       (loop (car args) f (get-new-kont) A))))))))

;*---------------------------------------------------------------------*/
;*    get-new-kont ...                                                 */
;*---------------------------------------------------------------------*/
(define get-new-kont
   (let ((continuation 0))
      (lambda ()
	 (set! continuation (+fx 1 continuation))
	 continuation)))

;*---------------------------------------------------------------------*/
;*    trace-a-graph ...                                                */
;*---------------------------------------------------------------------*/
(define (trace-a-graph A)
   (when-trace 'integ
	       (lambda ()
		  (fprint *trace-port* "- - - - - - - - - - - - - - - - ")
		  (fprint *trace-port* "PHI: " (shape *phi*) #\newline)
		  (for-each (lambda (a) 
			       (fprint *trace-port*
				       "A( " (shape (car a)) ", "
				      (shape (cadr a)) ", "
				      (caddr a) " )"))
			    A)
		  (fprint *trace-port* "- - - - - - - - - - - - - - - - "))))

;*---------------------------------------------------------------------*/
;*    mark-local! ...                                                  */
;*---------------------------------------------------------------------*/
(define (mark-local! local owner)
   (trace (integ loop) "mark-local!: " (shape local) " " (shape owner)
	  #\Newline)
   (cond
      ((globalized? owner)
       ;; owner n'est pas locale, on saute
       'ok)
      ((or (eq? local owner)
	   (eq? (integ-owner (local-info local)) owner))
       ;; c'est une variable liee, on saute
       'ok)
      (else
       ;; ok, on l'ajoute a la liste des variables libres
       (trace (integ loop) "owner( " (shape local) ") : "
	      (shape (integ-owner (local-info local))) #\Newline)
       (integ-free-set! (local-info owner)
			(cons local (integ-free (local-info owner))))
       ;; on boucle sur les parents
       (let ((local-owner (integ-owner (local-info local))))
	  (let loop ((owner (integ-owner (local-info owner))))
	     (trace (integ loop) "   loop(owner) : " (shape owner) #\Newline)
	     (if (or (eq? owner local-owner)
		     (eq? owner local))
		 'ok
		 (begin
		    (integ-free-set! (local-info owner)
				     (cons local
					   (integ-free (local-info owner))))
		    (loop (integ-owner (local-info owner))))))))))

;*---------------------------------------------------------------------*/
;*    save-call! ...                                                   */
;*---------------------------------------------------------------------*/
(define (save-call! caller callee)
   (cond
      ((globalized? callee)
       'ok)
      ((global? caller)
       (let ((callee-integ (local-info callee)))
	  (if (not (memq caller (integ-cfrom callee-integ)))
	      (begin
		 (integ-cfrom-set! callee-integ
				   (cons caller (integ-cfrom callee-integ)))
		 (integ-cto-set!   (global-info caller)
				   (cons callee (integ-cto
						 (global-info caller))))))))
      (else
       (let ((caller-integ (local-info caller))
	     (callee-integ (local-info callee)))
	  (if (not (memq caller (integ-cfrom callee-integ)))
	      (begin
		 (integ-cfrom-set! callee-integ
				   (cons caller (integ-cfrom callee-integ)))
		 (integ-cto-set! caller-integ
				 (cons callee (integ-cto caller-integ)))))))))

;*---------------------------------------------------------------------*/
;*    local-celled? ...                                                */
;*---------------------------------------------------------------------*/
(define (local-celled? var)
  (if (integ? (local-info var))
      (integ-celled (local-info var))
      (memq var (get-all-celled-variable))))
	   
		   
