;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Inline/loop.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jul 16 08:19:17 1993                          */
;*    Last change :  Fri Aug 26 11:11:06 1994 (serrano)                */
;*                                                                     */
;*    L'inlining des boucles.                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module inline_loop
    (include "Var/variable.sch"
	    "Tools/trace.sch")
    (import  tools_error
	     tools_shape
	     tools_beta
	     tools_alpha
	     tools_args
	     effect_property
	     scan_lexical
	     scan_tree
	     heap_abstract
	     inline_walk
	     inline_call)
    (export  (is-loop? var)
	     (inline-call/labels exp level stack var function binding?)))

;*---------------------------------------------------------------------*/
;*    is-loop ...                                                      */
;*    -------------------------------------------------------------    */
;*    La notion de boucle est ici tres etendue. Ce predicat retourne   */
;*    `#t' si la fonction qu'on va inliner comporte des appels         */
;*    recursifs, pas obligatoirement terminaux.                        */
;*---------------------------------------------------------------------*/
(define (is-loop? var)
   (let loop ((body (function-body (global-value var))))
      (cond
	 ((not (pair? body))
	  #f)
	 ((eq? (car body) var)
	  #t)
	 (else
	  (let liip ((body body))
	     (cond
		((null? body)
		 #f)
		((loop (car body))
		 #t)
		(else
		 (liip (cdr body)))))))))

;*---------------------------------------------------------------------*/
;*    invariant-formals ...                                            */
;*    -------------------------------------------------------------    */
;*    Cette fonction recherche parmis la liste des parametres formels  */
;*    ceux qui sont invariants.                                        */
;*---------------------------------------------------------------------*/
(define (invariant-formals called formals body va/fx)
   (let loop ((body      body)
	      (invariant formals))
      (cond
	 ((not (pair? body))
	  invariant)
	 ((eq? (car body) called)
	  (let liip ((formals  formals)
		     (actuals  (cdr body))
		     (res      '())
		     (invariant invariant))
	     (cond
		((null? formals)
		 (reverse res))
		((not (pair? formals))
		 ;; le dernier argument des fonctions a arite variable est
		 ;; toujours variant
		 (reverse res))
		((and (null? (cdr formals)) (eq? va/fx 'va))
		 (reverse res))
		((null? actuals)
		 (partial-error ""
				"Too few arguments provided in a call to"
				(shape called))
		 '())
		((eq? (car formals) (car actuals))
		 (if (memq (car formals) invariant)
		     (liip (cdr formals)
			   (cdr actuals)
			   (cons (car formals) res)
			   invariant)
		     (liip (cdr formals)
			   (cdr actuals)
			   res
			   invariant)))
		(else
		 (liip (cdr formals)
		       (cdr actuals)
		       res
		       (loop (car actuals) invariant))))))
	 (else
	  (let liip ((body      body)
		     (invariant invariant))
	     (if (null? body)
		 invariant
		 (liip (cdr body) (loop (car body) invariant))))))))

;*---------------------------------------------------------------------*/
;*    inline-call/labels ...                                           */
;*    -------------------------------------------------------------    */
;*    Le schema d'inlining des boucles est different de celui des `let'*/
;*    Le principe est qu'ici on va generer un `labels' au lieu de faire*/
;*    une substitution par le code. Avant de generer ce `labels', on   */
;*    regarde si certain parametres sont invariants.                   */
;*---------------------------------------------------------------------*/
(define (inline-call/labels exp level stack var function binding?)
   (trace inline "inline-call/labels: " (shape var) #\Newline)
   (let* ((args      (function-args function))
	  (body      (function-body function))
	  (va/fx     (if (>=fx (function-arity function) 0)
			 'fx
			 'va))
	  (invariant (invariant-formals var args body va/fx))
	  (variant   (let loop ((args      args)
				(invariant invariant))
			(cond
			   ((null? args)
			    '())
			   ((not (pair? args))
			    ;; le dernier argument des fonctions a arite
			    ;; variable est toujours variant
			    (list args))
		 	   ((not (pair? invariant))
			    (cons (car args) (loop (cdr args) invariant)))
			   ((eq? (car args) (car invariant))
			    (loop (cdr args) (cdr invariant)))
			   (else
			    (cons (car args) (loop (cdr args)
						   invariant)))))))
      (trace inline "Les invariants sont: " (shape invariant) #\newline
	     "      variants sont: " (shape variant) #\newline)
      (let* ((new-function (cdar (allocate-local-functions
				  (list (global-name var)))))
	     (quoi.par.var (allocate-local-variables (map local-name variant)))
	     (substitute   (quoi->par args
				      (cdr exp)
				      variant
				      invariant
				      quoi.par.var))
	     (quoi.par     (vector-ref substitute 2))
	     (labels*      (vector-ref substitute 1))
	     (let*         (vector-ref substitute 0)))
	 (trace inline "quoi.par: " (shape quoi.par) #\Newline
		"let*: " (shape let*) #\Newline
		"labels*: " (shape labels*) #\Newline)
	 ;; on fait l'inlining sur le corps de la fonction
	 ;; qu'on expanse.
	 (let* ((body (do-inline (labels-beta-reduce (alphatize body)
						     var
						     new-function
						     quoi.par
						     variant
						     args)
				 (+fx level 1)
				 (cons var stack)
				 binding?)))
	    (inline-labels-bindings
	     labels*
	     (inline-let-bindings
	      let*
	      (inline-labels new-function
			     (map cdr quoi.par.var)
			     body
			     args
			     variant
			     (cdr exp)
			     va/fx
			     stack
			     level
			     binding?)
	      stack
	      level
	      binding?)
	     level
	     stack)))))
			 
;*---------------------------------------------------------------------*/
;*    inline-labels ...                                                */
;*---------------------------------------------------------------------*/
(define (inline-labels new-fun new-args body formals variant actuals va/fx s l binding?)
   (function-args-set!  (local-value new-fun) new-args)
   (function-body-set!  (local-value new-fun) body)
   (function-arity-set! (local-value new-fun) (arity new-args))
   (if (eq? va/fx 'va)
       (function-arity-set! (local-value new-fun)
			    (negfx (function-arity (local-value new-fun)))))
   `(labels ((,new-fun ,new-args ,body))
       ,(do-inline `(,new-fun ,@(let loop ((formals  formals)
					   (variant  variant)
					   (actuals  actuals))
				   (cond
				      ((null? formals)
				       '())
				      ((not (pair? formals))
				       actuals)
				      ((and (pair? variant)
					    (eq? (car formals) (car variant)))
				       (cons (car actuals)
					     (loop (cdr formals)
						   (cdr variant)
						   (cdr actuals))))
				      (else
				       (loop (cdr formals)
					     variant
					     (cdr actuals))))))
		   (+fx 1 l)
		   s
		   binding?)))

;*---------------------------------------------------------------------*/
;*    inline-let-bindings ...                                          */
;*---------------------------------------------------------------------*/
(define (inline-let-bindings bindings body stack level binding?)
   (if (null? bindings)
       body
       `(let ,(map (lambda (f.a)
		      (set-car! (cdr f.a)
				(do-inline (cadr f.a)
					   (+fx 1 level)
					   stack
					   binding?))
		      f.a)
		   bindings)
	   ,body)))

;*---------------------------------------------------------------------*/
;*    inline-labels-bindings ...                                       */
;*---------------------------------------------------------------------*/
(define (inline-labels-bindings bindings body level stack)
   (trace inline "inline-labels-bindings: " #\Newline
	  "   " (shape bindings) #\newline
	  "   " (shape body) #\Newline)
   (if (null? bindings)
       body
       `(labels ,(map (lambda (b.v)
			 (let* ((binding  (cdr b.v))
				(old-fun  (caar (cadr binding)))
				(old-args (cadar (cadr binding)))
				(old-body (caddar (cadr binding)))
				(new-fun  (car b.v))
				(new-args (map cdr
					       (allocate-local-variables
						(map local-name old-args))))
				(new-body (do-inline
					   (beta-reduce old-body
							(cons
							 (cons old-fun new-fun)
							 (map cons
							      old-args
							      new-args)))
					   level
					   stack
					   #f)))
			    (function-arity-set! (local-value new-fun)
						 (function-arity
						  (local-value old-fun)))
			    (function-args-set!  (local-value new-fun)
						 new-args)
			    (function-body-set!  (local-value new-fun)
						 new-body)
			    `(,new-fun ,new-args ,new-body)))
		      bindings)
	   ,body)))
			 
;*---------------------------------------------------------------------*/
;*    quoi->par ...                                                    */
;*---------------------------------------------------------------------*/
(define (quoi->par formals actuals variant invariant quoi.par.variant)
   (let loop ((formals          formals)
	      (actuals          actuals)
	      (invariant        invariant)
	      (quoi.par         '())
	      (quoi.par.variant quoi.par.variant)
	      (let-bindings     '())
	      (labels-bindings  '()))
      (cond
	 ((null? formals)
	  (vector let-bindings labels-bindings (reverse quoi.par)))
	 ((not (pair? formals))
	  (vector let-bindings labels-bindings (reverse quoi.par)))
	 ((and (pair? invariant)
	       (eq? (car formals) (car invariant)))
	  (cond
	     ((can-be-folded? (car formals) (car actuals))
	      ;; on ne cree pas une nouvelle variable.
	      (loop (cdr formals)
		    (cdr actuals)
		    (cdr invariant)
		    (cons `(,(car formals) . ,(car actuals))
			  quoi.par)
		    quoi.par.variant
		    let-bindings
		    labels-bindings))
	     ((match-case (car actuals)
		 ((labels ((?name ?- . ?-))
		     ?name)
		  #t)
		 (else
		  #f))
	      ;; on copie la variable du labels
	      (let* ((old (caar (cadr (car actuals))))
		     (new (copy-local-variable old)))
		 (loop (cdr formals)
		       (cdr actuals)
		       (cdr invariant)
		       (cons `(,(car formals) . ,new) quoi.par)
		       quoi.par.variant
		       let-bindings
		       (cons (cons new (car actuals))
			     labels-bindings))))
	     (else
	      ;; il faut creer une variable
	      (let ((new (copy-local-variable (car formals))))
		 (loop (cdr formals)
		       (cdr actuals)
		       (cdr invariant)
		       (cons `(,(car formals) . ,new) quoi.par)
		       quoi.par.variant
		       (cons `(,new ,(car actuals)) let-bindings)
		       labels-bindings)))))
	 (else
	  (loop (cdr formals)
		(cdr actuals)
		invariant
		(cons `(,(car formals) . ,(cdar quoi.par.variant))
		      quoi.par)
		(cdr quoi.par.variant)
		let-bindings
		labels-bindings)))))
	  
;*---------------------------------------------------------------------*/
;*    labels-beta-reduce ...                                           */
;*---------------------------------------------------------------------*/
(define (labels-beta-reduce body var new-function quoi.par variant formals)
   (let loop ((body (beta-reduce body quoi.par)))
      (cond
	 ((not (pair? body))
	  body)
	 ((not (eq? (car body) var))
	  (let liip ((hook body))
	     (if (null? hook)
		 body
		 (begin
		    (set-car! hook (loop (car hook)))
		    (liip (cdr hook))))))
	 (else
	  `(,new-function ,@(let loop ((formals formals)
				       (variant variant)
				       (actuals (cdr body))
				       (res     '()))
			       (cond
				  ((null? formals)
				   (reverse res))
		 		  ((not (pair? formals))
				   (reverse (cons (car actuals) res)))
				  ((and (pair? variant)
					(eq? (car formals) (car variant)))
				   (loop (cdr formals)
					 (cdr variant)
					 (cdr actuals)
					 (cons (car actuals) res)))
				  (else
				   (loop (cdr formals)
					 variant
					 (cdr actuals)
					 res)))))))))
