;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/bigloo1.7/comptime1.7/Fuse/cgraph.scm ...                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Sep 29 08:27:08 1993                          */
;*    Last change :  Sun Aug  7 13:59:14 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On parcour les definitions pour calculer le graphe d'appel.      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module fuse_cgraph
   (include "Var/variable.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    var_env)
   (export  (global-find-used! global used)))

;*---------------------------------------------------------------------*/
;*    Ce n'est pas terrible mais je mets les fonctions locales         */
;*    utilisee dans une variable globale. Ca m'evite d'avoir a         */
;*    retourner des valeurs multiples.                                 */
;*---------------------------------------------------------------------*/
(define *local-used* '())

;*---------------------------------------------------------------------*/
;*    La variable *root* sert a savoir si on est dans la fonction      */
;*    globale dont on determine le graph d'appel (c'est juste un hack  */
;*    pour avoir une approximation de la propriete `used' sans avoir a */
;*    gerer des piles).                                                */
;*---------------------------------------------------------------------*/
(define *root* (unspecified))

;*---------------------------------------------------------------------*/
;*    find-new-used! ...                                               */
;*    -------------------------------------------------------------    */
;*    On scan le corps de `global' pour trouver toutes les             */
;*    fonctions appellee. Une fois que ce parcours est effectue, on    */
;*    vire des definitions des fonctions, les locales non-referencee.  */
;*---------------------------------------------------------------------*/
(define (global-find-used! global used)
   (set! *local-used* '())
   (set! *root* global)
   (let ((value (global-value global)))
      (if (function? value)
       (let ((used (find-used! global (function-body value) used)))
	  (remove-local-unused! (function-body value))
	  used)
       used)))

;*---------------------------------------------------------------------*/
;*    find-used! ...                                                   */
;*    -------------------------------------------------------------    */
;*    Parent permet de calculer une approximation grossiere. En effet  */
;*    avant de dire qu'une variable est used, je regarde si elle n'est */
;*    pas le parent d'elle-meme. En faisant je rate les imbrications   */
;*    (i.e. je risque de dire que des fonctions imbriquees sont used   */
;*    alors qu'elles ne le sont pas).                                  */
;*    En fait pour ne pas avoir ce pbm, il faudrait avoir une pile et  */
;*    puis faire des liens entre les fonctions.                        */
;*---------------------------------------------------------------------*/
(define (find-used! parent exp used)
   (match-case exp
;*--- nil -------------------------------------------------------------*/
      (()
       used)
;*--- atom ------------------------------------------------------------*/
      ((atom ?val)
       (cond
	  ((and (global? val)
		(function? (global-value val))
		(not (eq? val *root*)))
	   (cons val used))
	  ((and (local? val)
		(function? (local-value val))
		(not (eq? val parent)))
	   (set! *local-used* (cons val *local-used*))
	   used)
	  (else
	   used)))
;*--- function --------------------------------------------------------*/
      ((function ?var)
       (if (global? var)
	   (cons var used)
	   (begin
	      (if (not (eq? var parent))
		  (set! *local-used* (cons var *local-used*)))
	      used)))
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       used)
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       used)
;*--- assert ----------------------------------------------------------*/
      ((assert ?- ?- ?formals ?body)
       (let loop ((formals formals)
		  (nused   used))
	  (if (null? formals)
	      (find-used! parent body nused)
	      (loop (cdr formals) (find-used! parent (car formals) nused)))))
;*--- failure ---------------------------------------------------------*/
      ((failure . ?rest)
       (find-used*! parent rest used))
;*--- set! ------------------------------------------------------------*/
      ((set! ?- ?val)
       (find-used! parent val used))
;*--- cif -------------------------------------------------------------*/
      ((cif . ?rest)
       (find-used*! parent rest used))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?- ?test . ?clauses)
       (let loop ((used    (find-used! parent test used))
		  (clauses clauses))
	  (if (null? clauses)
	      used
	      (loop (find-used! parent (cadr (car clauses)) used)
		    (cdr clauses)))))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?-)
       (find-used*! parent (cdr exp) used))
 ;*--- let -------------------------------------------------------------*/
      ((let ?bindings ?body)
       (let loop ((hook bindings)
		  (used used))
	  (if (null? hook)
	      (find-used! parent body used)
	      (loop (cdr hook)
		    (find-used! parent (cadr (car hook)) used)))))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
       (let loop ((hook (cadr exp))
		  (used used))
	  (if (null? hook)
	      (find-used! parent body used)
	      (loop (cdr hook)
		    (find-used! (car (car hook)) (caddr (car hook)) used)))))
;*--- block -----------------------------------------------------------*/
      ((block ?- ?body)
       (find-used! parent body used))
;*--- return-from -----------------------------------------------------*/
      ((return-from ?- ?val)
       (find-used! parent val used))
;*--- apply -----------------------------------------------------------*/
      (((or apply funcall) ?rest)
       (find-used*! parent rest used))
;*--- application -----------------------------------------------------*/
      (else
       (find-used*! parent exp used))))

;*---------------------------------------------------------------------*/
;*    find-used*! ...                                                  */
;*---------------------------------------------------------------------*/
(define (find-used*! parent exp* used)
   (let loop ((exp* exp*)
	      (used used))
      (if (null? exp*)
	  used
	  (loop (cdr exp*) (find-used! parent (car exp*) used)))))

;*---------------------------------------------------------------------*/
;*    remove-local-unused! ...                                         */
;*---------------------------------------------------------------------*/
(define (remove-local-unused! exp)
   (match-case exp
;*--- nil -------------------------------------------------------------*/
      (()
       'done)
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       'done)
;*--- function --------------------------------------------------------*/
      ((function ?var)
       'done)
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       'done)
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       'done)
;*--- assert ----------------------------------------------------------*/
      ((assert ?- ?- ?formals ?body)
       (let loop ((formals formals))
	  (if (null? formals)
	      (remove-local-unused! body)
	      (begin
		 (remove-local-unused! (car formals))
		 (loop (cdr formals))))))
;*--- failure ---------------------------------------------------------*/
      ((failure . ?rest)
       (remove-local-unused*! rest))
;*--- set! ------------------------------------------------------------*/
      ((set! ?- ?val)
       (remove-local-unused! val))
;*--- cif -------------------------------------------------------------*/
      ((cif . ?rest)
       (remove-local-unused*! rest))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?- ?test . ?clauses)
       (let loop ((clauses clauses))
	  (if (null? clauses)
	      'done 
	      (begin
		 (remove-local-unused! (cadr (car clauses)))
		 (loop (cdr clauses))))))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?-)
       (remove-local-unused*! (cdr exp)))
 ;*--- let -------------------------------------------------------------*/
      ((let ?bindings ?body)
       (let loop ((hook bindings))
	  (if (null? hook)
	      (remove-local-unused! body)
	      (begin
		 (remove-local-unused! (cadr (car hook)))
		 (loop (cdr hook))))))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
       (labels-remove-local-unused! exp bindings body))
;*--- block -----------------------------------------------------------*/
      ((block ?- ?body)
       (remove-local-unused! body))
;*--- return-from -----------------------------------------------------*/
      ((return-from ?- ?val)
       (remove-local-unused! val))
;*--- apply -----------------------------------------------------------*/
      (((or apply funcall) ?rest)
       (remove-local-unused*! rest))
;*--- application -----------------------------------------------------*/
      (else
       (remove-local-unused*! exp))))
   
;*---------------------------------------------------------------------*/
;*    remove-local-unused*! ...                                        */
;*---------------------------------------------------------------------*/
(define (remove-local-unused*! exp*)
   (let loop ((exp* exp*))
      (if (null? exp*)
	  'done
	  (begin
	     (remove-local-unused! (car exp*))
	     (loop (cdr exp*))))))

;*---------------------------------------------------------------------*/
;*    labels-remove-local-unused! ...                                  */
;*---------------------------------------------------------------------*/
(define (labels-remove-local-unused! exp bindings body)
   ;; on commence par parcourir le body
   (remove-local-unused! body)
   ;; On recherche la premiere definition qui est `used'
   (let loop ((bindings bindings)
	      (used?    #f))
      (cond
	 ((null? bindings)
	  ;; toutes les liaisons disparaissent
	  (set-car! (cdr exp) body)
	  (set-cdr! (cdr exp) '())
	  (set-car! exp 'begin))
	 (used?
	  ;; il y a au moins une liaison qui ne disparait pas.
	  (set-car! (cdr exp) bindings)
	  (let loop ((bindings bindings)
		     (hook     bindings))
	     (cond
		((null? bindings)
		 'done)
		((not (memq (car (car bindings)) *local-used*))
		 (set-cdr! hook (cdr bindings))
		 (loop (cdr bindings)
		       hook))
		(else
		 (remove-local-unused! (caddr (car bindings)))
		 (loop (cdr bindings)
		       bindings)))))
	 (else
	  ;; on itere pour la recherche d'une liaison `used'
	  (if (memq (car (car bindings)) *local-used*)
	      (loop bindings #t)
	      (loop (cdr bindings) used?))))))

		
