;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Foreign/type.sch ...     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Oct 12 08:37:05 1993                          */
;*    Last change :  Tue Jul 12 15:26:58 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Qu'est-ce qu'un type etrange ?                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    type                                                             */
;*    -------------------------------------------------------------    */
;*    Dans un premier temps (tant que le tas n'est pas restore et      */
;*    que l'arbre de syntaxe abstraite n'est pas construit) les        */
;*    champs ???-type? cintiennent des noms. Ensuite, on remplace      */
;*    ces noms par des fonctions `runtime'                             */
;*---------------------------------------------------------------------*/
(define-struct type
   id              ;; symbol        : un symbol pour le reperer
   name            ;; string        : le nom foreign du type
   type            ;; symbol        : la classe du type
   exp             ;; s-exp         : l'expression formant le type
   btype           ;; type          : le type Bigloo correspondant
   ptypes          ;; type*         : des types (pointer type)
   cast-to         ;; casting*      : une liste de casting
   cast-from       ;; casting*      : une liste de casting
   parents         ;; type*         : les parents de ce type
   sons)           ;; type*         : les fils de ce type

;*---------------------------------------------------------------------*/
;*    casting                                                          */
;*---------------------------------------------------------------------*/
(define-struct casting
   from            ;; type          : le type depuis lequel on cast
   to              ;; type          : le type vers lequel on cast
   check-op        ;; lambda        : un expanseur de test
   cast-op)        ;; lambda        : un expanseur de conversion

;*---------------------------------------------------------------------*/
;*    Une liste de casting est une liste de la forme:                  */
;*      ( < type, static-op, dynamic-op > ) ou,                        */
;*      type       : est le type vers lequel on cast.                  */
;*      static-op  : est l'operation a faire a la compilation          */
;*      dynamic-op : est l'operation a faire a l'execution.            */
;*                                                                     */
;*    Exemple:                                                         */
;*    Pour le type int (type C), on aura:                              */
;*       casting = ( (bint '() cint->bint) (bobj '() cint->bint) )     */
;*    pour le type bint (type Bigloo), on aura:                        */
;*       casting = ( (cint integer? bint->cint) (bobj '() '()) )       */
;*---------------------------------------------------------------------*/


