;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Foreign/cast.scm ...     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Oct 19 10:42:22 1993                          */
;*    Last change :  Wed Aug 31 15:34:23 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On creer tous les casteurs pour tous les types.                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module foreign_cast
   (include "Foreign/type.sch"
	    "Tools/trace.sch"
	    "Var/variable.sch")
   (import  foreign_parse
	    foreign_tools
	    foreign_atomic
	    tools_args
	    tools_shape
	    engine_param
	    parse_foreign
	    heap_abstract
	    type_enforce
	    type_expression
	    type_application
	    scan_lexical
	    var_env)
   (export  (allow-cast! from to check-op cast-op)
	    (make-foreign-casting!)))

;*---------------------------------------------------------------------*/
;*    I ...                                                            */
;*    -------------------------------------------------------------    */
;*    Cette fonction est tres utiles car beaucoup de cast ne           */
;*    necessite aucune conversion physique.                            */
;*---------------------------------------------------------------------*/
(define (I x) x)

;*---------------------------------------------------------------------*/
;*    define-casting ...                                               */
;*    -------------------------------------------------------------    */
;*    On cree et initialise un casting                                 */
;*---------------------------------------------------------------------*/
(define (define-casting from to check-op cast-op)
   (let ((new (make-casting)))
      (casting-from-set!        new from)
      (casting-to-set!          new to)
      (casting-check-op-set!    new check-op)
      (casting-cast-op-set!     new cast-op)
      new))

;*---------------------------------------------------------------------*/
;*    allow-cast! ...                                                  */
;*    -------------------------------------------------------------    */
;*    Cette fonction fait la fermeture transitive des cast. Par        */
;*    exemple on a:                                                    */
;*       *obj* -- (integer?) --> *bint*                                */
;*    Si on rajoute                                                    */
;*       *bint* ----> *int*                                            */
;*    Alors automatiquement, le cast                                   */
;*       *obj*  -- (integer?) --> *int*                                */
;*    est cree.                                                        */
;*---------------------------------------------------------------------*/
(define (allow-cast! from to check-op cast-op)
   (trace type "allow-cast!: " (shape from) " --> " (shape to) #\Newline
	  "  check: " (shape check-op) "  cast: " (shape cast-op) #\Newline)
   (define (allow-cast-from->parent! parent)
      (trace type "           : " (shape from) " --> " (shape parent)
	     #\Newline)
      (if (and (not (eq? from parent))
	       (not (find-casting parent (type-cast-to from))))
	  (let* ((old-c (find-casting parent (type-cast-to to)))
		 (new-c (define-casting from
			   parent
			   (lambda (x)
			      (check-op ((casting-check-op old-c) x)))
			   (lambda (x)
			      (cast-op ((casting-cast-op old-c)	x))))))
	     (type-cast-to-set! from (cons new-c (type-cast-to from)))
	     (type-cast-from-set! parent
				  (cons new-c (type-cast-from parent))))))
   (define (allow-cast-parent->from! parent)
      (trace type "           : " (shape parent) " --> " (shape to) #\Newline)
      (if (and (not (eq? from parent))
	       (not (find-casting to (type-cast-to parent))))
	  (let* ((old-c (find-casting from (type-cast-to parent)))
		 (new-c (define-casting parent
			   to
			   (lambda (x)
			      (check-op ((casting-check-op old-c) x)))
			   (lambda (x)
			      (cast-op ((casting-cast-op old-c) x))))))
	     (type-cast-to-set! parent (cons new-c (type-cast-to parent)))
	     (type-cast-from-set! to (cons new-c (type-cast-from to))))))
   (let ((casting (define-casting from to check-op cast-op)))
      (type-cast-to-set!   from (cons casting (type-cast-to from)))
      (type-cast-from-set! to   (cons casting (type-cast-from to)))
      (for-each allow-cast-from->parent! (type-parents to))
      (for-each allow-cast-parent->from! (type-parents from))))

;*---------------------------------------------------------------------*/
;*    make-foreign-casting! ...                                        */
;*---------------------------------------------------------------------*/
(define (make-foreign-casting!)
   ;; on commence par poser les castings maisons
   (make-atomic-casting!)
   ;; on fait les autres
   (for-each-type! (lambda (t)
		      (case (type-type t)
			 ((bigloo-atom c-atom b-foreign-struct)
			  'done)
			 ((c-integer)
			  (make-as-casting! t *long*))
			 ((c-float)
			  (make-as-casting! t *double*))
			 ((c-char)
			  (make-as-casting! t *char*))
			 ((c-foreign-struct)
			  (make-union/struct-casting! t))
			 ((c-foreign-unbound-array)
			  (make-array-casting! t))
			 ((c-foreign-bound-array)
			  (make-array-casting! t))
			 ((c-foreign-pointer)
			  (make-array-casting! t))
			 ((function)
			  (make-function-casting! t))
			 ((subtype)
			  (make-subtype-casting! t))
			 (else
			  (if (type? (type-type t))
			      (make-as-casting! t (type-type t))
			      'done))))))

;*---------------------------------------------------------------------*/
;*    make-as-casting! ...                                             */
;*---------------------------------------------------------------------*/
(define (make-as-casting! type as-type)
   (trace type "make-as-casting!: " (shape type) " " (shape as-type) #\Newline)
   (for-each (lambda (cast) (allow-cast! type
					 (casting-to cast)
					 (casting-check-op cast)
					 (casting-cast-op cast)))
	     (type-cast-to as-type))
   (for-each (lambda (cast) (allow-cast! (casting-from cast)
					 type
					 (casting-check-op cast)
					 (casting-cast-op cast)))
	     (type-cast-from as-type))
   (allow-cast! type as-type I I)
   (allow-cast! as-type type I I))

;*---------------------------------------------------------------------*/
;*    make-union/struct-casting! ...                                   */
;*---------------------------------------------------------------------*/
(define (make-union/struct-casting! ct)
   (let* ((ct-id    (type-id ct))
	  (bt       (type-btype ct))
	  (bt-id    (type-id bt))
	  (bid->cid (symbol-append bt-id '-> ct-id))
	  (*id      (symbol-append '* ct-id)))
      ;; bt <-> *bobj*
      (allow-cast! bt *bobj* I I)
      (allow-cast! *bobj* bt (enforcer (lambda (x)
					  (abstract 'c-foreign-is? x `',ct-id))
				       ct-id)
		   I)
      ;; ct <-> *foreign*
      (allow-cast! ct *foreign* I I)
      (allow-cast! *foreign* ct I I)
      ;; ct <-> bt
      (allow-cast! ct bt I (lambda (x)
			      (abstract 'c-cforeign->bforeign
					`',ct-id
					(abstract 'c-foreign-address x))))
      (allow-cast! bt ct I (lambda (x)
			      (abstract *id (abstract bid->cid x))))
      ;; ct <-> *bool*
      (allow-cast! ct *bool* I I)
      ;; bt <-> *bool*
      (allow-cast! bt *bool* I (lambda (x) (abstract-true)))
      ;; les pointers
      (for-each (lambda (pt)
		   (allow-cast! bt pt I (lambda (x) (abstract bid->cid x)))
		   (allow-cast! pt bt I (lambda (x)
					   (abstract 'c-cforeign->bforeign
						     `',ct-id
						     x))))
		(type-ptypes ct))))

;*---------------------------------------------------------------------*/
;*    make-array-casting! ...                                          */
;*---------------------------------------------------------------------*/
(define (make-array-casting! ct)
   (let* ((ct-id    (type-id ct))
	  (bt       (type-btype ct))
	  (bt-id    (type-id bt))
	  (bid->cid (symbol-append bt-id '-> ct-id)))
      ;; bt <-> *bobj*
      (allow-cast! bt *bobj* I I)
      (allow-cast! *bobj* bt (enforcer (lambda (x)
					  (abstract 'c-foreign-is? x `',ct-id))
				       ct-id)
		   I)
      ;; ct <-> *foreign*
      (allow-cast! ct *foreign* I I)
      (allow-cast! *foreign* ct I I)
      ;; ct <-> bt
      (allow-cast! ct bt I (lambda (x)
			      (abstract 'c-cforeign->bforeign
					`',ct-id
					x)))
      (allow-cast! bt ct I (lambda (x)
			      (abstract bid->cid x)))
      ;; ct <-> *bool*
      (allow-cast! ct *bool* I I)
      ;; bt <-> *bool*
      (allow-cast! bt *bool* I (lambda (x) (abstract-true)))))

;*---------------------------------------------------------------------*/
;*    make-function-casting! ...                                       */
;*    -------------------------------------------------------------    */
;*    Le codage de cette fonction n'est vraiment pas genial. Je n'ai   */
;*    pas reussit a utiliser les fonctions standards:`make-expression' */
;*    et `type-expression' car on entre dans `make-function-casting!'  */
;*    par deux chemins differents et donc l'expression que recoit      */
;*    `caster' est une expression deja construite ou juste une         */
;*    variable globale. Il faut donc veiller que cette fonction        */
;*    reste conforme avec la fonction `make-labels-tree' du fichier    */
;*    `scan/labels.scm'.                                               */
;*---------------------------------------------------------------------*/
(define (make-function-casting! t)
   (let* ((arity  (arity (cdr (type-exp t))))
	  (proto  (if (>fx arity 0)
		      (map allocate-local-variable (make-n-proto arity))))
	  (caster (lambda (cfun)
		     (trace type "caster: " (shape cfun)
			    #\Newline)
		     (let* ((fun  (cdar (allocate-local-functions '(fun))))
			    (body (type-foreign-application
				   `(,cfun ,@proto)
				   t
				   *bobj*)))
			(function-args-set! (local-value fun) proto)
			(function-body-set! (local-value fun) body)
			(function-arity-set! (local-value fun) arity)
			`(labels ((,fun ,proto ,body))
			    ,(type-expression fun *bobj*))))))
      (if (>=fx arity 0)
	  (begin
	     (allow-cast! t *bprocedure* I caster)
	     (allow-cast! t *bobj* I caster)
	     (allow-cast! *bobj* t (enforcer
				    (lambda (x)
				       (abstract 'c-foreign-is? x
						 `',(type-id t)))
				    (type-id t))
			  (lambda (exp)
			     (abstract 'c-bforeign->cforeign exp)))
	     (allow-cast! t *function*
			  I
			  (lambda (exp)
			     (abstract 'c-function-address
				       exp)))))))

;*---------------------------------------------------------------------*/
;*    make-subtype-casting! ...                                        */
;*---------------------------------------------------------------------*/
(define (make-subtype-casting! from)
   (let ((to       (get-type (car (type-exp from))))
	 (from->to (cadr (type-exp from)))
	 (to->from (caddr (type-exp from))))
      (allow-cast! from to I (lambda (x) (abstract from->to x)))
      (allow-cast! to from I (lambda (x) (abstract to->from x)))))

