;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Engine/link.scm ...      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jan 15 11:16:02 1994                          */
;*    Last change :  Tue Jun 14 14:26:18 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On link quand l'utilisateur n'a passe que des `.o'               */
;*    -------------------------------------------------------------    */
;*    Pour ce faire on essaye de trouver des `.scm' correspondants.    */
;*    On genere un petit fichier `.scm' qui les initialise puis on     */
;*    le compile normalement ou alors, on se contente d'invoquer le    */
;*    linker `*ld*'.                                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module engine_link
   (export (link))
   (import cc_ld
	   engine_compiler
	   engine_param
	   tools_error
	   tools_file))

;*---------------------------------------------------------------------*/
;*    *tmp-main-file-name* ...                                         */
;*---------------------------------------------------------------------*/
(define *tmp-main-file-name* (string-append *bigloo-tmp* "/"
					    "main-tmp"
					    "@" (old-getenv "USER")
					    ".scm"))
			      
;*---------------------------------------------------------------------*/
;*    link ...                                                         */
;*---------------------------------------------------------------------*/
(define (link)
   ;; on commence par rechercher les `.scm'
   (let loop ((o-files   *o-files*)
	      (scm-files '()))
      (if (null? o-files)
	  ;; et on lance le link
	  (link-with scm-files)
	  (let ((scm-file (string-append (prefix (car o-files)) ".scm")))
	     (if (file-exists? scm-file)
		 (loop (cdr o-files) (cons scm-file scm-files))
		 (loop (cdr o-files) scm-files))))))

;*---------------------------------------------------------------------*/
;*    link-with ...                                                    */
;*---------------------------------------------------------------------*/
(define (link-with scm-files)
   (start-partial-error "ld")
   (if (null? scm-files)
       (let ((first (prefix (car *o-files*))))
	  (set! *o-files* (cdr *o-files*))
	  (ld first))
       ;; on construit la clause du module
       (let loop ((scm-files scm-files)
		  (cls       '())
		  (main      #f))
	  (if (null? scm-files)
	      (if main
		  ;; ce n'est pas la peine de generer un main, il y en a
		  ;; deja un
		  (let ((first (prefix (car *o-files*))))
		     (set! *o-files* (cdr *o-files*))
		     (ld first))
		  ;; on genere un main puis on link.
		  (begin
		     (make-tmp-main cls main)
		     (fail-if-partial-error)
		     (set! *src* *tmp-main-file-name*)
		     (compiler)
		     (let* ((scm-file *tmp-main-file-name*)
			    (pre      (prefix scm-file))
			    (c-file   (string-append pre ".c"))
			    (o-file   (string-append pre ".o")))
			(for-each (lambda (f)
				     (if (file-exists? f)
					 (delete-file f)))
				  (list scm-file c-file o-file)))))
	      (let ((port (open-input-file (car scm-files))))
		 (if (not (input-port? port))
		     (partial-error "" "Illegal file" (car scm-files))
		     (let ((exp  (read port)))
			(close-input-port port)
			(match-case exp
			   ((module ?name ??- (main ?new-main) . ?-)
			    (if main
				(partial-error ""
					       "Redeclaration of the main"
					       (cons main new-main)))
			    (loop (cdr scm-files)
				  (cons (list name
					      (string-append
					       "\""
					       (car scm-files)
					       "\""))
					cls)
				  new-main))
			   ((module ?name . ?-)
			    (loop (cdr scm-files)
				  (cons (list name
					      (string-append
					       "\""
					       (car scm-files)
					       "\""))
					cls)
				  main))
			   (else
			    ;; ah, ce n'etait pas un fichier bigloo,
			    ;; on saute (en meprisant :-)
			    (loop (cdr scm-files)
				  cls
				  main))))))))))

;*---------------------------------------------------------------------*/
;*    make-tmp-main ...                                                */
;*---------------------------------------------------------------------*/
(define (make-tmp-main clauses main)
   (let ((pout (open-output-file *tmp-main-file-name*)))
      (if (not (output-port? pout))
	  (partial-error ""
			 "Can't open output file"
			 *tmp-main-file-name*)
	  (begin
	     (fprint pout ";; " *bigloo-name*)
	     (fprint pout ";; !!! generated file, don't edit !!!")
	     (fprint pout ";; ==================================")
	     (newline pout)
	     (fprint pout `(module ,(gensym 'main)
			      (import ,@clauses)
			      (force ,@(map car (reverse clauses)))))
	     (newline pout)
	     (if main
		 (begin
		    (fprint pout "(main *the-command-line*)")
		    (newline pout)))
	     (close-output-port pout)))))
	  
	  

