;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Assert/get.scm ...       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Nov 10 11:24:48 1993                          */
;*    Last change :  Thu Sep  8 09:15:55 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On collecte les assertions qu'on trouve dans les corps           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module assert_get
   (include "Assert/assert.sch"
	    "Tools/trace.sch"
	    "Var/variable.sch")
   (import  tools_shape)
   (export  (get-assertions! exp)
	    (asserted-variable? var)))

;*---------------------------------------------------------------------*/
;*    get-assertions! ...                                              */
;*---------------------------------------------------------------------*/
(define (get-assertions! exp)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       'done)
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       'done)
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       'done)
;*--- assert ----------------------------------------------------------*/
      ((assert . ?-)
       (declare-assertion! exp))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (let loop ((hook body))
	  (if (null? hook)
	      'done
	      (begin
		 (get-assertions! (car hook))
		 (loop (cdr hook))))))
;*--- set! ------------------------------------------------------------*/
      ((set! ?var ?val)
       (get-assertions! val))
;*--- let -------------------------------------------------------------*/
      ((let ?bindings ?body)
       (let loop ((hook bindings))
	  (if (null? hook)
	      (get-assertions! body)
	      (begin
		 (get-assertions! (cdar hook))
		 (loop (cdr hook))))))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
       (let loop ((hook bindings))
	  (if (null? hook)
	      (get-assertions! body)
	      (begin
		 (get-assertions! (caddr (car hook)))
		 (loop (cdr hook))))))
;*--- failure ---------------------------------------------------------*/
      ((failure ?proc ?msg ?obj)
       (get-assertions! proc)
       (get-assertions! msg)
       (get-assertions! obj))
;*--- bind-exit -------------------------------------------------------*/
      ((bind-exit ?- ?body)
       (get-assertions! body))
;*--- apply -----------------------------------------------------------*/
      ((apply ?fun ?val)
       (get-assertions! fun)
       (get-assertions! val))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (get-assertions! test)
       (let loop ((hook clauses))
	  (if (null? hook)
	      exp
	      (begin
		 (get-assertions! (cdr (car hook)))
		 (loop (cdr hook))))))
;*--- if --------------------------------------------------------------*/
      ((cif ?si ?alors ?sinon)
       (get-assertions! si)
       (get-assertions! alors)
       (get-assertions! sinon))
;*--- block -----------------------------------------------------------*/
      ((block ?var ?body)
       (get-assertions! body))
;*--- return-from -----------------------------------------------------*/
      ((return-from ?var ?body)
       (get-assertions! body))
;*--- application -----------------------------------------------------*/
      (else
       (let loop ((exp exp))
	  (if (null? exp)
	      'done
	      (begin
		 (get-assertions! (car exp))
		 (loop (cdr exp))))))))

;*---------------------------------------------------------------------*/
;*    declare-assertion! ...                                           */
;*---------------------------------------------------------------------*/
(define (declare-assertion! exp)
   (trace assert "declare-assertion!: " (shape exp) #\Newline)
   (match-case exp
      ((?- check . ?-)
       exp)
      ((?- (or entering exiting) ?def ?formals ?-)
       (add-assert! exp)
       #f)))

;*---------------------------------------------------------------------*/
;*    add-assert! ...                                                  */
;*---------------------------------------------------------------------*/
(define (add-assert! assert)
   (trace assert "add-assert!: " (shape assert) #\Newline)
   (define (add-info-assert! info)
      (case (cadr assert)
	 ((entering)
	  (assert-entering-set! info (cons assert (assert-entering info))))
	 ((exiting)
	  (assert-exiting-set! info (cons assert (assert-exiting info))))))
   (let ((function (car (cadddr assert))))
      (let (value info)
	 (if (local? function)
	     (begin
		(if (not (assert? (local-info function)))
		    (local-info-set! function (make-assert)))
		(set! info (local-info function))
		(set! value (local-value function)))
	     (begin
		(if (not (assert? (global-info function)))
		    (global-info-set! function (make-assert)))
		(set! info (global-info function))
		(set! value (global-value function))))
	 ;; les parametres formels de la fonction doivent etre
	 ;; considere comme affectes.
	 (for-each (lambda (f)
		      (local-access-set! f 'write))
		   (function-args value))
	 ;; on colle l'assertion
	 (add-info-assert! info))
      'done))

;*---------------------------------------------------------------------*/
;*    asserted-variable? ...                                           */
;*---------------------------------------------------------------------*/
(define (asserted-variable? var)
   (assert? (if (local? var)
		(local-info var)
		(global-info var))))
			    
