;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/0cfa/foreign.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 22 16:44:15 1993                          */
;*    Last change :  Wed Sep 21 16:24:31 1994 (serrano)                */
;*                                                                     */
;*    Le traitement particulier de certaines fonctions particulieres   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module 0cfa_foreign
   (include "Var/variable.sch"
	    "Tools/trace.sch"
	    "0cfa/0cfa.sch"
	    "0cfa/app.sch"
	    "Foreign/type.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    0cfa_0cfa
	    0cfa_application
	    heap_abstract
	    engine_param
	    foreign_tools
	    foreign_atomic)
   (export  (0cfa-foreign-application! exp app-info fun args-A*)
	    (pair-approx? app)
	    (0cfa-car/cdr car/cdr args-A*)))

;*---------------------------------------------------------------------*/
;*    0cfa-foreign-application! ...                                    */
;*---------------------------------------------------------------------*/
(define (0cfa-foreign-application! exp app-info fun args-A*)
   (trace (0cfa loop) "0cfa-foreign-application!: " (shape fun) " "
	  (shape args-A*) #\Newline)
   (cond
      ((abstract? fun 'c-cint->bint)                  ;; int
       '(bint))
      ((abstract? fun 'c-bint->cint)
       '(bottom))
      ((abstract? fun 'c-cstring->bstring)            ;; string
      '(bstring))
      ((abstract? fun 'c-cbool->bbool)                ;; bool
       '(bbool))
      ((abstract? fun 'c-bbool->cbool)                ;; C bool
       '(bool))
      ((abstract? fun 'c-string->symbol)              ;; symbol
       '(bsymbol))
      ((abstract? fun 'c-cchar->bchar)                ;; char
       '(bchar))
      ((abstract? fun 'c-cons 'c-inline-cons)         ;; cons
       (if (<=fx *optim* 3)
	   (begin
	      (for-each set-bottom! args-A*)
	      '(bpair))
	   (list exp)))
      ((abstract? fun 'c-car)                         ;; car
       (0cfa-car/cdr car (car args-A*)))
      ((abstract? fun 'c-cdr)                         ;; cdr
       (0cfa-car/cdr cadr (car args-A*)))
      ((abstract? fun 'push-lambda-trace)             ;; push-lambda-trace
       '())
      ((abstract? fun 'pop-lambda-trace)              ;; pop-lambda-trace
       (car args-A*))
      ((memq fun (abstract-type-tester))              ;; type-tester
       '(bbool))
      ((memq fun (abstract-fx-arithmetic-op))         ;; l'arithmetic entiere
       '(bint))
      ((memq fun (abstract-fx-arithmetic-tester))     ;; l'arithmetic entiere
       '(bbool))
      ((abstract? fun 'c-eq? 'equal?)
       '(bbool))
      (else
       (for-each set-bottom! args-A*)
       (let ((type-res (car (type-exp (foreign-type (global-value fun))))))
	  (if (or (foreign-type? type-res)
		  (eq? type-res *bobj*))
	      '(bottom)
	      (list (type-id type-res)))))))

;*---------------------------------------------------------------------*/
;*    0cfa-car/cdr ...                                                 */
;*    -------------------------------------------------------------    */
;*    On retourne l'union de toutes les listes en meprisant toutes     */
;*    les autres optimisations.                                        */
;*---------------------------------------------------------------------*/
(define (0cfa-car/cdr car/cdr args-A*)
   (trace (0cfa loop) "0cfa-car/cdr: " (shape args-A*) #\Newline)
   (if (<=fx *optim* 3)
       '(bottom)
       (let loop ((A*  args-A*)
		  (res '()))
	  (cond
	     ((null? A*)
	      res)
	     ((pair-approx? (car A*))
	      ;; oui l'approx est bien une pair, on recupere son `car/cdr'.
	      (loop (cdr A*) (union (car/cdr (app-args* (cadr (car A*))))
				    res)))
	     ((eq? (car A*) 'bpair)
	      ;; ce cas correspond aux listes citee
	      '(bottom))
	     ((eq? (car A*) 'bottom)
	      '(bottom))
	     (else
	      ;; on ne s'occupe pas des approx qui ne sont pas des pairs
	      ;; car ces cas donnerons des erreurs
	      (loop (cdr A*) res))))))
			       
;*---------------------------------------------------------------------*/
;*    pair-approx? ...                                                 */
;*    -------------------------------------------------------------    */
;*    Est-ce qu'une approximation correspond a l'approximation d'une   */
;*    pair ?                                                           */
;*---------------------------------------------------------------------*/
(define (pair-approx? app)
   (and (pair? app)
	(abstract? (car app) 'c-cons 'c-inline-cons)))



