;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.5/0cfa/diet.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 29 08:30:21 1993                          */
;*    Last change :  Thu Oct 28 16:13:30 1993 (serrano)                */
;*                                                                     */
;*    On allege certaines fermetures. Autrement dit, on transforme     */
;*    des `function' et des `funcall'.                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module 0cfa_diet
   (include "Var/variable.sch"
	    "Tools/trace.sch"
	    "0cfa/0cfa.sch"
	    "0cfa/app.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    tools_args
	    engine_param
	    heap_abstract  
	    scan_lexical
	    var_declare
	    0cfa_tree
	    0cfa_application
	    effect_property)
   (export  (0cfa-diet! tree)))

;*---------------------------------------------------------------------*/
;*    0cfa-diet! ...                                                   */
;*---------------------------------------------------------------------*/
(define (0cfa-diet! tree)
   (trace 0cfa
	  #\Newline
	  "***************************************************************"
	  #\Newline
	  "                            diet" #\Newline)
   (for-each diet-function! tree)
   tree)

;*---------------------------------------------------------------------*/
;*    diet-function! ...                                               */
;*---------------------------------------------------------------------*/
(define (diet-function! var)
   (trace 0cfa
	  "     ------------------------------------------"
	  #\Newline
	  "            *** " (shape var) " ***" #\Newline)
   (function-body-set! (global-value var)
		       (diet-exp! (function-body (global-value var))
				  '())))

;*---------------------------------------------------------------------*/
;*    diet-exp! ...                                                    */
;*---------------------------------------------------------------------*/
(define (diet-exp! exp lenv)
   (trace (0cfa loop) "diet-exp!: " (shape exp) #\Newline)
   (match-case exp
      (()
       exp)
      ((atom ?-)
       exp)
      ((quote ?-)
       exp)
      ((pragma ?-)
       exp)
      ((function ?var)
       (let ((info (if (local? var)
		       (local-info var)
		       (global-info var))))
	 (if (not (_lambda? info))
	     exp
	     (case (_lambda-strength info)
	       ((extra-light)
		(set-car! exp 'function-extra-light)
		exp)
	       ((light)
		(set-car! exp 'function-light)
		exp)
	       (else
		exp)))))
      ((typed-case ?type ?test . ?clauses)
       (set-car! (cddr exp) (diet-exp! test lenv))
       (for-each (lambda (clause)
		    (set-car! (cdr clause) (diet-exp! (cadr clause) lenv)))
		 clauses)
       exp)
      ((let ?bindings ?body)
       (let loop ((bindings bindings)
		  (new-lenv lenv))
	  (if (null? bindings)
	      (begin
		 (set-car! (cddr exp) (diet-exp! body new-lenv))
		 exp)
	      (begin
		 (set-car! (cdr (car bindings))
			   (diet-exp! (cadr (car bindings)) lenv))
		 (loop (cdr bindings)
		       (cons (car bindings) new-lenv))))))
      ((labels ?bindings ?body)
       (let ((lenv (append (map car bindings) lenv)))
	  (let loop ((bindings bindings))
	     (if (null? bindings)
		 (begin
		    (set-car! (cddr exp) (diet-exp! body lenv))
		    exp)
		 (begin
		    (set-car! (cddr exp)
			      (diet-exp! (caddr (car bindings))
					 (append (cadr (car bindings))
						 lenv)))
		    (loop (cdr bindings)))))))
      ((funcall ?app-info . ?rest)
       (diet-funcall! exp app-info rest lenv))
      (else
       (let loop ((hook exp))
	  (if (null? hook)
	      'done
	      (begin
		 (set-car! hook (diet-exp! (car hook) lenv))
		 (loop (cdr hook)))))
       (trace (0cfa loop) "se?( " (shape exp) "): " (side-effect? exp)
	      #\Newline)
       (if (app? (cadr exp))
	   (if (and (known-funcall-result? exp (cadr exp) lenv)
		    (not (side-effect? exp)))
	       `(function ,(car (app-res* (cadr exp))))
	       exp)
	   exp))))

;*---------------------------------------------------------------------*/
;*    diet-funcall! ...                                                */
;*---------------------------------------------------------------------*/
(define (diet-funcall! exp app-info rest lenv)
   (let ((se? (or (null? (app-fun* app-info))
		  (side-effect? (cons (car (app-fun* app-info)) rest))))
	 (fa? (failure? exp)))
      ;; on calcule avant toute chose si on fait un effet de bord pendant
      ;; le funcall ou dans la fonction qu'on appelle.
      (trace (0cfa loop) "diet-funcall!: " (shape exp) #\Newline
	     "   fun* : " (shape (app-fun* app-info)) #\Newline
	     "   se?  : " se? #\Newline)
      (if (and (known-funcall-result? exp app-info lenv)
	       (not se?))
	  ;; la seule chose qu'on peut connaitre qui est dans la pile
	  ;; est une fonction. Sinon, on ne connaitrait qu'une approximation
	  ;; (le type par exemple).
	  (begin
	     (trace (0cfa loop) 'result #\Newline)
	     `(function ,(car (app-res* app-info))))
	  (begin
	     ;; on marche sur la partie invariante
	     (for-each (lambda (e) (diet-exp! e lenv)) rest)
	     ;; on regarde si on optimise
	     (cond
		((and (lexical-funcall? app-info lenv)
		      (not se?))
		 ;; on connait la fonction qu'on applique et elle
		 ;; est dans l'env lexical
		 (trace (0cfa loop) 'lexical #\Newline)
		 ;; on coupe le dernier element (eoa)
		 `(,(car (app-fun* app-info))
		   ,app-info
		   ,@(let loop ((l   (cdr rest))
				(res '()))
			(if (null? (cdr l))
			    (reverse! res)
			    (loop (cdr l) (cons (car l) res))))))
		((extra-light-funcall? exp app-info)
		 (trace (0cfa loop) 'extra-light #\Newline)
		 (set-car! exp (cons 'funcall-extra-light
				     (car (app-fun* app-info))))
		 exp)
		((light-funcall? exp app-info)
		 (trace (0cfa loop) 'light #\Newline)
		 (set-car! exp 'funcall-light)
		 exp)
		((strong-funcall? exp app-info)
		 (trace (0cfa loop) 'strong #\Newline)
		 exp)
		(else
		 (trace (0cfa loop) 'medium #\Newline)
		 (set-car! exp 'funcall-medium)
		 exp))))))

;*---------------------------------------------------------------------*/
;*    known-funcall-result? ...                                        */
;*---------------------------------------------------------------------*/
(define (known-funcall-result? exp app-info lenv)
   (trace (0cfa loop) "known-funcall-result?: " (shape exp)
	  "[" (shape (app-res* app-info)) "]" #\Newline)
   (and (pair? (app-res* app-info))
	(null? (cdr (app-res* app-info)))
	(memq  (car (app-res* app-info)) lenv)
	(not   (failure? exp))))

;*---------------------------------------------------------------------*/
;*    lexical-funcall? ...                                             */
;*---------------------------------------------------------------------*/
(define (lexical-funcall? app-info lenv)
   (and (pair? (app-fun* app-info))
	(null? (cdr (app-fun* app-info)))
	(memq  (car (app-fun* app-info)) lenv)))
			  
;*---------------------------------------------------------------------*/
;*    extra-light-funcall? ...                                         */
;*---------------------------------------------------------------------*/
(define (extra-light-funcall? exp app-info)
   (let ((fun* (app-fun* app-info)))
      (trace (0cfa loop) "extra-light-funcall?: " (shape exp) #\Newline
	     "                fun*: " (shape fun*) #\Newline)
      (if (and (>fx *optim* 1)
	       (pair? fun*)
	       (null? (cdr fun*)))
	  (cond
	     ((local? (car fun*))
	      (eq? (_lambda-strength (local-info (car fun*))) 'extra-light))
	     ((global? (car fun*))
	      (eq? (_lambda-strength (global-info (car fun*))) 'extra-light))
	     (else
	      #f))
	  #f)))

;*---------------------------------------------------------------------*/
;*    light-funcall? ...                                               */
;*    -------------------------------------------------------------    */
;*    Cette fonction retourne `#t' si toutes les fonctions sont        */
;*    `light'. Le corps de cette fonction peut sembler etrange car ici */
;*    on saute tout ce qui n'est pas fonction. C'est normale, ce qui   */
;*    n'est pas fonction produit une erreur. Aucun des deux protocoles */
;*    d`appel n'est correcte, ce n'est donc pas la peine de faire un   */
;*    test, cqfd.                                                      */
;*    Il faut cependant moderer cela quand on tombe sur `bottom'. Dans */
;*    le cas d'un appel calcule importe par exemple, on se recupere    */
;*    bottom et il ne faut pas faire un appel `light'.                 */
;*---------------------------------------------------------------------*/
(define (light-funcall? exp app-info)
   (trace (0cfa loop) "light-funcall?: " (shape exp) #\Newline
	  "                fun*: " (shape (app-fun* app-info)) #\Newline)
   (if (null? (app-fun* app-info))
       #f
       (let loop ((fun* (app-fun* app-info)))
	  (cond
	     ((null? fun*)
	      #t)
	     ((local? (car fun*))
	      (if (eq? (_lambda-strength (local-info (car fun*))) 'light)
		  (loop (cdr fun*))
		  #f))
	     ((global? (car fun*))
	      (if (eq? (_lambda-strength (global-info (car fun*))) 'light)
		  (loop (cdr fun*))
		  #f))
	     ((eq? (car fun*) 'bottom)
	      #f)
	     (else
	      (loop (cdr fun*)))))))

;*---------------------------------------------------------------------*/
;*    strong-funcall? ...                                              */
;*    -------------------------------------------------------------    */
;*    Cette fonction retourne `#t' si toutes les fonctions sont        */
;*    `strong'                                                         */
;*---------------------------------------------------------------------*/
(define (strong-funcall? exp app-info)
   (let loop ((fun* (app-fun* app-info)))
      (cond
	 ((null? fun*)
	  #t)
	 ((or (and (local? (car fun*))
		   (eq? (_lambda-strength (local-info (car fun*))) 'light))
	      (and (global? (car fun*))
		   (eq? (_lambda-strength (global-info (car fun*))) 'light)))
	  #f)
	 (else
	  (loop (cdr fun*))))))

;*---------------------------------------------------------------------*/
;*    failure? ...                                                     */
;*    -------------------------------------------------------------    */
;*    `exp' peut elle conduire a une failure ? On reponds oui, si      */
;*    le mot failure appartient a la liste `exp'.                      */
;*---------------------------------------------------------------------*/
(define (failure? exp)
   (match-case exp
      ((cif ?si ?alors ?sinon)
       (cond
	  ((eq? si #t)
	   (failure? alors))
	  ((eq? si #f)
	   (failure? sinon))
	  (else
	   (or (failure? alors)
	       (failure? sinon)))))
      ((quote . ?-)
       #f)
      ((?- . ?-)
       (let loop ((exp exp))
	  (cond
	     ((not (pair? exp))
	      #f)
	     ((failure? (car exp))
	      #t)
	     (else
	      (loop (cdr exp))))))
      (failure
       #t)
      (else
       #f)))
      
       
