;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Heap/make.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 23 17:01:19 1992                          */
;*    Last change :  Tue Jan 11 17:21:47 1994 (serrano)                */
;*                                                                     */
;*    On construit un environment                                      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module heap_make
   (include "Var/variable.sch")
   (import  engine_param
	    write_scheme
	    tools_speek
	    var_env
	    tools_hash
	    heap_compact)
   (export (make-heap)))

;*---------------------------------------------------------------------*/
;*    make-heap ...                                                    */
;*    -------------------------------------------------------------    */
;*    La construction du tas s'effectue apres que le code est ete      */
;*    macro-expanse. Les objects locaux n'existent donc pas encore. On */
;*    peut imprimer les corps sans crainte                             */
;*---------------------------------------------------------------------*/
(define (make-heap)
   (verbose "   . Heap" #\Newline)
   ;; pour sauver un tas, il ne faut pas alpha convertir.
   (set! *alpha* #f)
   (let* ((heap-name (car (reverse! *heap-names*)))
	  (port      (if *heap-append?*
			 (append-output-file heap-name)
			 (open-output-file heap-name))))
      (if (not (output-port? port))
	  (error "make-heap" "Can't open file for output" heap-name)
	  (begin
	     (write-scheme-file-header port "heap file for bigloo compiler")
	     (walk-on-hash-table!
	      (lambda (bucket)
		 (let liip ((bucket bucket))
		    (if (null? bucket)
			'done
			(let* ((pr (car bucket)))
			   (if (or (eq? (global-import pr) 'import)
				   (eq? (global-import pr) 'export)
				   (eq? (global-import pr) 'foreign))
			       (begin
				  (write (compact pr) port)
				  (newline port)))
			   (liip (cdr bucket))))))
	      *Genv*
	      'Genv)))))

