;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.6/Rgc/expand.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Aug  3 13:18:55 1992                          */
;*    Last change :  Thu Nov 25 17:08:01 1993 (serrano)                */
;*                                                                     */
;*    Le point d'entree de la compilation des grammaires rationnelles  */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __rgc_expand
   (export  (expand-regular-grammar x e)
	    (expand-regular-search  x e))
   (import  (__rgc_grammar "Rgc/grammar.scm")
	    (__rgc_tree    "Rgc/tree.scm")
	    (__rgc_dfa     "Rgc/dfa.scm")
	    (__rgc_rule    "Rgc/rules.scm")))

;*---------------------------------------------------------------------*/
;*    expand-regular-grammar ...                                       */
;*    -------------------------------------------------------------    */
;*    Attention, cette fonction retourne une grammaire inversee. ie    */
;*    les dernieres regles sont en premieres positions et vice-versa.  */
;*---------------------------------------------------------------------*/
(define (expand-regular-grammar x e)
   (match-case x
      ((?- ?Renv . ?body)
       (let loop ((body    body)
		  (m       1)
		  (tree    '())
		  (actions '())
		  (else    '()))
	  (if (null? body)
;*---------------------------------------------------------------------*/
;*    Voila, on a fini d'isoler les regles et les actions. On va       */
;*    commencer le calcul du DFA.                                      */
;*---------------------------------------------------------------------*/
	      (let* ((tuple   (eval-tree tree m))
		     (grammar (build-regular-grammar
			       (dfa tuple)
			       (if else
				   actions
				   (cons '(the-failing-char)
					 actions))
			       (vector-ref tuple 5))))
		 (e grammar e))
;*---------------------------------------------------------------------*/
;*    On poursuit l'isolement                                          */
;*---------------------------------------------------------------------*/
	      (let* ((hd (car body))
		     (tl (cdr body)))
		 (if (eq? (car hd) 'else)
		     (if (null? tl)
			 (if (null? tree)
			     (error "regular-grammar"
				    "no clause for this grammar"
				    tl)
			     (loop tl
				   m
				   tree
				   (cons `(begin ,@(cdr hd))
					 actions)
				   #t))
			 (error "regular-grammar"
				"the else clause has to be the last one"
				hd))
		     (if (pair? (car hd))
			 (let ((er (expand-rule (mark m (car hd)) Renv)))
			    (loop tl
				  (+fx 1 m)
				  (if (null? tree)
				      er
				      `(or ,er
					   ,tree))
				  (cons (if (null? (cdr hd))
					    '(ignore)
					    `(begin ,@(cdr hd)))
					actions)
				  #f))
			 ;; on examine une regle qui est contextuelle.
			 (let ((er (expand-rule (mark m `(context ,(car hd)
								  ,(cadr hd)))
						Renv)))
			    (loop tl
				  (+fx 1 m)
				  (if (null? tree)
				      er
				      `(or ,er
					   ,tree))
				  (cons (if (null? (cddr hd))
					    '(ignore)
					    `(begin ,@(cddr hd)))
					actions)
				  #f))))))))
      (else
       (error "regular-grammar" "Illegal form" x))))

;*---------------------------------------------------------------------*/
;*    mark ...                                                         */
;*---------------------------------------------------------------------*/
(define (mark m exp)
   `(,exp (marker ,m)))
  
;*---------------------------------------------------------------------*/
;*    expand-regular-search ...                                        */
;*---------------------------------------------------------------------*/
(define (expand-regular-search x e)
   (match-case x
      ((?- ?exp)
       (e `(regular-grammar ()
	      (,exp (the-string))
	      (else
	       (if (eof-object? (the-failing-char))
		   #f
		   (ignore))))
	  e))
      (else
       (error "regular-search" "Illegal form" x))))

     
   
