;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.6/Rgc/dfa.scm ...           */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr  3 15:21:05 1992                          */
;*    Last change :  Mon Jan 10 08:45:12 1994 (serrano)                */
;*                                                                     */
;*    Le calcul des transitions du `dfa'                               */
;*---------------------------------------------------------------------*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __rgc_dfa
   (import  (__rgc_tree  "Rgc/tree.scm")
	    (__rgc_param "Rgc/param.scm"))
   (export  (dfa tuple)))

;*---------------------------------------------------------------------*/
;*     dfa ...                                                         */
;*     ------------------------------------------------------------    */
;*     fast-union-v est passe en parametre car il a deja ete alloue    */
;*     (sa taille definitive est connue) par regular-grammar-2.        */
;*     ------------------------------------------------------------    */
;*     Toutes les unions triviales ne passent pas par les tables de    */
;*     hash mais sont retrouvees grace a un tableau (trivial).         */
;*     ------------------------------------------------------------    */
;*     t-alpha et l-alpha sont un tableau et une liste qui sont        */
;*     utilises pour calculer rapidement "lettre concernee a la pos".. */
;*     ------------------------------------------------------------    */
;*     l-trap est une liste qui contient toutes les traps. Une fois    */
;*     dstates calcule, on va gerer les traps. (passe trap)            */
;*---------------------------------------------------------------------*/
(define (dfa tuple)
   (let ((Dinit        (vector-ref tuple 0))
	 (position     (vector-ref tuple 1))
	 (f-store      (vector-ref tuple 2))
	 (f-env        (vector-ref tuple 3))
	 (fast-union-v (vector-ref tuple 4)))
      ;; on vide fast-union-v
      (let loop ((i 0))
	 (if (=fx i (vector-length fast-union-v))
	     'done
	     (begin
		(vector-set! fast-union-v i #f)
		(loop (+fx i 1)))))
      (let ((Dstates-env   (make-env))
	    (Union-env     (make-env))
	    (nb-states-max 1023)
	    (nb-states     -1)
	    (states        (make-vector 1024 '()))
	    (P=a           '()) 
	    (t-alpha       (make-vector (+fx 1 *rgc-last-char*) '()))
	    (l-alpha       '())
	    (trivial       (make-vector (vector-length f-store) '())))
;*---------------------------------------------------------------------*/
;*     fast-union                                                      */
;*     ------------------------------------------------------------    */
;*     L'indirection f-env a deja ete faite dans union-followpos. il   */
;*     ne reste donc a faire que celle sur f-store.                    */
;*---------------------------------------------------------------------*/
	 (labels ((fast-union (l*)
	             (if (null? (cdr l*))
			 (vector-ref f-store (car l*))
			 (let* ( (init (car (vector-ref f-store (car l*))))
				 (max  init)
				 (min  init) )
;*---- On lit toutes les listes ---------------------------------------*/
			    (labels ((read (l)
					   (if (null? l)
					       '()
					       (let ( (c (car l)) )
						  (if (<fx c min)
						      (set! min c)
						      (if (>fx c max)
							  (set! max c) ) )
						  (vector-set!
						   fast-union-v c #t)
						  (read (cdr l))))))
			       (let loop ((l l*))
				  (if (null? l)
				      'read-done
				      (begin
					 (read (vector-ref f-store (car l)))
					 (loop (cdr l))))))
;*---- on ecrit le resultat -------------------------------------------*/
			    (let loop ((i   max)
				       (acc '()))
			       (if (<fx i min)
				   acc
				   (if (vector-ref fast-union-v i)
				       (begin
					  (vector-set! fast-union-v i #f)
					  (loop (-fx i 1)
						(cons i acc)))
				       (loop (-fx i 1) acc)))))))
;*---- increment-nb-states --------------------------------------------*/
		  (increment-nb-states ()
		     (if (=fx nb-states nb-states-max)
			 (begin
			    (set! nb-states-max (* 2 nb-states-max))
			    (set! states (vector-grow states nb-states-max))
			    (let loop ((i (+fx 1 nb-states)))
			       (if (<=fx i nb-states-max)
				   '()
				   (begin
				      (vector-set! states i '())
				      (loop (+fx i 1)))))))
		     (begin
			(set! nb-states (+fx 1 nb-states))
			nb-states))
;*---- make-state -----------------------------------------------------*/
		  (make-state (symbol-name)
		      (let ((v (increment-nb-states)))
			 (set! Dstates-env (cons (cons symbol-name v)
						 Dstates-env))
			 nb-states))
;*---- set-alpha ------------------------------------------------------*/
;*   Si deux regles match une chaine, on ne prends que la 1ere action. */
;*   Pour modifier cela, il faut changer cette routine, ainsi que le   */
;*   code de main-loop a l'endroit on on fait:                         */
;*             (vector-set! dstates ... (cons a U) ...)                */
;*   (La modif decrite ci-dessus a ete effectuee.)                     */
;*---------------------------------------------------------------------*/
		  (set-alpha (p*)
	             (set! l-alpha '())
	             (let loop ((p* (reverse p*)))
			(if (null? p*)
			    '()
			    (let ( (pr  (car p*))
				   (sp* (cdr p*)) )
			       (let* ( (lettre (vector-ref position pr))
				       (alpha  (if (char? lettre)
						   lettre
						   'accept-position))
				       (indice (if (char? lettre)
						   (char->integer lettre)
						   0)) )
				  (cond
				     ((null? (vector-ref t-alpha indice))
				      (set! l-alpha (cons alpha l-alpha))
				      (vector-set! t-alpha indice (cons pr
									'()))
				      (loop sp*))
				     (else
				      (vector-set! t-alpha 
						   indice 
						   (cons pr 
							 (vector-ref t-alpha
								     indice)))
				      (loop sp*))))))))
;*---- compute-real-union ---------------------------------------------*/
;*  Je garde cette fonction car je ne desepere pas de trouver une ruse */
;*  qui me permettrait une optimisation d'enfer...                     */
;*---------------------------------------------------------------------*/
		  (compute-real-union (position*)
		     (labels ((first-non-null? (p* acc)
	                         (if (null? p*)
				     (reverse! acc)
				     (if (null? (vector-ref f-store (car p*)))
					 (first-non-null? (cdr p*) acc)
					 (first-non-null? (cdr p*)
							  (cons (car p*)
								acc))))))
			(let ((p* (first-non-null? position* '())))
			   (if p*
			       (fast-union p*)
			       '())))))
;*---------------------------------------------------------------------*/
;*     dfa                                                             */
;*---------------------------------------------------------------------*/
	    (let main-loop ((dstates (list
				      (cons
				       Dinit
				       (make-state (make-state-name Dinit))))))
;*---- union-followpos ------------------------------------------------*/
;*  !!! WARNING !!!                                                    */
;*  ----------------------------------------------------------------   */
;*  C'est tres crade (mais efficace !), on fait un horrible            */
;*  side-effect sur dstates...                                         */
;*  ----------------------------------------------------------------   */
;*  On ne calcule pas union-followpos sur position* mais sur:          */
;*  (map f-env position*).                                             */
;*---------------------------------------------------------------------*/
	       (labels ((union-followpos (position*)
	                   (let ((env-pos (map (lambda (p)
						  (vector-ref f-env p))
					       position*)))
;*---- La gestion des triviaux ----------------------------------------*/
			      (cond
				 ((null? (cdr env-pos))
				  (let ((indice (car env-pos)))
				     (if (null? (vector-ref f-store indice))
					 '()
					 (begin
					    (if (null? (vector-ref trivial
								   indice))
						(let ((state-name
						       (make-state-name
							(vector-ref
							 f-store indice))) )
						   (let ((num (bound?
							       state-name
							       Dstates-env)))
						      (if num
							  (begin
							     (vector-set!
							      trivial
							      indice
							      num)
							     num)
							  (let ((num
								 (make-state
								  state-name)))
							     (vector-set!
							      trivial indice
							      num)
							     (set!
							      dstates
							      (cons
							       (cons
								(vector-ref
								 f-store
								 indice)
								num) 
							       dstates))
							     num))))
						(vector-ref trivial
							    indice))))))
;*---- Les cas non-triviaux -------------------------------------------*/
				 (else
				  (let ((union-name (make-union-name
						     env-pos)))
				     (let ((num (bound? union-name Union-env)))
					(if num
					    num
					    (let* ((U (compute-real-union
						       env-pos))
						    (state-name
						     (make-state-name U)))
					       (let ((num (bound?
							   state-name
							   Dstates-env)))
						  (if num
						      (begin
							 (set! Union-env
							       (cons
								(cons
								 union-name
								 num)
								Union-env))
							 num)
						      (let ((num
							     (make-state
							      state-name)))
							 (set! dstates
							       (cons
								(cons U num)
								dstates))
							 (set! Union-env
							       (cons
								(cons
								 union-name
								 num)
								Union-env))
							 num))))))))))))
;*---- main-loop ------------------------------------------------------*/
		  (if (null? dstates)
		      ;; on a fini le calcul des transitions
		      (cons (+fx 1 nb-states) states)
		      ;; Il reste des etats non marques
		      (let* ((T    (car (car dstates)))
			     (Tnum (cdr (car dstates))))
			 ;; on met en place t-alpha et l-alpha
			 (set-alpha T)
			 ;; Ceci revients a marquer dstates
			 (set! dstates (cdr dstates))
			 (let loop ((a* l-alpha))
			    (if (null? a*)
				(main-loop dstates)
				(let ((a (car a*)))
				   (if (char? a)
				       ;; Ce n'est pas une lettre acceptante
				       (let ( (indice (char->integer a)) )
					  (set! P=a
						(vector-ref t-alpha indice))
					  (vector-set! t-alpha indice '())
					  (let ((U (union-followpos P=a)))
					     (vector-set! 
					      states
					      Tnum
					      (cons
					       (cons a U)
					       (vector-ref states Tnum)))))
				       ;; C'est une lettre acceptante
				       (let ((indice 0) 
					     (accept
					      (map (lambda (p)
						      (vector-ref position p))
						   (vector-ref t-alpha 0))))
					  (!CHECK-ACCEPT! accept)
					  (vector-set! t-alpha 0 '())
					  (vector-set!
					   states
					   Tnum
					   (cons accept
						 (vector-ref states Tnum)))))
				   (loop (cdr a*)))))))))))))

;*---------------------------------------------------------------------*/
;*     !CHECK-ACCEPT! ...                                              */
;*---------------------------------------------------------------------*/
(define (!CHECK-ACCEPT! accept)
   (let loop ((l accept))
      (if (null? l)
	  'ok
	  (let ( (pr (car l))
		 (sp (cdr l)) )
	     (if (memq pr sp)
		 (error "regular-grammar" "a position occure twice: " accept)
		 (loop sp))))))

;*---------------------------------------------------------------------*/
;*     make-prefix-name ...                                            */
;*---------------------------------------------------------------------*/
(define (make-prefix-name prefix num*)
   (let ((s (apply
	     string-append
	     (cons prefix
		   (map (lambda (num)
			   (string-append "." (integer->string num)))
			num*)))))
      (string->symbol
       (string-upcase
	(apply
	 string-append
	 (cons prefix
	       (map (lambda (num)
		       (string-append "." (integer->string num)))
		    num*)))))))

;*---------------------------------------------------------------------*/
;*     bound? ...                                                      */
;*---------------------------------------------------------------------*/
(define (bound? name env)
   (let ((bb (assq name env)))
      (if bb (cdr bb) #f)))
		  
;*---------------------------------------------------------------------*/
;*     set-in-env! ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (set-in-env! name val env)
   (let ((b (assq name env))
	 (v val) )
      (set-cdr! b v)
      v))
  
;*---------------------------------------------------------------------*/
;*     make-env ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (make-env)
   '())

;*---------------------------------------------------------------------*/
;*     make-state-name ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (make-state-name num*)
   (make-prefix-name "state" num*))

;*---------------------------------------------------------------------*/
;*     make-union-name ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (make-union-name num*)
   (make-prefix-name "union" num*))
