;*=====================================================================*/
;*    serrano/prgm/project/bigloo/examples/Foreign/foreign.scm ...     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Oct 19 10:20:58 1993                          */
;*    Last change :  Mon Jan 24 11:00:42 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Un essai de la nouvelle interface etrangere                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    the module ...                                                   */
;*---------------------------------------------------------------------*/
(module for
   (foreign (include "el.h")
	    (type el (struct ((int "key")
                              (pel "next"))
                             "struct el"))
            (type pel (pointer el))
	    (type tab (array char 0 10))
            (type utab (array char))
            (pel  define-el (int pel) "define_el")
            (int  print-el* (pel)     "print_els")
	    (int  print-tab (tab int) "print_tab")
            (utab make-utab (int) "malloc")
            (int  print-utab (utab int) "print_tab")
            (pel  make-truc ()        "make_truc")
            (el   make-vrai-truc ()   "make_vrai_truc")
            (int  print-vrai-truc ()  "print_vrai_truc")
            (int  modify-el (el)      "modify_el")
            (int  modify-pel (pel)    "modify_pel")
	    (int printf (string . foreign) "printf"))
   (main main))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (let ((n (string->integer (cadr argv))))
      (test1 n)
      (test2 n)
      (test3 n)
      (test4)
      (test5 argv)))

;*---------------------------------------------------------------------*/
;*    test1 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test1 n)
   (print "test1...")
   (let ((head (make-el)))
      (el-key-set! head -1)
      (let loop ((n  n)
		 (c  head))
	 (if (= n 0)
	     (print-el* c)
	     (let ((new (define-el n c)))
		(loop (- n 1) new))))))

;*---------------------------------------------------------------------*/
;*    test2 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test2 n)
   (print "test2...")
   (let ((t (make-tab)))
      (let loop ((i 0))
	 (if (= i n)
	     (print-tab t n)
	     (begin
		(tab-set! t i (integer->char (+ i (char->integer #\a))))
		(loop (+ i 1)))))))

;*---------------------------------------------------------------------*/
;*    test3                                                            */
;*---------------------------------------------------------------------*/
(define (test3 n)
   (print "test3...")
   (let ((t (make-utab n)))
      (let loop ((i 0))
	 (if (= i n)
	     (print-utab t n)
	     (begin
		(utab-set! t i (integer->char (+ i (char->integer #\a))))
		(loop (+ i 1)))))))

;*---------------------------------------------------------------------*/
;*    test4 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test4)
   (print "test4...")
   (let* ((n1 (make-truc))
	  (n2 (make-truc)))
      (display "n1: ")
      (print-el* n1)
      (display "n2: ")
      (print-el* n2)
      (print "eq?: " (eq? n1 n2))))
      
;*---------------------------------------------------------------------*/
;*    test5 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test5 argv)
   (print "test5...")
   (let ((n (length argv)))
      (print "there are {" n "} args, the first is: {" (cadr argv) "}")
      (printf #"there are [%d] args, the first is: [%s]\n" n (cadr argv))))
