;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/examples/Depend/depend.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 10:49:15 1993                          */
;*    Last change :  Sun Mar 21 09:26:09 1993  (serrano)               */
;*                                                                     */
;*    On genere un `.afile' compose de tous les arguments              */
;*---------------------------------------------------------------------*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module afile (main main))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (if (or (null?    (cdr argv))
	   (string=? (cadr argv) "-help"))
       (usage)
       (let loop ((files        (cdr argv))
		  (files-list  '())
		  (output-file '()))
	  (cond
	     ((null? files)
	      (output files-list output-file))
	     ((string=? (car files) "-o")
	      (if (null? (cdr files))
		  (usage)
		  (loop (cddr files)
			files-list
			(cadr files))))
	     (else
	      (loop (cdr files)
		    (cons (car files) files-list)
		    output-file))))))

;*---------------------------------------------------------------------*/
;*    output ...                                                       */
;*---------------------------------------------------------------------*/
(define (output files-list output-file)
   (let ((port (if (string? output-file)
		   (begin
		      (if (file-exists? output-file)
			  (rename-file output-file
				       (string-append output-file "~")))
		      (open-output-file output-file))
		   (current-output-port))))
      (let loop ((files-list files-list))
	 (if (null? files-list)
	     (newline port)
	     (let* ((file-name (car files-list))
		    (includes  (find-includes file-name)))
		(if (not (null? includes))
		    (begin
		       (display (string-append (remove-extansion file-name)
					       ".o")
				port)
		       (display #\: port)
		       (for-each (lambda (i)
				    (display #\space port)
				    (display i port))
				 includes)
		       (newline port)))
		(loop (cdr files-list)))))))
	  
;*---------------------------------------------------------------------*/
;*    find-includes ...                                                */
;*---------------------------------------------------------------------*/
(define (find-includes file)
   (if (not (file-exists? file))
       (begin
	  (fprint (current-error-port) "*** ERROR:biglood:" #\Newline
		  "Can't find file -- " file)
	  '())
       (let ((port (open-input-file file)))
	  (if (not (input-port? port))
	      (begin
		 (fprint (current-error-port) "*** ERROR:biglood:" #\Newline
			 "Can't open file -- " file)
		 '())
	      (let ((exp (read port)))
		 (match-case exp
		    ((module ?- . ?clauses)
		     (let loop ((clauses  clauses)
				(includes '()))
			(if (null? clauses)
			    (begin
			       (close-input-port port)
			       includes)
			    (if (eq? (car (car clauses)) 'include)
				(loop (cdr clauses)
				      (append (cdr (car clauses)) includes))
				(loop (cdr clauses)
				      includes)))))
		    (else
		     (close-input-port port)
		     (fprint (current-error-port) "*** ERROR:biglood:"
			     #\Newline
			     "Illegal file format -- " file)
		     '())))))))
	     
;*---------------------------------------------------------------------*/
;*    usage ...                                                        */
;*---------------------------------------------------------------------*/
(define (usage)
   (print "usage: biglood [-o output] <file1> <file2> ... <filen>")
   (exit -1))

;*---------------------------------------------------------------------*/
;*    remove-extansion ...                                             */
;*---------------------------------------------------------------------*/
(define (remove-extansion string)
   (let ((len (-fx (string-length string) 1)))
      (let loop ((e len)
                 (s len))
         (cond
            ((=fx s 0)
             (substring string 0 (+fx 1 e)))
            (else
             (if (and (eq? (string-ref string s) #\.)
                      (=fx e len))
                 (loop (-fx s 1) (- s 1))
                 (loop e (-fx s 1))))))))
