;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../walk.scm ...                                                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr 27 08:22:03 1994                          */
;*    Last change :  Mon May 30 16:46:13 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La passe dite de `Super Lifting' est une optimisation qui ne     */
;*    s'applique que si le langage cible est C. En effet il s'agit     */
;*    d'une optimisation qui ne fait rien gagner dans les autres cas.  */
;*    Elle consiste a forcer un lambda-lifting pour toutes les         */
;*    fonctions qui s'echappent. Le but est de supprimer les           */
;*    dereferenciations inutiles lors d'appels auto-recursifs. Le      */
;*    principe est simple:                                             */
;*                                                                     */
;*      qq f ds F, si E( f ) alors                                     */
;*             |( f a1 .. an )|                                        */
;*             ==>                                                     */
;*             |( f' a1 .. an )|                                       */
;*             et                                                      */
;*             |( labels ((f (a1 .. an) body) ... )|                   */
;*             ==>                                                     */
;*             |( labels ((f (a1 .. an) (f' a1 .. an))                 */
;                         (f' (a1 .. an) body) ... )|                  */
;*                                                                     */
;*=====================================================================*/


;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module superlift_walk
   (include "Tools/trace.sch"
	    "Var/variable.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    var_env
	    superlift_expression)
   (export  (superlift-walk tree)))

;*---------------------------------------------------------------------*/
;*    superlift-walk ...                                               */
;*---------------------------------------------------------------------*/
(define (superlift-walk tree)
   (verbose "   . Superlift" #\Newline)
   (start-partial-error "Superlift")
   (for-each (lambda (var)
		(enter-function (shape var))
		(superlift-definition! var)
		(leave-function))
	     tree)
   tree)

;*---------------------------------------------------------------------*/
;*    superlift-definition! ...                                        */
;*---------------------------------------------------------------------*/
(define (superlift-definition! var)
   (trace lift
	  "========================================" #\newline
	  (shape var) #\Newline
	  "----------------------------------------" #\newline)
   (let ((body (function-body (global-value var))))
      (function-body-set! (global-value var)
			  (superlift-expression! body))))

      
