;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Lift/kapture.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Mar 30 09:35:14 1993                          */
;*    Last change :  Thu Jan 13 09:33:44 1994 (serrano)                */
;*                                                                     */
;*    On calcule les variables kapturees                               */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module lift_kapture
   (include "Var/variable.sch"
	    "Lift/lift.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    lift_closure
	    lift_fgraph)
   (export (kapture! var body G formals)))
 
;*---------------------------------------------------------------------*/
;*    kapture! ...                                                     */
;*    -------------------------------------------------------------    */
;*    Ce calcul se fait en deux temps:                                 */
;*       1- Parcours de l'arbre de syntaxe pour calculer les ensembles */
;*          des variables libres ainsi que les proprietaires de toutes */
;*          les variables locales                                      */
;*       2- Parcours de l'arbre d'appel pour collecter les infos du 1- */
;*---------------------------------------------------------------------*/
(define (kapture! var body G formals)
   (for-each (lambda (v)
		(lift-owner-set! (local-info v) var))
	     formals)
   (free-graph! body var var)
   (trace lift "----------------------------------------" #\newline)
   (for-each (lambda (g)
		(trace lift "Free( " (shape g) " ): "
		       (shape (lift-Free (local-info g))) #\Newline))
	     G)
   (trace lift "----------------------------------------" #\newline)
   (for-each (lambda (g)
		(ajust-bind-escaping! g)
		(let ((key (get-new-key)))
		   (get-kaptured! g key key)))
	     G)
   (trace lift "----------------------------------------" #\newline)
   ;; toutes les variables capturees ont ete calculees, on reparcours
   ;; les fonctions globalisees pour remplacer les fonctions capturees
   ;; par les fermetures correspondantes.
   (for-each (lambda (g)
		(let loop ((k (lift-kaptured (local-info g))))
		   (if (null? k)
		       'done
		       (begin
			  (cond
			     ((eq? (local-class (car k)) 'function)
			      (begin
				 (lift-kaptured?-set! (local-info
						       (the-closure (car k)))
						      #t)
				 (set-car! k (the-closure (car k)))))
			     ((eq? (local-class (car k)) 'return)
			      (begin
				 (lift-kaptured?-set! (local-info
						       (the-continue (car k)))
						      #t)
				 (set-car! k (the-continue (car k))))))
			  (loop (cdr k))))))
	     G)
;*---------------------------------------------------------------------*/
;*    Manuel le 27/08/93                                               */
;*---------------------------------------------------------------------*/
   ;; on marque les variables kapturees
   (for-each (lambda (g)
	       (for-each (lambda (l)
			   (lift-kaptured?-set! (local-info l) #t))
			 (lift-kaptured (local-info g))))
	     G)
   ;; et hop, juste quelques traces
   (for-each (lambda (g)
		(trace lift "Kaptured( " (shape g) " ): "
		       (shape (lift-kaptured (local-info g))) #\Newline))
	     G)
   (trace lift "----------------------------------------" #\newline))

;*---------------------------------------------------------------------*/
;*    get-kaptured! ...                                                */
;*---------------------------------------------------------------------*/
(define (get-kaptured! fun bottom key)
   (let ((lift (local-info fun)))
      (if (or (not (integer? (lift-key lift)))
	      (<fx (lift-key lift) bottom))
	  (lift-key-set! lift key))
      (trace (lift loop) "get-kaptured!: " (shape fun) (if (lift-kaptured lift)
						     " [ok]"
						     "")
	     #\Newline
	     "         free: " (shape (lift-free lift)) #\Newline
	     "         cto : " (shape (lift-cto lift)) #\Newline
	     "         be  : " (shape (lift-bind-escaping lift)) #\Newline
	     "         bot : " bottom #\Newline
	     "         key : " key #\Newline #\Newline)
      (if (lift-kaptured lift)
	  (cons key (lift-kaptured lift))
	  (let loop ((callee           (append (lift-cto lift)
					       (lift-bind-escaping lift)))
		     (sets-of-kaptured (list (lift-free lift)))
		     (save             key))
	     (trace (lift loop) "callee[" (shape fun) "] (" save "/" key ") : "
		    (shape callee) "...")
	     (if (null? callee)
		 (begin
		    (trace (lift loop) #\Newline)
		    (let ((kaptured (union key sets-of-kaptured fun)))
		       (if (>=fx save key)
			   (begin
			      (trace (lift loop) "Je save:" (shape kaptured))
			      (lift-kaptured-set! lift kaptured)))
		       (trace (lift loop) #\Newline)
		       (cons save kaptured)))
		 (let ((c (car callee)))
		    (cond
		       ((eq? c fun)
			(trace (lift loop) "[eq? c fun]" #\Newline)
			(loop (cdr callee)
			      sets-of-kaptured
			      save))
;*---------------------------------------------------------------------*/
;*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
;*    -------------------------------------------------------------    */
;*    J'ai fais cette modif le `Tue Dec 14 16:08:52 MET 1993', elle    */
;*    est accompagnee d'une autre modif dans le fichier cgraph.scm.    */
;*---------------------------------------------------------------------*/
;* 		       ((eq? (local-class c) 'return)  */
;* 			(trace (lift loop) "[return]" #\Newline)  */
;* 			(loop (cdr callee)  */
;* 			      sets-of-kaptured  */
;* 			      save))  */
;*---------------------------------------------------------------------*/
		       ((and (integer? (lift-key (local-info c)))
			     (>=fx (lift-key (local-info c)) bottom)
			     (<fx  (lift-key (local-info c)) key))
			(trace (lift loop) "[stack key]" #\Newline)
			(if (lift-kaptured (local-info c))
			    (loop (cdr callee)
				  (cons (lift-kaptured (local-info c))
					sets-of-kaptured)
				  (minfx save (lift-key (local-info c))))
			    (loop (cdr callee)
				  sets-of-kaptured
				  (minfx save (lift-key (local-info c))))))
		       (else
			(trace (lift loop) "[je cons]" #\Newline)
			(let ((kap (get-kaptured! c bottom (get-new-key))))
			   (loop (cdr callee)
				 (cons (cdr kap) sets-of-kaptured)
				 (minfx (car kap) save)))))))))))
	   
;*---------------------------------------------------------------------*/
;*    get-new-key ...                                                  */
;*---------------------------------------------------------------------*/
(define get-new-key
   (let ((key 0))
      (lambda ()
	 (set! key (+fx key 1))
	 key)))

;*---------------------------------------------------------------------*/
;*    union ...                                                        */
;*---------------------------------------------------------------------*/
(define (union key sets integrator)
   (trace (loop lift)
	  "union     : " (shape sets) #\Newline
	  "integrator: " (shape integrator) #\Newline
	  "Bind(I)   : " (shape (lift-bind (local-info integrator))) #\Newline)
   ;; on parcours les ensembles en mettant une nouvelle cle
   (let ((new-key  (get-new-key))
	 (old-keys (map (lambda (s) (map (lambda (v)
					    (lift-key (local-info v)))
					 s))
			sets)))
      (for-each (lambda (s) (for-each (lambda (v)
					 (lift-key-set! (local-info v)
							new-key))
				      s))
		sets)
      ;; on supprime toutes les variables definies par integrator
      (for-each (lambda (v)
		   (lift-key-set! (local-info v) key))
		(lift-bind (local-info integrator)))
      ;; on se supprime soit meme
      (lift-key-set! (local-info integrator) key)
      ;; on collecte en remettant key
      (let loop ((sets     sets)
		 (old-keys old-keys)
		 (res '()))
	 (if (null? sets)
	     res
	     (let liip ((s  (car sets))
			(ok (car old-keys))
			(r  res))
		(trace (loop lift) "    liip: " (shape s) #\Newline)
		(if (null? s)
		    (loop (cdr sets) (cdr old-keys) r)
		    (if (eq? (lift-key (local-info (car s))) new-key)
			;; ok, on la prend
			(begin
;*---------------------------------------------------------------------*/
;*    Manuel le 27/08/93                                               */
;*---------------------------------------------------------------------*/
			   ;; (lift-kaptured?-set! (local-info (car s)) #t)
			   (lift-key-set! (local-info (car s)) (car ok))
			   (cond
;*---------------------------------------------------------------------*/
;*    Manuel le 05/01/94                                               */
;*    -------------------------------------------------------------    */
;*    Normalement on peut supprimer les deux tests:                    */
;*       `function-escape?' et `lift-G?'                               */
;*    car j'ai change le code du ficher `fgraph.scm' (dans             */
;*    la fonction `free-graph!:application') pour ne plus              */
;*    mettre les fonctions uniquement appellees dans l'ensemble        */
;*    des variables libres.                                            */
;*---------------------------------------------------------------------*/
			      ((eq? (local-class (car s)) 'function)
			       (if (function-escape? (local-value (car s)))
				   (liip (cdr s)
					 (cdr ok)
					 (cons (car s) r))
				   (liip (cdr s) (cdr ok) r)))
			      ((eq? (local-class (car s)) 'return)
			       (if (lift-G? (local-info (car s)))
				   (liip (cdr s)
					 (cdr ok)
					 (cons (car s) r))
				   (liip (cdr s) (cdr ok) r)))
			      (else
			       (liip (cdr s) (cdr ok) (cons (car s) r)))))
			;; non, on ne la prend pas
			(liip (cdr s) (cdr ok) r))))))))

;*---------------------------------------------------------------------*/
;*    ajust-bind-escaping! ...                                         */
;*    -------------------------------------------------------------    */
;*    Il faut oter les occurences doubles de `bind-escaping' et        */
;*    retirer de l'ensemble les variables qui sont deja dans `cto'     */
;*---------------------------------------------------------------------*/
(define (ajust-bind-escaping! var)
   (let* ((lift     (local-info var))
	  (cto      (lift-cto lift))
	  (escaping (lift-bind-escaping lift))
	  (key      (get-new-key)))
      ;; on marque
      (for-each (lambda (v)
		   (lift-key-set! (local-info v) key))
		escaping)
      (for-each (lambda (v)
		   (lift-key-set! (local-info v) #f))
		cto)
      ;; on collecte
      (let loop ((escaping escaping)
		 (res     '()))
	 (if (null? escaping)
	     (lift-bind-escaping-set! lift res)
	     (if (eq? (lift-key (local-info (car escaping))) key)
		 (begin
		    (lift-key-set! (local-info (car escaping)) #f)
		    (loop (cdr escaping) (cons (car escaping) res)))
		 (loop (cdr escaping) res))))))
      
      
