;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.4/Lift/init.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr  2 09:34:38 1993                          */
;*    Last change :  Thu Jul 29 17:10:38 1993  (serrano)               */
;*                                                                     */
;*    On rajoute des initialisation dans la fonction d'initialisation  */
;*    du module                                                        */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module lift_init
   (include "Var/variable.sch")
   (import  var_declare
	    heap_abstract
	    tools_shape
	    lift_closure
	    0cfa_0cfa)
   (export  (lift-init-module! form) 
	    (declare-global-closure! global closure)))

;*---------------------------------------------------------------------*/
;*    declare-global-closure! ...                                      */
;*---------------------------------------------------------------------*/
(define (declare-global-closure! global closure)
   (let ((clo   (the-closure global))
	 (arity (function-arity (global-value global))))
      (remember-code!
       (if (memq global *0cfa-global-light-lambda*)
	   `(set! ,clo ,(abstract-make-light-procedure closure 0))
	   `(set! ,clo ,(if (>=fx arity 0)
			    (abstract-make-fx-procedure closure arity 0)
			    (abstract-make-va-procedure closure arity 0)))))))
       
;*---------------------------------------------------------------------*/
;*    *remember-code*                                                  */
;*---------------------------------------------------------------------*/
(define *remember-code* '())

;*---------------------------------------------------------------------*/
;*    remember-code ...                                                */
;*---------------------------------------------------------------------*/
(define (remember-code! code)
   (set! *remember-code* (cons code *remember-code*)))

;*---------------------------------------------------------------------*/
;*    lift-init-module!                                                */
;*---------------------------------------------------------------------*/
(define (lift-init-module! var)
   (if (null? *remember-code*)
       'ok
       (let* ((old-body  (function-body (global-value var)))
	      (new-body `(begin ,@*remember-code* ,old-body)))
	  (function-body-set! (global-value var) new-body))))
  
   
