;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.5/Lift/closure.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 31 13:10:08 1993                          */
;*    Last change :  Mon Dec 20 11:12:42 1993 (serrano)                */
;*                                                                     */
;*    La manipulation des fermetures                                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module lift_closure
   (include "Var/variable.sch"
	    "Lift/lift.sch")
   (import  tools_shape
	    tools_strings
	    var_declare
	    engine_param
	    scan_lexical
	    lift_cgraph)
   (export  (the-closure  var)
	    (the-continue var)))

;*---------------------------------------------------------------------*/
;*    the-closure ...                                                  */
;*---------------------------------------------------------------------*/
(define (the-closure var)
   (define (the-local-closure var)
      (let ((function (local-value var)))
	 (if (not (null? (function-the-closure function)))
	     (function-the-closure function)
	     (let ((closure (cdar (allocate-local-variables
				   (list (upper-string->symbol
					  (string-append
					   (symbol->string (local-name var))
					   "_env")))))))
		(function-the-closure-set! function closure)
		(make-local-lift! closure)
		(lift-closure-of-set! (local-info closure) var)
		closure))))
   (define (the-global-closure var)
      (let ((function (global-value var)))
	 (if (not (null? (function-the-closure function)))
	     (function-the-closure function)
	     (let ((closure (declare-global-variable! (upper-string->symbol
						       (string-append
							(symbol->string
							 (global-name var))
							"_env"))
						      (global-module var)
						      (global-import var))))
		(function-the-closure-set! function closure)
		closure))))
   (cond
      ((local? var)
       (the-local-closure var))
      ((global? var)
       (the-global-closure var))
      (else
       (error "the-closure" "not a variable" (shape var)))))
		
;*---------------------------------------------------------------------*/
;*    the-continue ...                                                 */
;*---------------------------------------------------------------------*/
(define (the-continue var)
   (let ((return (local-value var)))
      (if (not (null? (return-the-continue return)))
	  (return-the-continue return)
	  (let ((continue (cdar (allocate-local-variables
				 (list (upper-string->symbol
					(string-append
					 (symbol->string (local-name var))
					 "_cont")))))))
	     (return-the-continue-set! return continue)
	     (make-local-lift! continue)
	     continue))))
