;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Inline/call.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 22 17:07:39 1993                          */
;*    Last change :  Thu Jun  2 17:08:24 1994 (serrano)                */
;*                                                                     */
;*    L'inlining d'un funcall                                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module inline_call
   (include "Var/variable.sch"
	    "Tools/trace.sch")
   (import  engine_param
	    tools_error
	    tools_shape
	    tools_beta
	    tools_alpha
	    tools_progn
	    effect_property
	    scan_lexical
	    scan_tree
	    heap_abstract
	    inline_walk
	    inline_loop
	    foreign_tools
	    type_type)
   (export  (inline-function? variable level stack)
	    (can-be-folded?   formal   actual)
	    (inline-call      form     level stack)))

;*---------------------------------------------------------------------*/
;*    inline-call ...                                                  */
;*---------------------------------------------------------------------*/
(define (inline-call exp level stack)
   (trace inline "J'inline l'appel: " (shape exp) #\Newline)
   (let* ((var       (car exp))
	  (function  (if (global? var)
			 (global-value var)
			 (local-value var))))
      ;; il faut avant toutes choses s'assurer que la version de body
      ;; qu'on a pour cette fonction correspond bien a un arbre de
      ;; syntaxe abstraite. Si ce n'est pas le cas, on le construit.
      (if (and (global? var)
	       (eq? (global-import var) 'import)
	       (and (boolean? (function-inline? function))
		    (function-inline? function))
	       (not (eq? (global-info var) '_tree-done_)))
	  ;; voila, on est dans le mauvais cas, on construit l'arbre
	  ;; du code a inline
	  (begin
	     (global-info-set! var '_tree-done_)
	     (make-function-tree var
				 (function-args function)
				 (function-body function))))
      (if (is-loop? var)
	  (inline-call/labels exp level stack var function)
	  (inline-call/let exp level stack var function))))

;*---------------------------------------------------------------------*/
;*    inline-call/let ...                                              */
;*---------------------------------------------------------------------*/
(define (inline-call/let exp level stack var function)
   (let* ((args       (function-args function))
	  (body       (normalize-progn (cdr (function-body function))))
	  (substitute (quoi->par var (function-arity function)
				 args (cdr exp)))
	  (quoi.par   (car substitute))
	  (bindings   (cdr substitute)))
      (trace inline "inline-call: " (shape exp) #\Newline
	     "  substitute: " (shape substitute) #\Newline)
      (let* ((body1 (do-inline (beta-reduce (alphatize body) quoi.par)
			       (+fx level 1)
			       (cons var stack)))
	     (body  (let/O2 body1)))
	 (let loop ((bindings bindings))
	    (if (null? bindings)
		body
		(let ((f.a (car bindings)))
		   `(let (,(begin
			      (set-car! (cdr f.a)
					(do-inline (cadr f.a)
						   (+fx 1 level)
						   stack))
			      f.a))
		       ,(loop (cdr bindings)))))))))

;*---------------------------------------------------------------------*/
;*    quoi->par ...                                                    */
;*    -------------------------------------------------------------    */
;*    On calcule la liste des remplacement a effectuer.                */
;*    Cette fonction nous oblige a verifier maintenant l'arite des     */
;*    fonction inlinees. On est oblige de faire ce test de type avant  */
;*    la passe normalement consacre a cela.                            */
;*---------------------------------------------------------------------*/
(define (quoi->par called arity formals actuals)
   (trace inline
	  "quoi->par: " (shape called) " arity: " arity #\Newline
	  "  formals: " (shape formals) #\Newline
	  "  actuals: " (shape actuals) #\Newline)
   (define (fx-quoi->par)
      (let loop ((formals   formals)
		 (actuals   actuals)
		 (quoi.par  '())
		 (bindings  '()))
	 (cond
	    ((null? formals)
	     (if (null? actuals)
		 (cons quoi.par bindings)
		 (begin
		    (partial-error ""
				   "Too many arguments provided in a call to"
				   (shape called))
		    (cons '() '()))))
	    ((null? actuals)
	     (partial-error ""
			    "Too few arguments provided in a call to"
			    (shape called))
	     (cons '() '()))
	    (else
	     (let ((formal (car formals))
		   (actual (car actuals)))
		(if (can-be-folded? formal actual)
		    ;; on ne cree pas une nouvelle variable.
		    (loop (cdr formals)
			  (cdr actuals)
			  (cons `(,formal . ,actual) quoi.par)
			  bindings)
		    (let ((new (copy-local-variable formal)))
		       (loop (cdr formals)
			     (cdr actuals)
			     (cons `(,formal . ,new) quoi.par)
			     (cons `(,new ,actual)
				   bindings)))))))))
   (define (va-quoi->par)
      (let loop ((formals   formals)
		 (actuals   actuals)
		 (quoi.par  '())
		 (bindings  '())
		 (counter   arity))
	 (cond
	    ((=fx counter -1)
	     (let ((new (copy-local-variable (car formals))))
		(cons (cons `(,(car formals) . ,new) quoi.par)
		      (cons `(,new ,(make-args-list actuals))
			    bindings))))
	    ((null? actuals)
	      (partial-error ""
			    "Too few arguments provided in a call to"
			    (shape called))
	      (cons '() '()))
	    (else
	     (let ((formal (car formals))
		   (actual (car actuals)))
		(if (can-be-folded? formal actual)
		    ;; on ne cree pas une nouvelle variable.
		    (loop (cdr formals)
			  (cdr actuals)
			  (cons `(,formal . ,actual) quoi.par)
			  bindings
			  (+fx counter 1))
		    (let ((new (copy-local-variable formal)))
		       (loop (cdr formals)
			     (cdr actuals)
			     (cons `(,formal . ,new) quoi.par)
			     (cons `(,new ,actual)
				   bindings)
			     (+fx counter 1)))))))))
   (if (<fx arity 0)
       (va-quoi->par)
       (fx-quoi->par)))

;*---------------------------------------------------------------------*/
;*    can-be-folded? ...                                               */
;*    peut-on faire du constante folding en remplacant `formal' par    */
;*    `actual' ?                                                       */
;*---------------------------------------------------------------------*/
(define (can-be-folded? formal actual)
   (or (and (global? actual)
	    (eq? (global-class actual) 'function))
       (and (not (pair? actual))
	    (not (global? actual))
	    (or (not (local? actual))
		(not (eq? (local-access actual) 'write)))
	    (not (eq? (local-access formal) 'write)))
       (and (pair? actual)
	    (eq? (car actual) 'quote)
	    (pair? (cdr actual))
	    (symbol? (cadr actual)))))

;*---------------------------------------------------------------------*/
;*    make-args-list ...                                               */
;*---------------------------------------------------------------------*/
(define (make-args-list actuals)
   ;; on construit (en syntaxe abstraite) une serie de cons.
   (let loop ((actuals actuals))
      (if (null? actuals)
	  (abstract-nil)
	  (abstract-cons (car actuals) (loop (cdr actuals))))))

;*---------------------------------------------------------------------*/
;*    inline-function? ...                                             */
;*---------------------------------------------------------------------*/
(define (inline-function? variable level stack)
   (trace inline "Faut-il inliner " (shape variable) " ? " #\Newline)
   (if (not (global? variable))
       #f
       (let ((function (global-value variable))
	     (import   (global-import variable))
	     (class    (global-class variable)))
	  (if (not (eq? class 'function))
	      #f
	      (let ((body (function-body function)))
		 (trace inline
			"   inlined?    : " (function-inline? function)
			#\Newline
			"       body    : " (shape body) #\Newline
			"   invocations : " (function-invocations function)
			#\Newline #\Newline)
		 (cond
		    ((>fx level *inline-level-max*)
		     (and (pair? body)
			  (eq? (car body) 'begin)
			  (global? (cadr body))
			  (eq? (global-class (cadr body)) 'foreign)))
		    ((memq variable stack)
		     ;; meme avec les inlines des boucles ce tests doit
		     ;; subsiste pour eviter de generer trop de code dans des
		     ;; appels recursifs diadique (pair/impair par exemple)
		     (trace inline "   NON.0" #\Newline)
		     #f)
		    ((boolean? (function-inline? function))
		     (function-inline? function))
		    ((or (<fx *optim* 1)
			 (not *inlining?*))
		     (trace inline "   NON.1" #\Newline)
		     #f)
		    ((eq? import 'import)
		     (trace inline "   NON.2" #\Newline)
		     #f)
		    ((not (pair? body))
		     ;; le corps est simplissime
		     #t)
		    ((=fx (function-invocations function) 1)
		     (smaller-size? 6 function body))
;*---------------------------------------------------------------------*/
;*    Le critere commente ci-dessous faisait echouer la compilation de */
;*    kb et de toutes facons, il faisait ramer enorment la 0cfa.       */
;*    Neanmoins, il faudrait corrige l'erreur. Je pense qu'elle doit   */
;*    etre dans l'alphaconversion de l'arbre inline.                   */
;*    -------------------------------------------------------------    */
;* 		     ;; on l'inline car la fonction n'est invoquee     */
;* 		     ;; qu'une seule fois dans le module.              */
;* 		     (trace inline "   PEUT-ETRE (>= *optim* 2)"       */
;* 			    #\Newline)                                 */
;* 		     (if (eq? import 'export)                          */
;* 			 ;; si elle est exportee on ne l'inline        */
;* 			 ;; qu'en -O2                                  */
;* 			 (>=fx *optim* 2)                              */
;* 			 #t)                                           */
;*---------------------------------------------------------------------*/
		    (else
		     (smaller-size? 3 function body))))))))

;*---------------------------------------------------------------------*/
;*    smaller-size? ...                                                */
;*    -------------------------------------------------------------    */
;*    On mesure la taille du code pour voir si elle est plus petit     */
;*    qu'une certaine valeur (calculee en fonction de l'arite de la    */
;*    fonction et du coef passe en argument). Si le critere de taille  */
;*    est satisfait on inline sinon on n'inline pas.                   */
;*---------------------------------------------------------------------*/
(define (smaller-size? coef function body)
   (if (<-nb-leaf-and-no-bind-exit?
	body
	(if (<fx (function-arity function) 0)
	    (*fx coef (+fx (+fx 1 (- (function-arity function))) *optim*))
	    (*fx coef (+fx (+fx 1 (function-arity function)) *optim*))))
       (begin
	  (trace inline "   OUI (" coef ")" #\Newline)
	  (function-inline?-set! function #t)
	  #t)
       (begin
	  (trace inline "   NON.3" #\Newline)
	  (function-inline?-set! function #f)
	  #f)))

;*---------------------------------------------------------------------*/
;*    <-nb-leaf-and-no-bind-exit? ..                                   */
;*    -------------------------------------------------------------    */
;*    Est-ce que le nombre de feuille de `body' est plus petit que     */
;*    'max' ou est-ce qu'il y a un bind-exit dans le code ?            */
;*    -------------------------------------------------------------    */
;*    Je regarde s'il y a des bind-exit car il est penible d'integrer  */
;*    une fonction qui en contient car en generale cette forme a       */
;*    tendance a franchement grossir et generer bon nombre de fonction.*/
;*    Je prefere donc etre petit joueur et ne pas faire l'integration  */
;*    dans ce cas.                                                     */
;*---------------------------------------------------------------------*/
(define (<-nb-leaf-and-no-bind-exit? exp max)
   (trace inline "<-nb-leaf-and-no-bind-exit?: " (shape exp) #\Newline
	  "max: " max #\Newline)
   (let loop ((exp exp)
	      (acc 0))
      (cond
	 ((not acc)
	  #f)
	 ((>fx acc max)
	  #f)
	 ((null? exp)
	  acc)
	 ((not (pair? exp))
	  (if (or (eq? exp 'bind-exit) (>=fx acc max))
	      #f
	      (+fx acc 1)))
	 (else
	  (let liip ((exp exp)
		     (acc acc))
	     (cond
		((not acc)
		 #f)
		((>fx acc max)
		 #f)
		((null? exp)
		 acc)
		((not (pair? exp))
		 (loop exp (+fx acc 1)))
		(else
		 (liip (cdr exp) (loop (car exp) acc)))))))))
	      
;*---------------------------------------------------------------------*/
;*    let/O2 ...                                                       */
;*    -------------------------------------------------------------    */
;*    Si on est en mode -O2 et que l'inline n'est pas dangeureuse, on  */
;*    met le resultat dans une variable.                               */
;*---------------------------------------------------------------------*/
(define (let/O2 body)
   (trace inline "let/02: " (shape body) #\Newline)
   (if (and (>=fx *optim* 2)
	    (pair? body)
	    (not (side-effect? body))
	    (bigloo-type? (type-of body)))
       ;; c'est bon, on utilise une variable.
       (let* ((name (cond
		       ((global? (car body))
			(global-name (car body)))
		       ((local? (car body))
			(local-name (car body)))
		       (else
			'aux)))
	      (aux (cdr (car (allocate-local-variables (list name))))))
	  `(let ((,aux ,body))
	      ,aux))
       body))

       
 
       
 
