;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../access.scm ...                                               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Oct 26 09:13:14 1993                          */
;*    Last change :  Thu Jan 20 02:23:22 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On construit les accesseurs de tous les types                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module foreign_access
   (include "Foreign/type.sch")
   (import  foreign_parse
	    foreign_tools
	    foreign_atomic
	    foreign_declare
	    tools_args
	    tools_shape
	    engine_param
	    parse_foreign
	    heap_abstract
	    type_enforce
	    var_env)
   (export  (make-foreign-access! code)))

;*---------------------------------------------------------------------*/
;*    make-foreign-access! ...                                         */
;*    -------------------------------------------------------------    */
;*    On construit pour tous les types leurs accesseurs, seteurs,      */
;*   testeurs et createurs.                                            */
;*---------------------------------------------------------------------*/
(define (make-foreign-access! code)
   (if (not (all-type-used-defined?))
       (error "foreign-end!"
	      "Some foreign type are used but not defined"
	      (missing-foreign-type))
       ;; c'est bon, on a trouve toutes les definitions, on construit
       ;; tous les accesseurs et c'est fini.
       (begin
	  (for-each-type! (lambda (t)
			     (set! code (append (make-type-access! t) code))))
	  code)))

;*---------------------------------------------------------------------*/
;*    make-type-access! ...                                            */
;*---------------------------------------------------------------------*/
(define (make-type-access! t)
   (case (type-type t)
      ((c-foreign-struct)
       (make-struct-access t))
      ((c-foreign-bound-array) 
       (make-bound-array-access t))
      ((c-foreign-unbound-array)
       (make-unbound-array-access t))
      ((c-foreign-pointer)
       (make-pointer-access t))
      (else
       '())))

;*---------------------------------------------------------------------*/
;*    make-struct-access ...                                           */
;*---------------------------------------------------------------------*/
(define (make-struct-access type)
   (let* ((exp        (type-exp type))
	  (id         (type-id  type))
	  (id?        (symbol-append id '?))
	  (btype      (type-btype type))
	  (ptype      (car (type-ptypes type)))
	  (bid        (type-id btype))
	  (name-sans* (type-name type))
	  (name*      (type-name ptype))
	  (sid        (type-id ptype)))
      (parse-foreign (list `(,bid ,(symbol-append 'c-make- id)
				  (bobj int)
				  "allocate_foreign")
			   `(define ,sid ,(symbol-append bid '-> id)
			       (,bid)
			       "BFOREIGN_TO_CFOREIGN")
			   `(define ,id ,(symbol-append '* id)
			       (foreign)
			       "*"))
		     'export)
      (let loop ((slot exp)
		 (exp  (list
			`(define-inline (,id? o)
			    (c-foreign-is? o ',id))
			`(define-inline (,(symbol-append 'make- id))
			    (,(symbol-append 'c-make- id)
			     ',id
			     (sizeof (pragma ,name-sans*)))))))
	 (if (null? slot)
	     exp
	     (match-case (car slot)
		((?tname ?sname)
		 (let* ((t          (get-type tname))
			(name       (string->symbol (string-upcase sname)))
			(bt         (if (type? (type-btype t))
					(type-btype t)
					t))
			(ref-name   (symbol-append id '- name))
			(set-name   (symbol-append id '- name '-set!))
			(c-ref-name (symbol-append 'c- ref-name))
			(c-set-name (symbol-append 'c- set-name)))
		    ;; il faut creer les deux accesseurs C
		    (parse-foreign
		     (list `(define ,(type-id t)
			       ,c-ref-name
			       (,bid obj obj) "FOREIGN_STRUCT_REF")
			   `(define obj
			       ,c-set-name
			       (,bid obj obj ,(type-id t))
			       "FOREIGN_STRUCT_SET"))
		     'export)
		    (loop
		     (cdr slot)
		     (cons
		      `(define-inline (,ref-name o)
			  (,c-ref-name o
				       (pragma ,name*)
				       (pragma ,sname)))
		      (cons
		       `(define-inline (,set-name o v)
			   (,c-set-name o
					(pragma ,name*)
					(pragma ,sname)
					v))
		       exp)))))
		(else
		 (loop (cdr slot) exp)))))))

;*---------------------------------------------------------------------*/
;*    make-bound-array-access ...                                      */
;*---------------------------------------------------------------------*/
(define (make-bound-array-access type)
   (let* ((exp         (type-exp type))
	  (id          (type-id  type))
	  (id-ref      (symbol-append id 'ref))
	  (id-set!     (symbol-append id 'set!))
	  (id?         (symbol-append id '?))
	  (btype       (type-btype type))
	  (bid         (type-id btype))
	  (tof         (car exp))
	  (tof-id      (type-id tof))
	  (min         (cadr exp))
	  (max         (caddr exp))
	  (name-sans*  (substring (type-name type)
				  0
				  (- (string-length (type-name type)) 2))))
      (parse-foreign (list `(,bid ,(symbol-append 'c-make- id)
				  (bobj int)
				  "allocate_foreign")
			   `(define ,tof-id ,id-ref (bobj ,id int)
			       "FOREIGN_ARRAY_REF")
			   `(define obj ,id-set! (bobj ,id int ,tof-id)
			       "FOREIGN_ARRAY_SET")
			   `(define ,id ,(symbol-append bid '-> id)
			       (,bid)
			       "BFOREIGN_TO_CFOREIGN"))
		     'export)
      (list `(define-inline (,id? o)
		(and (c-foreign? o)
		     (eq? (c-foreign-id o) ',id)))
	    `(define-inline (,(symbol-append 'make- id))
		(,(symbol-append 'c-make- id)
		 ',id
		 (sizeof (pragma ,(string-append name-sans*
						 "[ "
						 (integer->string
						  (+fx (-fx max min) 1))
						 " ]")))))
	    (if *unsafe-range*
		`(define-inline (,(symbol-append id '-ref) tab offset)
		    (,id-ref (pragma ,(type-name type)) tab offset))
		`(define-inline (,(symbol-append id '-ref) tab _offset)
		    (let ((offset (-fx _offset ,min)))
		       (if (vector-bound-check? offset ,(+fx 1 (-fx max min)))
			   (,id-ref (pragma ,(type-name type))
				    tab
				    offset)
			   (failure "array-ref" "Illegal offset" _offset)))))
	    (if *unsafe-range*
		`(define-inline (,(symbol-append id '-set!) tab offset value)
		    (,id-set! (pragma ,(type-name type)) tab offset value))
		`(define-inline (,(symbol-append id '-set!) tab _offset value)
		    (let ((offset (-fx _offset ,min)))
		       (if (vector-bound-check? offset ,(+fx 1 (-fx max min)))
			   (,id-set! (pragma ,(type-name type))
				     tab
				     offset
				     value)
			   (failure "array-ref"
				    "Illegal offset"
				    _offset))))))))

;*---------------------------------------------------------------------*/
;*    make-unbound-array-access ...                                    */
;*---------------------------------------------------------------------*/
(define (make-unbound-array-access type)
   (let* ((exp         (type-exp type))
	  (id          (type-id  type))
	  (id-ref      (symbol-append id 'ref))
	  (id-set!     (symbol-append id 'set!))
	  (id?         (symbol-append id '?))
	  (btype       (type-btype type))
	  (bid         (type-id btype))
	  (tof         exp)
	  (tof-id      (type-id tof)))
      (parse-foreign (list `(define ,tof-id ,id-ref (bobj ,id int)
			            "FOREIGN_ARRAY_REF")
			   `(define obj ,id-set! (bobj ,id int ,tof-id)
				    "FOREIGN_ARRAY_SET")
			   `(define ,id ,(symbol-append bid '-> id)
			                 (,bid)
					 "BFOREIGN_TO_CFOREIGN"))
		     'export)
      (list `(define-inline (,id? o)
		(and (c-foreign? o)
		     (eq? (c-foreign-id o) ',id)))
	    `(define-inline (,(symbol-append id '-ref) tab offset)
		(,id-ref (pragma ,(type-name type)) tab offset))
	    `(define-inline (,(symbol-append id '-set!) tab offset value)
		(,id-set! (pragma ,(type-name type)) tab offset value)))))

;*---------------------------------------------------------------------*/
;*    make-pointer-access ...                                          */
;*---------------------------------------------------------------------*/
(define (make-pointer-access type)
   (let* ((exp         (type-exp type))
	  (id          (type-id  type))
	  (id-ref      (symbol-append id 'ref))
	  (id-set!     (symbol-append id 'set!))
	  (id?         (symbol-append id '?))
	  (btype       (type-btype type))
	  (bid         (type-id btype))
	  (tof         exp)
	  (tof-id      (type-id tof)))
      (parse-foreign (list `(define ,tof-id ,id-ref (bobj ,id int)
			            "FOREIGN_ARRAY_REF")
			   `(,bid ,(symbol-append 'c-make- id)
				  (bobj int)
				  "allocate_foreign")
			   `(define obj ,id-set! (bobj ,id int ,tof-id)
				    "FOREIGN_ARRAY_SET")
			   `(define ,id ,(symbol-append bid '-> id)
			                 (,bid)
					 "BFOREIGN_TO_CFOREIGN"))
		     'export)
      (list `(define-inline (,id? o)
		(and (c-foreign? o)
		     (eq? (c-foreign-id o) ',id)))
	    `(define-inline (,(symbol-append 'make- id))
		(,(symbol-append 'c-make- id)
		 ',id
		 (sizeof (pragma ,(string-append (type-name type))))))
	    `(define-inline (,(symbol-append id '-ref) ptr)
		(,id-ref (pragma ,(type-name type)) ptr 0))
	    `(define-inline (,(symbol-append id '-set!) ptr value)
		(,id-set! (pragma ,(type-name type)) ptr 0 value)))))

