;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/runtime0.2/Llib/tag.scm ...                    */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Dec 18 13:37:00 1993                          */
;*    Last change :  Wed May 25 17:59:17 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Les fonctions Bigloo qui manipulent les tags                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __caml_tag
   (foreign (include "value-bigloo.h")
	    (include "CAMLClib/fail.h")
            (define int OUT_OF_MEMORY_EXN     "OUT_OF_MEMORY_EXN")
            (define int SYS_ERROR_EXN         "SYS_ERROR_EXN")
            (define int FAILURE_EXN           "FAILURE_EXN")
            (define int INVALID_EXN           "INVALID_EXN")
            (define int END_OF_FILE_EXN       "END_OF_FILE_EXN")
            (define int ZERO_DIVIDE_EXN       "ZERO_DIVIDE_EXN")
            (define int BREAK_EXN             "BREAK_EXN")
            (define int NOT_FOUND_EXN         "NOT_FOUND_EXN")
            (define int UNIX_ERROR_EXN        "UNIX_ERROR_EXN")
            (define int GRAPHIC_FAILURE_EXN   "GRAPHIC_FAILURE_EXN")
            (define int PARSE_FAILURE_EXN     "PARSE_FAILURE_EXN")
	    (define bint Num_tags             "Num_tags")
	    (define bint No_scan_tag          "No_scan_tag")
	    (define bint Scan_tag             "Scan_tag")
	    (define bint Closure_tag          "Closure_tag")
	    (define bint String_tag           "String_tag")
	    (define bint Double_tag           "Double_tag")
	    (define bool obj_is_block (obj)   "Is_block"))
   (import  (__caml_constr "Llib/constr.scm"))
   (export  (tag-of value)))

;*---------------------------------------------------------------------*/
;*    tag-of ...                                                       */
;*---------------------------------------------------------------------*/
(define (tag-of value)
   (cond
      ((and (may-be-an-extensible-constr? value)
	    (caml-extensible-constr? value))
       (case (caml-extensible-constr-tag value)
	  ((out_of_memory_1@exc)
	   OUT_OF_MEMORY_EXN)
	  ((invalid_argument_2@exc)
	   INVALID_EXN)
	  ((failure_3@exc)
	   FAILURE_EXN)
	  ((not_found_4@exc)
	   NOT_FOUND_EXN)
	  ((sys_error_1@sys)
	   SYS_ERROR_EXN)
	  ((break_2@sys)
	   BREAK_EXN)
	  ((end_of_file_1@io)
	   END_OF_FILE_EXN)
	  ((division_by_zero_1@int)
	   ZERO_DIVIDE_EXN)
	  ((parse_failure_1@stream)
	   PARSE_FAILURE_EXN)
	  ((parse_error_2@stream)
	   PARSE_FAILURE_EXN)
	  (else
	   -1)))
      ((integer? value)
       Num_tags)
      ((cnst? value)
       No_scan_tag)
      ((string? value)
       String_tag)
      ((char? value)
       Num_tags)
      ((real? value)
       Double_tag)
      ((procedure? value)
       Closure_tag)
      (else
       Scan_tag)))
	    
