;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/runtime0.0/Llib/intext.scm ...                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Dec 18 14:44:33 1993                          */
;*    Last change :  Mon Mar 14 08:38:57 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    L'internement (et externement) des valeurs (avec respect du      */
;*    partage)                                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __caml_intext
   (foreign (obj putword   (obj obj) "putword")
	    (obj getword   (obj)     "getword"))
   (import  (failwith_217@exc __caml_exc ".Olib/Mlib/exc.scm")
	    (__caml_bio                  "Llib/bio.scm"))
   (export  (intern_val channel)
	    (extern_val channel exp)))

;*---------------------------------------------------------------------*/
;*    MAGIC_NUMBER ...                                                 */
;*---------------------------------------------------------------------*/
(define MAGIC_NUMBER #x495A6B9)
 
;*---------------------------------------------------------------------*/
;*    intern_val ...                                                   */
;*---------------------------------------------------------------------*/
(define (intern_val channel)
   (let ((to-be-magic (getword channel)))
      (if (not (eq? to-be-magic MAGIC_NUMBER))
	  (failwith_217@exc "intern: bad object")
	  (let* ((len       (getword channel))
		 (buf       (make-string len))
		 (res       (intern-value channel buf 0 len)))
	     (if (not res)
		 (failwith_217@exc "intern : truncated object")
		 (string->obj buf))))))

;*---------------------------------------------------------------------*/
;*    extern_val ...                                                   */
;*---------------------------------------------------------------------*/
(define (extern_val channel exp)
   (let ((str (obj->string exp)))
      (putword channel MAGIC_NUMBER)
      (putword channel (string-length str))
      (output channel str 0 (string-length str))))
