;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/runtime0.0/Llib/handle.scm ...                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec  7 13:10:50 1993                          */
;*    Last change :  Mon Mar 14 08:39:05 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La gestion (complete) des handlers                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __caml_handle
   (foreign (include "caml-bigloo.h")
	    (define obj get-the-continuation (obj) "GET_THE_CONTINUATION")
	    (define obj invoke-continuation  (obj) "INVOKE_CONTINUATION")
	    (export obj current_handler "current_handler")
	    (export obj continuation_value "continuation_value"))
   (export  (staticfail)
	    (inline raise value)
	    current_handler
	    continuation_value
	    (string-of-exception x)
	    *try*)) 
 
;*---------------------------------------------------------------------*/
;*    *try*                                                            */
;*---------------------------------------------------------------------*/
(define *try* 0)

;*---------------------------------------------------------------------*/
;*    current_handler                                                  */
;*---------------------------------------------------------------------*/
(define current_handler #f)

;*---------------------------------------------------------------------*/
;*    continuation_value                                               */
;*---------------------------------------------------------------------*/
(define continuation_value #f)

;*---------------------------------------------------------------------*/
;*    staticfail ...                                                   */
;*---------------------------------------------------------------------*/
(define (staticfail)
   (error "staticfail" "Illegal staticfail reached" '()))

;*---------------------------------------------------------------------*/
;*    raise ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (raise value)
   (set! *try* 1)
   (if (eq? current_handler #f)
       (error "Fatal error" "uncaught exception." value)
       (begin
	  (invoke-continuation value)
	  (unspecified))))
   
;*---------------------------------------------------------------------*/
;*    string-of-exception ...                                          */
;*---------------------------------------------------------------------*/
(define (string-of-exception x)
   (let ((p (open-output-string)))
      (display x p)
      (close-output-port p)))
   
