/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*    serrano/ml/camloo/runtime0.0/Clib/sys.c ...                      */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Thu Dec 16 11:45:08 1993                          */
/*    Last change :  Wed Jan  5 14:07:27 1994 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Ma version du fichier sys.c                                      */
/*=====================================================================*/
#include <bigloo.h>
#include <caml-bigloo.h>
#include <value-bigloo.h>
#include <errno.h>
#include <fcntl.h>
#include "../CAMLClib/fail.h"

#ifndef O_BINARY
#define O_BINARY 0
#endif
#ifndef O_TEXT
#define O_TEXT 0
#endif

/*---------------------------------------------------------------------*/
/*    Les externs                                                      */
/*---------------------------------------------------------------------*/
extern int errno;

#ifdef HAS_STRERROR
/*---------------------------------------------------------------------*/
/*    char *                                                           */
/*    error_message ...                                                */
/*---------------------------------------------------------------------*/
char *
error_message()
{
	return strerror( errno );
}

#else

/*---------------------------------------------------------------------*/
/*    D'autres recuperations externes                                  */
/*---------------------------------------------------------------------*/
extern int sys_nerr;
extern char * sys_errlist [];

/*---------------------------------------------------------------------*/
/*    char *                                                           */
/*    error_message ...                                                */
/*---------------------------------------------------------------------*/
char *
error_message()
{
	if( errno < 0 || errno >= sys_nerr )
	   return "unknown error";
	else
	   return sys_errlist[ errno ];
}

#endif HAS_STRERROR

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    sys_error ...                                                    */
/*---------------------------------------------------------------------*/
void
sys_error()
{
	raise_with_string( SYS_ERROR_EXN, error_message() );
}


/*---------------------------------------------------------------------*/
/*    sys_open_flags                                                   */
/*---------------------------------------------------------------------*/
static int sys_open_flags[] = {
  O_RDONLY, O_WRONLY, O_RDWR, O_APPEND, O_CREAT, O_TRUNC, O_EXCL,
  O_BINARY, O_TEXT
};

/*---------------------------------------------------------------------*/
/*    value                                                            */
/*    sys_open ...                                                     */
/*---------------------------------------------------------------------*/
value
sys_open( path, flags, perm )
value path, flags, perm;
{
	int ret;

	ret = open( String_val( path ),
				   convert_flag_list( flags, sys_open_flags ),
				   Int_val( perm ) );

	if( ret == -1 )
	   sys_error();
	else
	   return Val_long( ret );
}


/*---------------------------------------------------------------------*/
/*    value                                                            */
/*    sys_close ...                                                    */
/*---------------------------------------------------------------------*/
value
sys_close( fd )
value fd;
{
	if( close( Int_val( fd ) ) != 0)
	   sys_error();
	else
	   return Atom( 0 );
}


