/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*    serrano/ml/camloo/runtime0.2/Clib/constr.c ...                   */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec  7 08:04:09 1993                          */
/*    Last change :  Sat May 28 10:06:31 1994 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Les constructeurs                                                */
/*=====================================================================*/
#include <bigloo.h>
#include <caml-bigloo.h>
#include <varargs.h>

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    caml_allocate_regular ...                                        */
/*---------------------------------------------------------------------*/
obj_t
caml_allocate_regular( size, tag )
obj_t size, tag;
{
	obj_t vect, aux;

	vect = MAKE_OBJECT( VECTOR_SIZE + (CINT( size ) * OBJ_SIZE),
							  HEADER_VECTOR,
							  aux );

	vect->vector_t.length = size;
	VECTOR_TAG_SET( BREF( vect ), tag );

	return BREF( vect );
}
	
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    caml_make_regular ...                                            */
/*    -------------------------------------------------------------    */
/*    L'allocateur generale de constructeurss regulier                 */
/*---------------------------------------------------------------------*/
obj_t
caml_make_regular( va_alist )
va_dcl
{
	va_list argl;
	obj_t   tag;
	int     nb;
   obj_t   vect, aux;
	int     i;

	va_start( argl );

	tag    = va_arg( argl, obj_t );
	nb     = CINT( va_arg( argl, obj_t ) );
	
	/* Cette allocation doit etre la meme que celle faite dans le   */
	/* fichier Clib/vector.c de la librairie.                       */
	vect = MAKE_OBJECT( VECTOR_SIZE + ( nb * OBJ_SIZE ), HEADER_VECTOR, aux );

	vect->vector_t.length = BINT( nb );
	VECTOR_TAG_SET( BREF( vect ), tag );

	/* on initialise les differents champs du vecteurs              */
	for( i = 0; i < nb; i++ )
	   CAML_CONSTR_SET_FIELD( BREF( vect ),
									  BINT( i ),
									  va_arg( argl, obj_t ) );

	va_end( argl );
	
	return BREF( vect );
} 

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    caml_make_regular_1 ...                                          */
/*---------------------------------------------------------------------*/
obj_t
caml_make_regular_1( tag, val )
obj_t tag, val;
{
	obj_t vect, aux;

	vect = MAKE_OBJECT( VECTOR_SIZE + OBJ_SIZE, HEADER_VECTOR, aux );

	vect->vector_t.length = BINT( 1 );
	VECTOR_TAG_SET( BREF( vect ), tag );

	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 0 ), val );

	return BREF( vect );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    caml_make_regular_2 ...                                          */
/*---------------------------------------------------------------------*/
obj_t
caml_make_regular_2( tag, val0, val1 )
obj_t tag, val0, val1;
{
	obj_t vect, aux;

	vect = MAKE_OBJECT( VECTOR_SIZE + (2 * OBJ_SIZE), HEADER_VECTOR, aux );

	vect->vector_t.length = BINT( 2 );
	VECTOR_TAG_SET( BREF( vect ), tag );

	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 0 ), val0 );
	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 1 ), val1 );

	return BREF( vect );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    caml_make_regular_3 ...                                          */
/*---------------------------------------------------------------------*/
obj_t
caml_make_regular_3( tag, val0, val1, val2 )
obj_t tag, val0, val1, val2;
{
	obj_t vect, aux;

	vect = MAKE_OBJECT( VECTOR_SIZE + (3 * OBJ_SIZE), HEADER_VECTOR, aux );

	vect->vector_t.length = BINT( 3 );
	VECTOR_TAG_SET( BREF( vect ), tag );

	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 0 ), val0 );
	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 1 ), val1 );
	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 2 ), val2 );

	return BREF( vect );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    caml_make_regular_4 ...                                          */
/*---------------------------------------------------------------------*/
obj_t
caml_make_regular_4( tag, val0, val1, val2, val3 )
obj_t tag, val0, val1, val2, val3;
{
	obj_t vect, aux;

	vect = MAKE_OBJECT( VECTOR_SIZE + (4 * OBJ_SIZE), HEADER_VECTOR, aux );

	vect->vector_t.length = BINT( 4 );
	VECTOR_TAG_SET( BREF( vect ), tag );

	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 0 ), val0 );
	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 1 ), val1 );
	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 2 ), val2 );
	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 3 ), val3 );

	return BREF( vect );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    caml_make_extensible_1 ...                                       */
/*---------------------------------------------------------------------*/
obj_t
caml_make_extensible_1( tag, val0 )
obj_t tag, val0;
{
	obj_t vect, aux;
	
	vect = MAKE_OBJECT( VECTOR_SIZE + ( 2 * OBJ_SIZE ),
							  HEADER_VECTOR,
							  aux );

	vect->vector_t.length = BINT( 2 );
	VECTOR_TAG_SET( BREF( vect ), CAML_EXTENSIBLE_TAG );

	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 0 ), val0 );

	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 1 ), tag );

	return BREF( vect );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    caml_make_extensible_2 ...                                       */
/*---------------------------------------------------------------------*/
obj_t
caml_make_extensible_2( tag, val0, val1 )
obj_t tag, val0, val1;
{
	obj_t vect, aux;
	
	vect = MAKE_OBJECT( VECTOR_SIZE + ( 3 * OBJ_SIZE ),
							  HEADER_VECTOR,
							  aux );

	vect->vector_t.length = BINT( 3 );
	VECTOR_TAG_SET( BREF( vect ), CAML_EXTENSIBLE_TAG );

	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 0 ), val0 );
	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 1 ), val1 );

	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 2 ), tag );

	return BREF( vect );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    caml_make_extensible_3 ...                                       */
/*---------------------------------------------------------------------*/
obj_t
caml_make_extensible_3( tag, val0, val1, val2 )
obj_t tag, val0, val1, val2;
{
	obj_t vect, aux;
	
	vect = MAKE_OBJECT( VECTOR_SIZE + ( 4 * OBJ_SIZE ),
							  HEADER_VECTOR,
							  aux );

	vect->vector_t.length = BINT( 3 );
	VECTOR_TAG_SET( BREF( vect ), CAML_EXTENSIBLE_TAG );

	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 0 ), val0 );
	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 1 ), val1 );
	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 2 ), val2 );

	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 3 ), tag );
	
	return BREF( vect );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    caml_make_extensible_4 ...                                       */
/*---------------------------------------------------------------------*/
obj_t
caml_make_extensible_4( tag, val0, val1, val2, val3 )
obj_t tag, val0, val1, val2, val3;
{
	obj_t vect, aux;
	
	vect = MAKE_OBJECT( VECTOR_SIZE + ( 5 * OBJ_SIZE ),
							  HEADER_VECTOR,
							  aux );

	vect->vector_t.length = BINT( 5 );
	VECTOR_TAG_SET( BREF( vect ), CAML_EXTENSIBLE_TAG );

	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 0 ), val0 );
	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 1 ), val1 );
	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 2 ), val2 );
	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 3 ), val3 );
	
	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( 4 ), tag );
	
	return BREF( vect );
}


/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    caml_make_extensible ...                                         */
/*    -------------------------------------------------------------    */
/*    L'allocateur generale de constructeurs extensibles               */
/*---------------------------------------------------------------------*/
obj_t
caml_make_extensible( va_alist )
va_dcl
{
	va_list argl;
	obj_t   tag;
	int     nb;
   obj_t   vect, aux;
	int     i;

	va_start( argl );

	tag    = va_arg( argl, obj_t );
	nb     = CINT( va_arg( argl, obj_t ) );
	
	/* Cette allocation doit etre la meme que celle faite dans le   */
	/* fichier Clib/vector.c de la librairie.                       */
	vect = MAKE_OBJECT( VECTOR_SIZE + ( (nb + 1) * OBJ_SIZE ),
							  HEADER_VECTOR,
							  aux );

	vect->vector_t.length = BINT( nb + 1 );
	VECTOR_TAG_SET( BREF( vect ), CAML_EXTENSIBLE_TAG );

	/* on initialise les differents champs du vecteurs              */
	for( i = 0; i < nb; i++ )
	   CAML_CONSTR_SET_FIELD( BREF( vect ),
									  BINT( i ),
									  va_arg( argl, obj_t ) );

	CAML_CONSTR_SET_FIELD( BREF( vect ), BINT( nb ), tag );

	va_end( argl );
	
	return BREF( vect );
} 



