/*=====================================================================*/
/*    serrano/ml/camloo/runtime0.0/CAMLClib/hash.c ...                 */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec 21 19:10:39 1993                          */
/*    Last change :  Tue Jan 18 10:03:30 1994 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Ma version du hashage, probablement pas tres bonne mais je m'en  */
/*    moque totalement.                                                */
/*=====================================================================*/
#include "mlvalues.h"
#include "memory.h"
#include "str.h"

static unsigned long hash_accu;
static long hash_univ_limit, hash_univ_count;

static void hash_aux();

value hash_univ_param(count, limit, obj) /* ML */
     value obj, count, limit;
{
  hash_univ_limit = Long_val(limit);
  hash_univ_count = Long_val(count);
  hash_accu = 0;
  hash_aux(obj);
  return Val_long(hash_accu & Max_long);
}
 
#define Alpha 65599
#define Beta 19
#define Combine(new)  (hash_accu = hash_accu * Alpha + (new))
#define Combine_small(new) (hash_accu = hash_accu * Beta + (new))

static void hash_aux(obj)
     value obj;
{
  unsigned char * p;
  mlsize_t i;

  hash_univ_limit--;
  if (hash_univ_count < 0 || hash_univ_limit < 0) return;

  if( STRINGP( obj ) )
  {
	  hash_univ_count--;
	  
     i = CINT( STRING_LENGTH( obj ) );
	   
     for( p = &Byte_u( obj, 0 ); i > 0; i--, p++ )
	     Combine_small( *p );
  }
  else
     if( REALP( obj ) )
	  {
		  hash_univ_count--;
		  Combine( REAL_TO_DOUBLE( obj ) );
	  }
     else
	  {
		  if( CNSTP( obj ) )
		  {
		     hash_univ_count--;
			  Combine( (int)obj );
		  }
		  else
		  {
			  if( CHARP( obj ) )
			  {
				  hash_univ_count--;
				  Combine( CCHAR( obj ) );
			  }
			  else
			  if( Is_block( obj ) )
			  {
				  i = Wosize_val( obj );
				  
				  while( i != 0 )
				  {
					  i--;
					  hash_aux( Field( obj, i ) );
				  }
			  }
			  else
			  {
				  hash_univ_count--;
				  Combine((long) obj);
			  }
		  }
	  }
}
