;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;; Le module                                                                 
(module
  __caml_vect
  (foreign (include #"caml-bigloo.h"))
  (import)
  (export
    (make_vect_185@vect x1)
    (2-70-make_vect_185@vect x1 x2)
    (make_matrix_88@vect x1)
    (3-223-make_matrix_88@vect x1 x2 x3)
    (vect_item_124@vect x1)
    (2-194-vect_item_124@vect x1 x2)
    (vect_assign_169@vect x1)
    (3-189-vect_assign_169@vect x1 x2 x3)
    (fill_vect_126@vect x1)
    (4-32-fill_vect_126@vect x1 x2 x3 x4)
    (blit_vect_203@vect x1)
    (5-65-blit_vect_203@vect x1 x2 x3 x4 x5)
    concat_vect_32@vect
    (sub_vect_160@vect x1)
    (3-41-sub_vect_160@vect x1 x2 x3)
    copy_vect_177@vect
    list_of_vect_3@vect
    vect_of_list_150@vect
    do_vect_153@vect
    map_vect_149@vect
    map_vect_list_65@vect))
;; L'initialisation du module                                                
(init_camloo!)
;; Les variables globales                                                    
;; Les expressions globales                                                  
(begin
  (define make_vect_185@vect
    (lambda (x1)
      (lambda (x2) (2-70-make_vect_185@vect x1 x2))))
 (define 2-70-make_vect_185@vect
    (lambda (x1 x2)
      (if (or (<fx x1 0) (>=fx x1 4194304))
        (invalid_arg_209@exc #"make_vect")
        (make-vector x1 x2))))
)
(begin
  (define make_matrix_88@vect
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (3-223-make_matrix_88@vect x1 x2 x3)))))
 (define 3-223-make_matrix_88@vect
    (lambda (x1 x2 x3)
      (if (or (<fx x1 0)
              (or (>=fx x1 4194304)
                  (or (<fx x2 0) (>=fx x2 4194304))))
        (invalid_arg_209@exc #"make_matrix")
        (((make_matrix_88@fvect x1) x2) x3))))
)
(begin
  (define vect_item_124@vect
    (lambda (x1)
      (lambda (x2) (2-194-vect_item_124@vect x1 x2))))
 (define 2-194-vect_item_124@vect
    (lambda (x1 x2)
      (if (or (<fx x2 0)
              (>=fx x2
                    (let ((:-d.1000 x1))
                      (if :-d.1000 (vector-length :-d.1000) 0))))
        (invalid_arg_209@exc #"vect_item")
        (vector-ref x1 x2))))
)
(begin
  (define vect_assign_169@vect
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (3-189-vect_assign_169@vect x1 x2 x3)))))
 (define 3-189-vect_assign_169@vect
    (lambda (x1 x2 x3)
      (if (or (<fx x2 0)
              (>=fx x2
                    (let ((:-d.1001 x1))
                      (if :-d.1001 (vector-length :-d.1001) 0))))
        (invalid_arg_209@exc #"vect_assign")
        (vector-set! x1 x2 x3))))
)
(begin
  (define fill_vect_126@vect
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (lambda (x4)
            (4-32-fill_vect_126@vect x1 x2 x3 x4))))))
 (define 4-32-fill_vect_126@vect
    (lambda (x1 x2 x3 x4)
      (if (or (<fx x2 0)
              (or (<fx x3 0)
                  (>fx (+fx x2 x3)
                       (let ((:-d.1002 x1))
                         (if :-d.1002 (vector-length :-d.1002) 0)))))
        (invalid_arg_209@exc #"fill_vect")
        ((((fill_vect_126@fvect x1) x2) x3) x4))))
)
(begin
  (define blit_vect_203@vect
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (lambda (x4)
            (lambda (x5)
              (5-65-blit_vect_203@vect x1 x2 x3 x4 x5)))))))
 (define 5-65-blit_vect_203@vect
    (lambda (x1 x2 x3 x4 x5)
      (if (or (<fx x2 0)
              (or (>fx (+fx x2 x5)
                       (let ((:-d.1003 x1))
                         (if :-d.1003 (vector-length :-d.1003) 0)))
                  (or (<fx x4 0)
                      (or (>fx (+fx x4 x5)
                               (let ((:-d.1004 x3))
                                 (if :-d.1004 (vector-length :-d.1004) 0)))
                          (<fx x5 0)))))
        (invalid_arg_209@exc #"blit_vect")
        (((((blit_vect_203@fvect x1) x2) x3) x4) x5))))
)
(define concat_vect_32@vect concat_vect_32@fvect)
(begin
  (define sub_vect_160@vect
    (lambda (x1)
      (lambda (x2)
        (lambda (x3) (3-41-sub_vect_160@vect x1 x2 x3)))))
 (define 3-41-sub_vect_160@vect
    (lambda (x1 x2 x3)
      (if (or (<fx x2 0)
              (or (<fx x3 0)
                  (>fx (+fx x2 x3)
                       (let ((:-d.1005 x1))
                         (if :-d.1005 (vector-length :-d.1005) 0)))))
        (invalid_arg_209@exc #"sub_vect")
        (((sub_vect_160@fvect x1) x2) x3))))
)
(define copy_vect_177@vect copy_vect_177@fvect)
(begin
  (define list_of_vect_3@vect list_of_vect_3@fvect)
  (define vect_of_list_150@vect
    vect_of_list_150@fvect)
)
(begin
  (define do_vect_153@vect do_vect_153@fvect)
  (begin
    (define map_vect_149@vect map_vect_149@fvect)
    (define map_vect_list_65@vect
      map_vect_list_65@fvect)
))
