;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;; Le module                                                                 
(module
  __caml_fvect
  (foreign (include #"caml-bigloo.h"))
  (import)
  (export
    (make_matrix_88@fvect x1)
    (3-21-make_matrix_88@fvect x1 x2 x3)
    (blit_vect_203@fvect x1)
    (5-48-blit_vect_203@fvect x1 x2 x3 x4 x5)
    (fill_vect_126@fvect x1)
    (4-206-fill_vect_126@fvect x1 x2 x3 x4)
    (copy_vect_177@fvect x1)
    (concat_vect_32@fvect x1)
    (2-164-concat_vect_32@fvect x1 x2)
    (sub_vect_160@fvect x1)
    (3-89-sub_vect_160@fvect x1 x2 x3)
    (list_of_vect_3@fvect x1)
    (vect_of_list_150@fvect x1)
    (do_vect_153@fvect x1)
    (2-211-do_vect_153@fvect x1 x2)
    (map_vect_149@fvect x1)
    (2-233-map_vect_149@fvect x1 x2)
    (map_vect_list_65@fvect x1)
    (2-221-map_vect_list_65@fvect x1 x2)))
;; L'initialisation du module                                                
(init_camloo!)
;; Les variables globales                                                    
;; Les expressions globales                                                  
(begin
  (define make_matrix_88@fvect
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (3-21-make_matrix_88@fvect x1 x2 x3)))))
 (define 3-21-make_matrix_88@fvect
    (lambda (x1 x2 x3)
      (let ((x4 (make-vector x1 (caml-make-tag 0 0))))
        (begin
          (let ((stop1001 (-fx x1 1)))
            (let for1000 ((i5 0))
              (if (<=fx i5 stop1001)
                (begin
                  (vector-set! x4 i5 (make-vector x2 x3))
                  (for1000 (+fx i5 1)))
                (unspecified))))
          x4))))
)
(begin
  (define blit_vect_203@fvect
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (lambda (x4)
            (lambda (x5)
              (5-48-blit_vect_203@fvect x1 x2 x3 x4 x5)))))))
 (define 5-48-blit_vect_203@fvect
    (lambda (x1 x2 x3 x4 x5)
      (if (<fx x2 x4)
        (let ((stop1003 0))
          (let for1002 ((i6 (-fx x5 1)))
            (if (>=fx i6 stop1003)
              (begin
                (vector-set!
                  x3
                  (+fx x4 i6)
                  (vector-ref x1 (+fx x2 i6)))
                (for1002 (-fx i6 1)))
              (unspecified))))
        (let ((stop1005 (-fx x5 1)))
          (let for1004 ((i6 0))
            (if (<=fx i6 stop1005)
              (begin
                (vector-set!
                  x3
                  (+fx x4 i6)
                  (vector-ref x1 (+fx x2 i6)))
                (for1004 (+fx i6 1)))
              (unspecified)))))))
)
(begin
  (define fill_vect_126@fvect
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (lambda (x4)
            (4-206-fill_vect_126@fvect x1 x2 x3 x4))))))
 (define 4-206-fill_vect_126@fvect
    (lambda (x1 x2 x3 x4)
      (let ((stop1007 (-fx (+fx x2 x3) 1)))
        (let for1006 ((i5 x2))
          (if (<=fx i5 stop1007)
            (begin
              (vector-set! x1 i5 x4)
              (for1006 (+fx i5 1)))
            (unspecified))))))
)
(define copy_vect_177@fvect
  (lambda (x1)
    (if (eq? (let ((:-d.1008 x1))
               (if :-d.1008 (vector-length :-d.1008) 0))
             0)
      x1
      (let ((x2 (make-vector
                  (let ((:-d.1009 x1))
                    (if :-d.1009 (vector-length :-d.1009) 0))
                  (vector-ref x1 0))))
        (begin
          (((((blit_vect_203@fvect x1) 1) x2) 1)
           (-fx (let ((:-d.1010 x1))
                  (if :-d.1010 (vector-length :-d.1010) 0))
                1))
          x2)))))

(begin
  (define concat_vect_32@fvect
    (lambda (x1)
      (lambda (x2) (2-164-concat_vect_32@fvect x1 x2))))
 (define 2-164-concat_vect_32@fvect
    (lambda (x1 x2)
      (if (eq? (let ((:-d.1011 x1))
                 (if :-d.1011 (vector-length :-d.1011) 0))
               0)
        (copy_vect_177@fvect x2)
        (if (eq? (let ((:-d.1012 x2))
                   (if :-d.1012 (vector-length :-d.1012) 0))
                 0)
          (copy_vect_177@fvect x1)
          (let ((x3 (make-vector
                      (+fx (let ((:-d.1014 x1))
                             (if :-d.1014 (vector-length :-d.1014) 0))
                           (let ((:-d.1013 x2))
                             (if :-d.1013 (vector-length :-d.1013) 0)))
                      (vector-ref x1 0))))
            (begin
              (((((blit_vect_203@fvect x1) 1) x3) 1)
               (-fx (let ((:-d.1015 x1))
                      (if :-d.1015 (vector-length :-d.1015) 0))
                    1))
              (begin
                (((((blit_vect_203@fvect x2) 0) x3)
                  (let ((:-d.1016 x1))
                    (if :-d.1016 (vector-length :-d.1016) 0)))
                 (let ((:-d.1017 x2))
                   (if :-d.1017 (vector-length :-d.1017) 0)))
                x3)))))))
)
(begin
  (define sub_vect_160@fvect
    (lambda (x1)
      (lambda (x2)
        (lambda (x3) (3-89-sub_vect_160@fvect x1 x2 x3)))))
 (define 3-89-sub_vect_160@fvect
    (lambda (x1 x2 x3)
      (if (eq? x3 0)
        (caml-make-tag 0 0)
        (let ((x4 (make-vector x3 (vector-ref x1 x2))))
          (begin
            (let ((stop1019 (-fx x3 1)))
              (let for1018 ((i5 1))
                (if (<=fx i5 stop1019)
                  (begin
                    (vector-set! x4 i5 (vector-ref x1 (+fx x2 i5)))
                    (for1018 (+fx i5 1)))
                  (unspecified))))
            x4)))))
)
(define list_of_vect_3@fvect
  (lambda (x1)
    (letrec ((x2 (lambda (x3)
                   (if (>=fx x3
                             (let ((:-d.1020 x1))
                               (if :-d.1020 (vector-length :-d.1020) 0)))
                     '()
                     (cons (vector-ref x1 x3) (x2 (+fx x3 1)))))))
      (x2 0))))

(define vect_of_list_150@fvect
  (lambda (x1)
    (if (null? x1)
      (caml-make-tag 0 0)
      (let ((x2 (make-vector (list_length_112@list x1) (car x1))))
        (letrec ((x3 (lambda (x4)
                       (lambda (x5)
                         (if (null? x5)
                           (caml-make-tag 0 1)
                           (begin
                             (vector-set! x2 x4 (car x5))
                             ((x3 (+fx x4 1)) (cdr x5))))))))
          (begin ((x3 1) (cdr x1)) x2))))))

(begin
  (define do_vect_153@fvect
    (lambda (x1)
      (lambda (x2) (2-211-do_vect_153@fvect x1 x2))))
 (define 2-211-do_vect_153@fvect
    (lambda (x1 x2)
      (let ((stop1022
              (-fx (let ((:-d.1023 x2))
                     (if :-d.1023 (vector-length :-d.1023) 0))
                   1)))
        (let for1021 ((i3 0))
          (if (<=fx i3 stop1022)
            (begin
              (x1 (vector-ref x2 i3))
              (for1021 (+fx i3 1)))
            (unspecified))))))
)
(begin
  (define map_vect_149@fvect
    (lambda (x1)
      (lambda (x2) (2-233-map_vect_149@fvect x1 x2))))
 (define 2-233-map_vect_149@fvect
    (lambda (x1 x2)
      (if (eq? (let ((:-d.1024 x2))
                 (if :-d.1024 (vector-length :-d.1024) 0))
               0)
        (caml-make-tag 0 0)
        (let ((x3 (make-vector
                    (let ((:-d.1025 x2))
                      (if :-d.1025 (vector-length :-d.1025) 0))
                    (x1 (vector-ref x2 0)))))
          (begin
            (let ((stop1027
                    (-fx (let ((:-d.1028 x2))
                           (if :-d.1028 (vector-length :-d.1028) 0))
                         1)))
              (let for1026 ((i4 1))
                (if (<=fx i4 stop1027)
                  (begin
                    (vector-set! x3 i4 (x1 (vector-ref x2 i4)))
                    (for1026 (+fx i4 1)))
                  (unspecified))))
            x3)))))
)
(begin
  (define map_vect_list_65@fvect
    (lambda (x1)
      (lambda (x2)
        (2-221-map_vect_list_65@fvect x1 x2))))
 (define 2-221-map_vect_list_65@fvect
    (lambda (x1 x2)
      (letrec ((x3 (lambda (x4)
                     (if (>=fx x4
                               (let ((:-d.1029 x2))
                                 (if :-d.1029 (vector-length :-d.1029) 0)))
                       '()
                       (cons (x1 (vector-ref x2 x4)) (x3 (+fx x4 1)))))))
        (x3 0))))
)
