/*=====================================================================*/
/*    serrano/ml/camloo/runtime0.2/Include/value-bigloo.h ...          */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Sun Dec 12 14:34:48 1993                          */
/*    Last change :  Fri Jun  3 10:31:51 1994 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Le pendant du fichier `mlvalue.h' de la distribution de caml-    */
/*    light                                                            */
/*=====================================================================*/
#ifndef CAML_VALUE_BIGLOO_H
#define CAML_VALUE_BIGLOO_H

/*---------------------------------------------------------------------*/
/*    Les types                                                        */
/*---------------------------------------------------------------------*/
typedef obj_t value;
typedef unsigned int mlsize_t;
typedef unsigned char *code_t;

/*---------------------------------------------------------------------*/
/*    Les constructeurs                                                */
/*---------------------------------------------------------------------*/
#define Tag_val( i )                                      \
   ( CAML_CONSTANT_CONSTRP( i ) ?                         \
      (int)(CCNST( CAML_CONSTANT_CONSTR_TAG( i ) ) - 1) : \
	   ( CAML_CONS_CONSTRP( i ) ?                          \
		  CINT( CAML_CONS_TAG ) :                           \
		  ( NULLP( i ) ?                                    \
			 0 :                                             \
          (int)(CINT( CAML_REGULAR_CONSTR_TAG( i ) ) - 1) ) ) )


/*---------------------------------------------------------------------*/
/*    Cette macro est difficile a ecrire portable. Je fais donc        */
/*    deux cas. Soit j'utilise gcc soit je ne l'utilise pas ...        */
/*---------------------------------------------------------------------*/
#if defined( __GNUC__ )
#   define Field( x, i )                                     \
      ( CAML_CONS_CONSTRP( x ) ?                             \
	     ( i ? CDR( x ) : CAR( x ) ) :                        \
	     CAML_CONSTR_GET_FIELD( x, BINT( i ) ) )
#else
#   define Field( x, i )                                     \
      (*( CAML_CONS_CONSTRP( x ) ?                           \
	     ( i ? &CDR( x ) : &CAR( x ) ) :                      \
	     &CAML_CONSTR_GET_FIELD( x, BINT( i ) ) ))
#endif

#define Wosize_val( i ) CINT( CAML_CONSTR_LENGTH( i ) )

/*---------------------------------------------------------------------*/
/*    Le trippotage des entiers                                        */
/*---------------------------------------------------------------------*/
#define Long_val( i ) CINT( i )
#define Val_long( i ) BINT( i )
#define Int_val( x ) ((int) Long_val( x ))
#define Val_int( x ) Val_long( x )

#define Max_long ((1L << (8 * sizeof(value) - 2)) - 1)

/*---------------------------------------------------------------------*/
/*    Des floats                                                       */
/*---------------------------------------------------------------------*/
#define copy_double(x ) DOUBLE_TO_REAL( x )

/*---------------------------------------------------------------------*/
/*    Les tags                                                         */
/*---------------------------------------------------------------------*/
typedef unsigned int tag_t;

/*---------------------------------------------------------------------*/
/*    Les manipulations des floats                                     */
/*---------------------------------------------------------------------*/
#define Double_val( x ) REAL_TO_DOUBLE( x )

/*---------------------------------------------------------------------*/
/*    Le trippotage des chars                                          */
/*---------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
/*    Le trippotage des booleens                                       */
/*---------------------------------------------------------------------*/
#define Val_bool( x ) CBOOL_TO_BBOOL( x )
#define Bool_val( x ) BBOOL_TO_CBOOL( x )
#define Val_false     BFALSE
#define Val_true      BTRUE
#define Val_unit      Atom( 0 )

/*---------------------------------------------------------------------*/
/*    Le trippotage des strings                                        */
/*---------------------------------------------------------------------*/
#define String_val( ml )        BSTRING_TO_CSTRING( ml )
#define copy_string( c_string ) c_string_to_string( c_string )
#define string_length( s )      CINT( STRING_LENGTH( s ) )

#define Byte( x, i )    BSTRING_TO_CSTRING( x )[ i ]
#define Byte_u( x, i )  ((unsigned char *)BSTRING_TO_CSTRING( x ))[ i ]

/*---------------------------------------------------------------------*/
/*    Les atoms                                                        */
/*---------------------------------------------------------------------*/
#define Atom( x ) BCNST( x + 1 )

/*---------------------------------------------------------------------*/
/*    Les fonctions de memory.c                                        */
/*---------------------------------------------------------------------*/
#define stat_alloc  (char *)malloc
#define stat_free   free
#define stat_resize realloc

/*---------------------------------------------------------------------*/
/*    Les fonctions de alloc.c                                         */
/*---------------------------------------------------------------------*/
extern obj_t make_string();
extern obj_t make_vector();
extern obj_t caml_allocate_regular();

#define alloc_string( len )     make_string( BINT( len ), BCHAR( ' ' ) )
#define alloc_tuple( csize )    caml_allocate_regular( BINT( csize ), 0L )
#define alloc( csize, ctag )    \
   caml_allocate_regular( BINT( csize ), CAML_MAKE_TAG( ctag, 0 ) )

extern value copy_string_array();

/*---------------------------------------------------------------------*/
/*    Les macros du GC                                                 */
/*---------------------------------------------------------------------*/
#define Push_roots( name, size ) value name [(size) + 2];
#define Pop_roots()

#define leave_blocking_section()
#define enter_blocking_section()

#define Is_in_heap( x ) ( 1 )
#define Is_young( x )   ( 0 )

/*---------------------------------------------------------------------*/
/*    Les differents tags                                              */
/*---------------------------------------------------------------------*/
#define Num_tags     BINT( 1 << 8 )
#define No_scan_tag  BINT( (CINT( Num_tags ) - 4) )
#define Closure_tag  BINT( (CINT( No_scan_tag ) - 1) )
#define String_tag   BINT( (CINT( No_scan_tag ) + 1) )
#define Double_tag   BINT( (CINT( No_scan_tag ) + 2) )
#define Scan_tag     BINT( (CINT( No_scan_tag ) - 2) )
#define Abstract_tag No_scan_tag
#define Final_tag    Scan_tag

/*---------------------------------------------------------------------*/
/*    Les fonctions                                                    */
/*---------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
/*    Les choses des parseurs                                          */
/*---------------------------------------------------------------------*/
#define callback( fun, arg ) PROCEDURE_ENTRY( fun )( fun, arg, BEOA )
#endif CAML_VALUE_BIGLOO_H

