;*=====================================================================*/
;*    serrano/ml/camloo/distribution/caml.tpl ...                      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 27 11:19:13 1993                          */
;*    Last change :  Wed May  4 18:42:07 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Le descripteur d'extension du package `camloo'                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Les variables de controle                                        */
;*---------------------------------------------------------------------*/
(define *camloo-src*     #f)
(define *camloo-version* "0.2")
(define *camloo-dir*     "/net/cornas/icsla2/serrano/ml/camloo")
(define *caml-lib-dir*   (string-append
			  *camloo-dir* 
			  "/lib/"
			  *camloo-version* "/"))
(define *camlc-opt*      '(""))
(define *camloo-opt*     '(""))
(define *bigloo-G-opt*   '("-g" "-cg" "-v"))
(define *bigloo-opt*     '("-unsafe" "-farithmetic"))
(define *bigloo-O-opt*   '("-farithmetic" "-unsafe" "-O3"))
(define *camloo-pass*    'ml+scm)
(define *camlc-stdlib*   (string-append *camloo-dir*
					"/runtime"
					*camloo-version*
					"/Mlib"))
(define *camlc*          (string-append *camloo-dir* "/bin/camloo1"))
(define *camloo*         (string-append *camloo-dir* "/bin/camloo2"))
(define *pp*             #f)

;*---------------------------------------------------------------------*/
;*    Les variables de Bigloo                                          */
;*---------------------------------------------------------------------*/
(set! *bigloo-name*     (string-append *bigloo-name* "  --  Camloo (v"
				       *camloo-version* ")"))
(set! *bigloo-user-lib* (cons "-lbigloo_caml_u" *bigloo-user-lib*))
(set! *cc-options*      (string-append *cc-options*
				       " -I" *caml-lib-dir*
				       " -L" *caml-lib-dir*))
(set! *heap-names*      (cons (string-append *caml-lib-dir* 
					     "caml-bigloo.heap")
			      *heap-names*))
(set! *hello?* #f)

;*---------------------------------------------------------------------*/
;*    camloo-help ...                                                  */
;*---------------------------------------------------------------------*/
(define (camloo-help)
   (print "usage: bigloo [bigloo-opt] [src_name.ml]")
   (print "   or: bigloo [bigloo-opt] [src_name] -extend caml [camloo-opt]")
   (newline)
   (print "   -only-ml              -- Stop after the ML compilation")
   (print "   -only-lam             -- Stop after the `.lam' production")
   (print "   -after-ml             -- Begin after the ML compilation")
   (print "   -O                    -- optimize Bigloo and Camlc")
   (print "   ...                   -- camlc options")
   (newline)
   (newline))

;*---------------------------------------------------------------------*/
;*    sys-call ...                                                     */
;*---------------------------------------------------------------------*/
(define (sys-call cmd)
   (let ((res (system cmd)))
      (if (=fx res 0)
	  res
	  (exit -1))))

;*---------------------------------------------------------------------*/
;*    camloo-parse-args! ...                                           */
;*---------------------------------------------------------------------*/
(define (camloo-parse-args! _args)
   (let loop ((args (cons *src* _args)))
      (cond
	 ((null? args)
	  (if *debug*
	      (begin
		 (set! *strip* #f)
		 (set! *unsafe-arity*  #f)
		 (set! *unsafe-type*   #f)
		 (set! *unsafe-struct* #f)
		 (set! *unsafe-range*  #f)
		 (set! *bigloo-opt* *bigloo-G-opt*)))
	  (if *call/cc?*
	      (begin
		 (set! *bigloo-opt* (cons "-lcallcc_u" (bigloo-opt*)))
		 (set! *heap-names* (cons (string-append *caml-lib-dir* "/"
							 "caml-callcc.heap")
					  *heap-names*))))
	  (if (and *unsafe-range* *unsafe-arity*)
	      (set! *camlc-opt* (cons "-O fast" *camlc-opt*)))
	  (if *lib-mode*
	      (set! *camlc-opt* (cons "-mklib" *camlc-opt*)))
	  (if (not *verbose*)
	      (set! *bigloo-opt* (cons "-s" *bigloo-opt*)))
	  (if *camloo-src*
	      (begin
		 (set! *src* #f)
		 'done)
	      (begin
		 (set! *src* #f)
		 (set! *camloo-pass* 'link)
		 'done)))
	 ((not (car args))
	  (loop (cdr args)))
	 ((string=? (car args) "-help")
	  (camloo-help)
	  (help))
	 ((string=? (car args) "-only-ml")
	  (set! *camloo-pass* 'ml)
	  (loop (cdr args)))
	 ((string=? (car args) "-only-lam")
	  (set! *camloo-pass* 'ml--)
	  (loop (cdr args)))
	 ((string=? (car args) "-after-ml")
	  (set! *camloo-pass* 'scm)
	  (loop (cdr args)))
	 ((string=? (car args) "-O2")
	  (set! *bigloo-opt* *bigloo-O-opt*)
	  (loop (cdr args)))
	 ((string=? (car args) "-stdlib")
	  (set! *camlc-stdlib* (cadr args))
	  (loop (cdr args)))
	 (else
	  (let ((s (suffix (car args))))
	     (cond
		((string=? s "ml")
		 (set! *src* #t)
		 (set! *camloo-pass* 'ml+scm)
		 (set! *camloo-src* (car args)))
		((string=? s "mli")
		 (set! *src* #t)
		 (set! *camloo-pass* 'mli)
		 (set! *camloo-src* (car args)))
		((string=? s "scm")
		 (set! *src* #t)
		 (set! *camloo-pass* 'scm)
		 (set! *camloo-src* (car args)))
		(else
		 (set! *camlc-opt* (cons (car args) *camlc-opt*))))
	     (loop (cdr args)))))))

;*---------------------------------------------------------------------*/
;*    camloo-compile ...                                               */
;*---------------------------------------------------------------------*/
(define (camloo-compile)
   (if (eq? *camloo-pass* 'link)
       *bigloo-opt*
       (let* ((module      (prefix (basename *camloo-src*)))
	      (dest        (if (and (string? *dest*)
				    (string=? (suffix *dest*) "o"))
			       *dest*
			       (string-append (prefix *camloo-src*) ".o")))
	      (camlc-dest  (string-append "/tmp/" module ".lam"))
	      (camloo-dest (string-append (prefix dest) ".scm")))
	  (if (not *silent*)
	      (begin
		 (print *camloo-src* #\:)
		 (if *verbose*
		     (print "   . Camloo"))))
	  (case *camloo-pass*
	     ((scm)
	      (cons camloo-dest *bigloo-opt*))
	     ((mli)
	      (let ((cmd (string-append
			  *camlc* " "
			  (let loop ((opt (cons "-dump"
						*camlc-opt*))
				     (s  ""))
			     (if (null? opt)
				 (if (not (string=? *camlc* "camlc"))
				     (string-append "-stdlib "
						    *camlc-stdlib*
						    " "
						    s)
				     s)
				 (loop (cdr opt)
				       (string-append (car opt)
						      " "
						      s))))
			  " " *camloo-src*)))
		 (exit (sys-call cmd))))
	     (else
	      (let ((cmd0 (string-append
			   *camlc* " "
			   (let loop ((opt (cons "-dump"
						 *camlc-opt*))
				      (s   ""))
			      (if (null? opt)
				  (if (not (string=? *camlc* "camlc"))
				      (string-append "-stdlib "
						     *camlc-stdlib*
						     " "
						     s)
				      s)
				  (loop (cdr opt)
					(string-append (car opt)
						       " "
						       s))))
			   *camloo-src*))
		    (cmd1 (string-append "mv " (prefix *camloo-src*) ".lam "
					 camlc-dest))
		    (cmd2 (string-append *camloo* " " camlc-dest
					 " -m " module " "
					 (if (> *optim* 1)
					     " -O "
					     "")
					 (if (string? *access-file*)
					     (string-append " -afile "
							    *access-file*)
					     "")
					 (let loop ((opt *camloo-opt*)
						    (s   ""))
					    (if (null? opt)
						s
						(loop (cdr opt)
						      (string-append (car opt)
								     " "
								     s))))
					 "> " camloo-dest ".aux"))
		    (cmd3 (if *pp*
			      (string-append "pp -lower "
					     camloo-dest ".aux -o "
					     camloo-dest)
			      (string-append "mv "
					     camloo-dest ".aux "
					     camloo-dest))))
		 (sys-call cmd0)
		 (sys-call cmd0)
		 (if (not (eq? *camloo-pass* 'ml--))
		     (begin
			(sys-call cmd1)
			(sys-call cmd2)
			(sys-call cmd3)
			(delete-file camlc-dest)
			(delete-file (string-append camloo-dest ".aux"))
			(if (eq? *camloo-pass* 'ml+scm)
			    (cons camloo-dest *bigloo-opt*)
			    (exit 0)))
		     (exit 0))))))))

;*---------------------------------------------------------------------*/
;*    caml-constant-constr-tag ...                                     */
;*---------------------------------------------------------------------*/
(define-expander caml-constant-constr-tag
   (lambda (x e)
      (let ((obj (e (cadr x) e)))
	 (if *unsafe-type*
	     `(caml-constant-constr-tag ,obj)
	     (let ((nobj (gensym)))
		`(let ((,nobj ,obj))
		    (if (caml-constant-constr? ,nobj)
			(caml-constant-constr-tag ,nobj)
			(error "caml-constant-constr-tag"
			       "Not a constant constructor"
			       ,nobj))))))))

;*---------------------------------------------------------------------*/
;*    caml-regular-constr-tag ...                                      */
;*---------------------------------------------------------------------*/
(define-expander caml-regular-constr-tag
   (lambda (x e)
      (let ((obj (e (cadr x) e)))
	 (if *unsafe-type*
	     `(caml-regular-constr-tag ,obj)
	     (let ((nobj (gensym)))
		`(let ((,nobj ,obj))
		    (if (caml-regular-constr? ,nobj)
			(caml-regular-constr-tag ,nobj)
			(error "caml-regular-constr-tag"
			       "Not a regular constructor"
			       ,nobj))))))))

;*---------------------------------------------------------------------*/
;*    caml-extensible-constr-tag ...                                   */
;*---------------------------------------------------------------------*/
(define-expander caml-extensible-constr-tag
   (lambda (x e)
      (let ((obj (e (cadr x) e)))
	 (if *unsafe-type*
	     `(caml-extensible-constr-tag ,obj)
	     (let ((nobj (gensym)))
		`(let ((,nobj ,obj))
		    (if (caml-extensible-constr? ,nobj)
			(caml-extensible-constr-tag ,nobj)
			(error "caml-extensible-constr-tag"
			       "Not a extensible constructor"
			       ,nobj))))))))

;*---------------------------------------------------------------------*/
;*    caml-constr-get-field ...                                        */
;*---------------------------------------------------------------------*/
(define-expander caml-constr-get-field
   (lambda (x e)
      (let ((obj    (e (cadr x) e))
	    (offset (e (caddr x) e)))
	 (if (and *unsafe-type* *unsafe-range*)
	     `(caml-constr-get-field ,obj ,offset)
	     (let ((nobj (gensym)))
		`(let ((,nobj ,obj))
		    (if (if (caml-regular-constr? ,nobj)
			    #t
			    (caml-extensible-constr? ,nobj))
			(vector-ref ,nobj ,offset)
			(error "caml-const-get-field"
			       "Not a constructor"
			       ,nobj))))))))

;*---------------------------------------------------------------------*/
;*    caml-constr-set-field! ...                                       */
;*---------------------------------------------------------------------*/
(define-expander caml-constr-set-field!
   (lambda (x e)
      (let ((obj    (e (cadr x) e))
	    (offset (e (caddr x) e))
	    (value  (e (cadddr x) e)))
	 (if (and *unsafe-type* *unsafe-range*)
	     `(caml-constr-set-field! ,obj ,offset ,value)
	     (let ((nobj (gensym)))
		`(let ((,nobj ,obj))
		    (if (if (caml-regular-constr? ,nobj)
			    #t
			    (caml-extensible-constr? ,nobj))
			(vector-set! ,nobj ,offset ,value)
			(error "caml-const-set-field!"
			       "Not a constructor"
			       ,nobj))))))))

;*---------------------------------------------------------------------*/
;*    caml-make-regular ...                                            */
;*---------------------------------------------------------------------*/
(define-expander caml-make-regular
   (lambda (x e)
      (let ((tag    (cadr x))
	    (size   (caddr x))
	    (values (cdddr x)))
	 (case size
	    ((0) (e `(caml-make-tag ,tag) e))
	    ((1) (e `(caml-make-regular-1 ,tag ,(car values))
		    e))
	    ((2) (e `(caml-make-regular-2 ,tag
					  ,(car values)
					  ,(cadr values))
		    e))
	    ((3) (e `(caml-make-regular-3 ,tag
					  ,(car values)
					  ,(cadr values)
					  ,(caddr values))
		    e))
	    ((4) (e `(caml-make-regular-4 ,tag
					  ,(car values)
					  ,(cadr values)
					  ,(caddr values)
					  ,(cadddr values))
		    e))
	    (else
	     `(caml-make-regular ,(e tag e)
				 ,(e size e)
				 ,@(map (lambda (x)
					   (e x e))
					values)))))))
;*---------------------------------------------------------------------*/
;*    caml-make-extensible ...                                         */
;*---------------------------------------------------------------------*/
(define-expander caml-make-extensible
   (lambda (x e)
      (let ((tag    (cadr x))
	    (size   (caddr x))
	    (values (cdddr x)))
	 (case size
	    ((0) (e `(caml-make-tag ,tag) e))
	    ((1) (e `(caml-make-extensible-1 ,tag ,(car values))
		    e))
	    ((2) (e `(caml-make-extensible-2 ,tag
					     ,(car values)
					     ,(cadr values))
		    e))
	    ((3) (e `(caml-make-extensible-3 ,tag
					     ,(car values)
					     ,(cadr values)
					     ,(caddr values))
		    e))
	    ((4) (e `(caml-make-extensible-4 ,tag
					     ,(car values)
					     ,(cadr values)
					     ,(caddr values)
					     ,(cadddr values))
		    e))
	    (else
	     `(caml-make-extensible ,(e tag e)
				    ,(e size e)
				    ,@(map (lambda (x)
					      (e x e))
					   values)))))))

;*---------------------------------------------------------------------*/
;*    *extend-entry* ...                                               */
;*---------------------------------------------------------------------*/
(set! *extend-entry*
      (lambda (args)
	 (camloo-parse-args! args)
	 (camloo-compile)))

      

