;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/comptime0.2/Camloo/var.scm ...                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec  1 13:57:42 1993                          */
;*    Last change :  Wed May 25 09:04:00 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Le trippotage des variables                                      */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module var
   (include "Camloo/var.sch")
   (import  module)
   (foreign (int get-hash-number (string) "get_hash_number"))
   (export  (get-global     name  module)
	    (define-global  name  module)
	    (define-foreign cname arity)
	    (overwrite-global-definition! exp)
	    (get-all-global)
	    (get-all-foreign)))

;*---------------------------------------------------------------------*/
;*    *all-global* ...                                                 */
;*---------------------------------------------------------------------*/
(define *all-global* '())

;*---------------------------------------------------------------------*/
;*    get-all-global ...                                               */
;*---------------------------------------------------------------------*/
(define (get-all-global)
   *all-global*)

;*---------------------------------------------------------------------*/
;*    define-global ...                                                */
;*    -------------------------------------------------------------    */
;*    S'il existe deja une variable qui a le meme nom (et dont on      */
;*    a deja lu la definition) alors on renomme l'ancienne variable.   */
;*    -------------------------------------------------------------    */
;*    Il faut noter que les cas tres tricky ont deja ete traites par   */
;*    la fonction `overwrite-global-definition!' qui est invoquee      */
;*    quand on trouve des `sequence' au top-level (fonction llambda).  */
;*---------------------------------------------------------------------*/
(define (define-global name module)
   (let* ((name  (if (symbol? name)
		     name
		     (string->symbol (string-append
				      name
				      "_"
				      (integer->string
				       (get-hash-number name))))))
	  (fname (symbol-append name '@ (string->symbol module)))
	  (old   (getprop fname 'global)))
      (cond
	 ((not old)
	  ;; on a rien sous ce nom ...
	  (let ((new (create-global name module)))
	     (global-defined?-set! new #t)
	     new))
	 ((not (global-defined? old))
	  ;; on a deja une globale mais on n'a pas trouve sa definition ...
	  (global-defined?-set! old #t)
	  old)
	 (else
	  ;; on a deja une global definie, on fait une alpha conversion
	  (let ((new-name (gensym)))
	     (remprop! fname 'global)
	     (putprop! (symbol-append new-name '@ (string->symbol module))
		       'global old)
	     (global-name-set! old new-name)
	     (global-exported?-set! old #f))
	  ;; on cree une nouvelle variable
	  (let ((new (create-global name module)))
	     (global-defined?-set! new #t)
	     new)))))

;*---------------------------------------------------------------------*/
;*    get-global ...                                                   */
;*    -------------------------------------------------------------    */
;*    S'il existe deja une variable qui a le meme nom (et dont on      */
;*    a deja lu la definition) alors on renomme l'ancienne variable.   */
;*---------------------------------------------------------------------*/
(define (get-global name module)
   (let* ((name (if (symbol? name)
		    name
		    (string->symbol
		     (string-append name
				    "_"
				    (integer->string
				     (get-hash-number name))))))
	  (old  (getprop (symbol-append name '@ (string->symbol module))
			 'global)))
      (if old
	  old
	  (create-global name module))))
      
;*---------------------------------------------------------------------*/
;*    create-global ...                                                */
;*---------------------------------------------------------------------*/
(define (create-global name module)
   (let ((new     (make-global))
	 (smodule (string->symbol module)))
      (remember-module! module)
      (putprop! (symbol-append name '@ smodule) 'global new)
      (set! *all-global* (cons new *all-global*))
      (global-name-set!      new name)
      (global-module-set!    new smodule)
      (global-exported?-set! new #t)
      (global-function?-set! new #f)
      (global-defined?-set!  new #f)
      new))

;*---------------------------------------------------------------------*/
;*    *all-foreign* ...                                                */
;*---------------------------------------------------------------------*/
(define *all-foreign* '())

;*---------------------------------------------------------------------*/
;*    get-all-foreign ...                                              */
;*---------------------------------------------------------------------*/
(define (get-all-foreign)
   *all-foreign*)

;*---------------------------------------------------------------------*/
;*    remember-foreign! ...                                            */
;*---------------------------------------------------------------------*/
(define (remember-foreign! l)
   (set! *all-foreign* (cons l *all-foreign*)))

;*---------------------------------------------------------------------*/
;*    define-foreign ...                                               */
;*---------------------------------------------------------------------*/
(define (define-foreign cname arity)
   (let ((sname (string->symbol (string-upcase cname))))
      (if (getprop sname 'global)
	  (error "define-foreign" "Conflict in name for foreign" cname)
	  (let ((old (getprop sname 'foreign)))
	     (if old
		 (if (not (=fx old arity))
		     (error
		      "define-foreign"
		      "Foreign has already been declared with another arity"
		      cname)
		     sname)
		 (begin
		    (putprop! sname 'foreign arity)
		    (remember-foreign! (list cname sname arity))
		    sname))))))

;*---------------------------------------------------------------------*/
;*    overwrite-global-definition! ...                                 */
;*    -------------------------------------------------------------    */
;*    On est oblige de faire un traitement avant de compiler           */
;*    les corps des fonctions. Si non, le cas:                         */
;*                                                                     */
;*       let foo x = 9;;                                               */
;*                                                                     */
;*       let rec bar x = foo x                                         */
;*       and foo x = 8;;                                               */
;*                                                                     */
;*       print_int( bar 7 );;                                          */
;*       print_newline();;                                             */
;*                                                                     */
;*    est a tous les coups mal traite !                                */
;*---------------------------------------------------------------------*/
(define (overwrite-global-definition! exp)
   (match-case exp
      ((lprim (pset_global ?def) ?-)
       (overwrite-one-global-definition! def))
      ((lsequence
	(lprim (pset_global ?def) ?-)
	?rest)
       (overwrite-one-global-definition! def)
       (overwrite-global-definition! rest))))
       
;*---------------------------------------------------------------------*/
;*    overwrite-one-global-definition! ...                             */
;*---------------------------------------------------------------------*/
(define (overwrite-one-global-definition! def)
   (let* ((module (cadr def))
	  (name  (if (symbol? (caddr def))
		     (caddr def)
		     (string->symbol (string-append
				      (caddr def)
				      "_"
				      (integer->string
				       (get-hash-number (caddr def)))))))
	  (fname  (symbol-append name '@ (string->symbol module)))
	  (old    (getprop fname 'global)))
      (cond
	 ((not old)
	  ;; on a rien sous ce nom, on ne fait donc rien
	  'done)
	 ((not (global-defined? old))
	  ;; on a deja une globale mais on n'a pas trouve sa definition,
	  ;; on ne fait donc rien non plus
	  'done)
	 (else
	  ;; on a deja une global definie, on fait une alpha conversion
	  ;; sur l'ancienne version
	  (let ((new-name (gensym)))
	     (remprop! fname 'global)
	     (putprop! (symbol-append new-name '@ (string->symbol module))
		       'global old)
	     (global-name-set! old new-name)
	     (global-exported?-set! old #f)
	     'done)))))
	  
	  
	  
      
   
