;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.6/Llib/expand.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Sep  3 10:33:21 1992                          */
;*    Last change :  Thu Nov 25 19:35:58 1993 (serrano)                */
;*                                                                     */
;*    Le macro-expanseur `runtime'                                     */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expand
   (import (__expander            "Llib/expander.scm")
	   (__expander_let        "Llib/expd-let.scm")
	   (__expander_bool       "Llib/expd-bool.scm")
	   (__expander_case       "Llib/expd-case.scm")
	   (__expander_define     "Llib/expd-define.scm")
	   (__expander_do         "Llib/expd-do.scm")
	   (__expander_try        "Llib/expd-try.scm")
	   (__expander_struct     "Llib/expd-struct.scm")
	   (__match_expand        "Match/expand.scm")
	   (__rgc_expand          "Rgc/expand.scm")
	   (__eval                "Llib/eval.scm"))
   (export (expand                x)
	   (install-expander      keyword function)
	   (expand-once           x)
	   *eval-nil*))

;*---------------------------------------------------------------------*/
;*    *eval-nil* ...                                                   */
;*---------------------------------------------------------------------*/
(define *eval-nil* #t)

;*---------------------------------------------------------------------*/
;*    expand ...                                                       */
;*---------------------------------------------------------------------*/
(define (expand x)
   (initial-eval-expander x initial-eval-expander))

;*---------------------------------------------------------------------*/
;*    initial-eval-expander ...                                        */
;*---------------------------------------------------------------------*/
(define (initial-eval-expander x e)
   (let ((e1 (cond
		((symbol? x)
		 *identifier-eval-expander*)
		((not (pair? x))
		 (lambda (x e) x))
		((symbol? (car x))
		 (let ((b (interpreted-expander (car x))))
		    (if b
			b
			*application-eval-expander*)))
		(else
		 *application-eval-expander*))))
      (e1 x e)))

;*---------------------------------------------------------------------*/
;*    interpreted-expander ...                                         */
;*---------------------------------------------------------------------*/
(define (interpreted-expander keyword)
   (getprop keyword 'macro-for-eval))

;*---------------------------------------------------------------------*/
;*    expand-once ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-once x)
   (initial-eval-expander x (lambda (x e) x)))

;*---------------------------------------------------------------------*/
;*    *identifier-eval-expander* ...                                   */
;*---------------------------------------------------------------------*/
(define (*identifier-eval-expander* x e)
   x)

;*---------------------------------------------------------------------*/
;*    *application-eval-expander* ...                                  */
;*---------------------------------------------------------------------*/
(define (*application-eval-expander* x e)
   (let loop ((x x))
      (cond
	 ((null? x)
	  '())
	 ((not (pair? x))
	  (error "application" "Illegal form" x))
	 (else
	  (cons (e (car x) e) (loop (cdr x)))))))

;*---------------------------------------------------------------------*/
;*    install-expander ...                                             */
;*---------------------------------------------------------------------*/
(define (install-expander keyword function)
   (let ((x (interpreted-expander keyword)))
      (if x
	  (begin
	     (fprint (current-error-port)
		     "*** WARNING:bigloo:eval"
		     #\Newline
		     "redefinition of expander -- "
		     keyword)))
      (putprop! keyword 'macro-for-eval function)))

;*---------------------------------------------------------------------*/
;*    On initialise maintenant tous les expanders classiques           */
;*---------------------------------------------------------------------*/
;; quote
(install-expander 'quote expand-eval-quote)
;; module
(install-expander 'module (lambda (x e) x))
;; lambda
(install-expander 'lambda expand-eval-lambda)
;; quasiquote
(install-expander 'quasiquote (lambda (x e)
				 (e (quasiquotation 1 x) e)))
;; let
(install-expander 'let expand-eval-let)
;; let*
(install-expander 'let* expand-eval-let*)
;; letrec
(install-expander 'letrec expand-eval-letrec)
;; labels
(install-expander 'labels expand-eval-labels)
;; define
(install-expander 'define expand-eval-define)
;; define-inline
(install-expander 'define-inline expand-eval-define-inline)
;; define-struct
(install-expander 'define-struct expand-eval-define-struct)
;*---------------------------------------------------------------------*/
;*    Pour les deux macros qui suivent, on est oblige de reconstruire  */
;*    une fermeture car ce module est initialise avant que les         */
;*    fermetures le soient dans leur module                            */
;*---------------------------------------------------------------------*/
;; define-macro  
(install-expander 'define-macro (lambda (x e)
				   (expand-eval-define-macro x e)))
;; define-expander
(install-expander 'define-expander (lambda (x e)
				      (expand-eval-define-expander x e)))
;; if
(install-expander 'if (lambda (x e) (match-case x
				       ((if ?si ?alors ?sinon)
					`(if ,(expand-test si e)
					     ,(e alors e)
					     ,(e sinon e)))
				       ((if ?si ?alors)
					`(if ,(expand-test si e)
					     ,(e alors e)
					     #f))
				       (else
					(error "if" "Illegal form" x)))))
;; or
(install-expander 'or (lambda (x e) (e (expand-eval-or x) e)))
;; and
(install-expander 'and (lambda (x e) (e (expand-eval-and x) e)))
;; cond
(install-expander 'cond (lambda (x e) (e (expand-eval-cond x) e)))
;; case
(install-expander 'case expand-eval-case)
;; do
(install-expander 'do expand-eval-do)
;; bind-exit
(install-expander 'bind-exit (lambda (x e)
				(match-case x
				   ((?- (?exit) . ?body)
				    `(bind-exit (,exit)
						,(e (normalize-progn body)
						    e)))
				   (else
				    (error "bind-exit" "Illegal form" x)))))
;; try
(install-expander 'try expand-try)
;; match-case
(install-expander 'match-case (lambda (x e)
				 (e (expand-match-case x) e)))
;; match-lambda
(install-expander 'match-lambda (lambda (x e)
				   (e (expand-match-lambda x) e)))
;; define-pattern
(install-expander 'define-pattern (lambda (x e) 
				     (e (expand-define-pattern x) e)))
;; delay
(install-expander 'delay
		  (lambda (x e)
		     (match-case x
			((?- ?exp)
			 `(make-promise (lambda () ,(e exp e))))
			(else
			 (error "delay"
				"Illegal form"
				x)))))
;; begin
(install-expander 'begin 
		  (lambda (x e)
		     (match-case x
			((?- . ?body)
			 `(begin ,@(map (lambda (x) (e x e))
					body)))
			(else
			 (error "begin"
				"Illegal form"
				x)))))
;; grammar
(install-expander 'regular-grammar expand-regular-grammar)
;; regular-search
(install-expander 'regular-search expand-regular-search)


;*---------------------------------------------------------------------*/
;*    expand-test ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-test x e)
   (if *eval-nil*
       (e x e)
       `((lambda (test-aux-for-nil)
	    (if test-aux-for-nil
		(if (null? test-aux-for-nil)
		    #f
		    #t)
		#f))
	 ,(e x e)))) 

